<?php

if ( ! function_exists( 'woocommerce_mini_cart' ) ) {
	return '';
}

if ( ! isset( $device ) ) {
	$device = 'desktop';
}

$hidden = rishi__cb_customizer_default_akg( 'header_hide_cart', $atts, false );

if ( $hidden ) return '';

$has_only_item = false;
$has_only_cart = false;

if ( isset( $render_args['only_item'] ) ) {
	$has_only_item = $render_args['only_item'];
}

if ( isset( $render_args['only_cart'] ) ) {
	$has_only_cart = $render_args['only_cart'];
}

$svgs = apply_filters(
	'rt:header:cart:icons',
	array(
		'type-1' => '<svg width="15" height="15" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M6.41665 6.16665C6.41665 3.17513 8.8418 0.75 11.8333 0.75C14.8249 0.75 17.25 3.17513 17.25 6.16665V7.75H20C20.39 7.75 20.715 8.049 20.7474 8.4377L21.9141 22.4377C21.9315 22.6468 21.8606 22.8535 21.7186 23.0079C21.5765 23.1622 21.3764 23.25 21.1666 23.25H2.5C2.29026 23.25 2.0901 23.1622 1.94809 23.0079C1.80607 22.8535 1.73517 22.6468 1.75259 22.4377L2.91926 8.4377C2.95165 8.049 3.2766 7.75 3.66667 7.75H6.41665V6.16665ZM15.75 7.75H7.91665V6.16665C7.91665 4.00355 9.6702 2.25 11.8333 2.25C13.9964 2.25 15.75 4.00355 15.75 6.16665V7.75Z" stroke="none"/></svg>',

		'type-2' => '<svg width="15" height="15" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M18 18C16.9038 18 16 18.8846 16 20C16 21.0962 16.8846 22 18 22C19.0962 22 20 21.1154 20 20C19.9808 18.9038 19.0962 18 18 18Z" stroke="none"/><path d="M21.2662 5.36093C21.2212 5.36093 21.1539 5.33775 21.0865 5.33775H6.94004L6.71549 3.78477C6.58076 2.7649 5.72748 2 4.71702 2H3C2.5 2 2 2.5 2 3C2 3.5 2.5 4 3 4C3 4 4.60475 4 4.71702 4C4.8293 4 4.91911 4.09272 4.94157 4.20861C4.96402 4.3245 6.33376 13.8444 6.33376 13.8444C6.5134 15.0728 7.54632 16 8.75887 16H18.1C19.2677 16 20.2781 15.1424 20.5252 13.9603L21.9847 6.42715C22.0745 5.9404 21.7602 5.45364 21.2662 5.36093Z" stroke="none"/><path d="M8.96972 18C7.82803 18.058 6.96192 18.9855 7.00129 20.087C7.04066 21.1498 7.92645 22 9.00909 22H9.04846C10.1705 21.942 11.0563 21.0145 10.9972 19.913C10.9578 18.8502 10.0524 18 8.96972 18Z" stroke="none"/></svg>',

		'type-3' => '<svg width="15" height="15" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M1.46398 9.50757C1.16228 9.50757 0.9409 9.79112 1.01408 10.0838L3.94062 21.79C4.04385 22.2029 4.41483 22.4926 4.84044 22.4926H19.1595C19.5851 22.4926 19.9561 22.2029 20.0593 21.79L22.9859 10.0838C23.0591 9.79112 22.8377 9.50757 22.536 9.50757H1.46398ZM12 13.6813C10.7194 13.6813 9.68125 14.7195 9.68125 16.0001C9.68125 17.2807 10.7194 18.3188 12 18.3188C13.2806 18.3188 14.3187 17.2807 14.3187 16.0001C14.3187 14.7195 13.2806 13.6813 12 13.6813Z" stroke="none"/><path d="M18.5 10.5L13.5887 4.07758C12.7882 3.03078 11.2118 3.03078 10.4113 4.07758L5.5 10.5" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" fill="none"/></svg>',

		'type-4' => '<svg class="cb__icon" width="15" height="15" viewBox="0 0 10 10"><path d="M7.2 2.1V1c0-.6-.5-1-1.1-1H3.9c-.6 0-1.1.4-1.1 1v1H0v7c0 .6.5 1 1.1 1h7.8c.6 0 1.1-.5 1.1-1V2.1H7.2zM3.8.9h2.5v1.2H3.8V.9zM9 9.1H1v-6h8v6zM2.9 4.7c0-.3.2-.5.5-.5s.6.2.6.5-.3.5-.6.5-.5-.2-.5-.5zm3.1 0c0-.3.2-.5.5-.5s.5.2.5.5-.2.5-.5.5c-.2 0-.5-.2-.5-.5z"/></svg>',

		'type-5' => '<svg class="cb__icon" width="15" height="15" viewBox="0 0 10 10"><path d="M9.5 2.1V2L8.1.2C8 .1 7.9 0 7.7 0H2.3c-.2 0-.3.1-.4.2L.5 2v6.7c0 .8.6 1.4 1.4 1.4h6.4c.8 0 1.4-.6 1.4-1.4V2.3c-.2-.1-.2-.1-.2-.2zM2.5.9h5l.7.9H1.8l.7-.9zm5.7 8.2H1.8c-.3 0-.5-.2-.5-.5V2.7h7.3v5.9c0 .3-.2.5-.4.5zm-.9-5c0 1.3-1 2.3-2.3 2.3s-2.3-1-2.3-2.3c0-.3.2-.5.5-.5s.5.2.5.5c0 .8.6 1.4 1.4 1.4s1.4-.6 1.4-1.4c0-.3.2-.5.5-.5.1 0 .3.2.3.5z"/></svg>',

		'type-6' => '<svg class="cb__icon" width="15" height="15" viewBox="0 0 10 10"><path d="M10 4.2c0-.1-.1-.2-.2-.3-.1-.3-.4-.4-.6-.4h-.9L5.8.9C5.6.6 5.3.5 5 .5c-.3 0-.6.1-.8.4L1.7 3.5H.8c-.2 0-.5.1-.6.3-.1.1-.2.3-.2.5V4.9l.6 3.4c.1.8.8 1.3 1.5 1.3H7.8c.7 0 1.4-.6 1.5-1.3l.6-3.4v-.3-.2c.1-.1.1-.2.1-.2zM4.7 1.4c.1-.1.2-.2.3-.2s.2 0 .3.1l2 2.1H2.7l2-2zM2.9 7.8c-.2 0-.4-.1-.4-.4l-.1-1.7c0-.2.2-.4.4-.4s.3.2.4.4l.1 1.8c0 .1-.2.2-.4.3zm2.5-.4c0 .2-.2.4-.4.4s-.4-.2-.4-.4V5.6c0-.2.2-.4.4-.4s.4.2.4.4v1.8zm2.2-1.7l-.2 1.7c0 .2-.2.4-.4.4s-.3-.2-.3-.4l.1-1.8c0-.2.2-.4.4-.4s.4.2.4.5c0-.1 0-.1 0 0z"/></svg>',
	)
);


// $class = 'rt-header-cart';
$class = 'cb__header-cart';

$item_visibility = rishi__cb_customizer_default_akg(
	'header_search_visibility',
	$atts,
	array(
		'tablet' => true,
		'mobile' => true,
	)
);

$class .= ' ' . rishi__cb_customizer_visibility_classes( $item_visibility );


$badge_output = '';

if ( rishi__cb_customizer_default_akg( 'has_cart_badge', $atts, 'yes' ) !== 'yes' ) {
	$badge_output = 'data-skip-badge';
}

$has_cart_dropdown = rishi__cb_customizer_default_akg(
	'has_cart_dropdown',
	$atts,
	'yes'
) === 'yes';

$cart_drawer_type = rishi__cb_customizer_default_akg( 'cart_drawer_type', $atts, 'dropdown' );

$cart_total_class = 'cb__label';

$cart_subtotal_visibility = rishi__cb_customizer_default_akg(
	'cart_subtotal_visibility',
	$atts,
	array(
		'desktop' => true,
		'tablet'  => true,
		'mobile'  => true,
	)
);

$cart_total_class .= ' ' . rishi__cb_customizer_visibility_classes( $cart_subtotal_visibility );
$has_subtotal      = ( rishi__cb_customizer_some_device( $cart_subtotal_visibility )
	||
	is_customize_preview() );

$cart_total_position = rishi__cb_customizer_expand_responsive_value(
	rishi__cb_get_akv( 'cart_total_position', $atts, 'left' )
);


$type = rishi__cb_customizer_default_akg( 'mini_cart_type', $atts, 'type-1' );

if ( empty( $type ) ) {
	$type = 'type-1';
}

// $item_class = 'rt-cart-item';
$item_class = 'cb__cart-item';

$url = wc_get_cart_url();

$auto_open_output = '';

if ( $has_cart_dropdown && $cart_drawer_type === 'offcanvas' ) {
	$item_class .= ' cb__offcanvas-trigger';
	$url         = '#woo-cart-panel';

	$auto_open_cart = rishi__cb_customizer_default_akg(
		'auto_open_cart',
		$atts,
		array(
			'archive' => false,
			'product' => false,
		)
	);

	$components = array();


	if ( $auto_open_cart['archive'] ) {
		$components[] = 'archive';
	}

	if ( $auto_open_cart['product'] ) {
		$components[] = 'product';
	}

	if ( ! empty( $components ) ) {
		$auto_open_output = 'data-auto-open="' . implode( ':', $components ) . '"';
	}
}

$url = apply_filters( 'rt:header:cart:url', $url );

ob_start();

$data_count_output = '';
$current_count     = WC()->cart->get_cart_contents_count();

if ( intval( $current_count ) > 0 ) {
	$data_count_output = 'style="--counter: \'' . esc_attr( $current_count ) . '\'"';
}

?>

<a class="<?php echo $item_class; ?>" href="<?php echo esc_attr( $url ); ?>" <?php echo wp_kses_post( $badge_output ); ?> <?php echo $data_count_output; ?> data-label="<?php echo $cart_total_position[ $device ]; ?>" aria-label="<?php echo __( 'Cart', 'rishi' ); ?>" <?php echo $auto_open_output; ?>>

	<?php if ( $has_subtotal ) { ?>
		<span class="<?php echo $cart_total_class; ?>">
			<?php echo WC()->cart->get_cart_subtotal(); ?>
		</span>
	<?php } ?>


	<span class="cb__icon-container">
		<?php
		/**
		 * Note to code reviewers: This line doesn't need to be escaped.
		 * The value used here escapes the value properly.
		 * It contains an inline SVG, which is safe.
		 */
		echo $svgs[ $type ]
		?>
	</span>
</a>

<?php

$item = ob_get_clean();

if ( $has_only_item ) {
	echo $item;
	return;
}

if ( $has_only_cart ) {
	if ( $has_cart_dropdown && $cart_drawer_type === 'dropdown' ) {
		ob_start();
		woocommerce_mini_cart();
		$content = ob_get_clean();

		echo rishi__cb_html_tag(
			'div',
			array( 'class' => 'cb__cart-content' ),
			$content
		);
	}
	return;
}

?>

<div class="<?php echo esc_attr( $class ); ?>" <?php echo rishi__cb_customizer_attr_to_html( $attr ); ?>>

	<?php
	echo $item;

	if ( $has_cart_dropdown && $cart_drawer_type === 'dropdown' ) {
		ob_start();
		woocommerce_mini_cart();
		$content = ob_get_clean();

		echo rishi__cb_html_tag(
			'div',
			array( 'class' => 'cb__cart-content' ),
			$content
		);
	}
	?>
</div>
