<?php


class td_woo_config {

	static $js_files_for_front = array (
		'tdwSearch' => '/assets/js/tdwSearch.js', //  add the search js
		'tdwVariationSwitches' => '/assets/js/tdwVariationSwitches.js', //  add the variation switches js
		'tdwFilter' => '/assets/js/tdwFilter.js', //  add tdw filter js
		'tdwLoop' => '/assets/js/tdwLoop.js', //  add tdw loop block js
		'tdwFiltersList' => '/assets/js/tdwFiltersList.js', //  add tdw filters list block js
		'tdwFavourites' => '/assets/js/tdwFavourites.js', //  add tdw favourites
	);

    static $js_external_files_for_front = array (
	    'modernizr-custom-17475' => '/assets/js/external/modernizr.custom.17475.js',
	    'elastislide-jquerypp-custom' => '/assets/js/external/jquerypp.custom.js',
	    'elastislide-jquery' => '/assets/js/external/jquery.elastislide.js',
        // 'variation-switches-ref' => '/assets/js/external/variation-switches-ref.js'   the external file was refactore to tdwVariationSwitches, check $js_files_for_front;
    );

    static $js_panel_files = array (
            'tdWooPanelVueComponents' => '/assets/js/panel/tdWooPanelVueComponents.js',
   );

    static $js_admin_files = array (
            'tdWooAdmin' => '/assets/js/admin/tdWooAdmin.js',
   );

	static function on_tdc_loaded() {

        self::register_styles();

		/* td woo single product shortcodes */
		td_api_block::add( 'td_woo_product_image',
			array(
				'map_in_td_composer' => true,
				"name" => 'Woo Product Image',
				"base" => "td_woo_product_image",
				'tdc_category' => 'WooCommerce Single',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_product_image.php',
                'tdc_style_params' => array(
                    'sample_data_type',
                    'product_gallery',
                    'el_class'
                ),
                'tdc_start_values' => base64_encode(
                    json_encode(
                        array(
                            array(
                                "imgs_on_row" => "20%",
                                "imgs_gap" => "2",
                                "slider_space" => "2",
                            ),
                        )
                    )
                ),
				'params' => array_merge(
					array(
						array(
							"param_name" => "sample_data_type",
							"type" => "dropdown",
							"value" => array(
								'Default' => 'simple',
								'Gallery' => 'gallery',
							),
							"heading" => 'Select Sample Data Type',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big"
						),
						array(
							"param_name"  => "product_gallery",
							"type"        => "dropdown",
							"value"       => array(
								'Default' => '',
								'Carousel Horizontal' => 'carousel_horizontal',
								'Carousel Vertical' => 'carousel_vertical',
							),
							"heading"     => 'Product Gallery',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-dropdown-big",
							"group"       => "",
						),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Sale tag',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name"  => "sale_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "sale_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "10",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "sale_border",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "sale_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => 'solid',
                                'Dashed' => 'dashed',
                                'Dotted' => 'dotted',
                                'Double' => 'double',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                        ),
                        array(
                            "param_name"  => "sale_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Carousel slider',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name"  => "slider_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Top space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "slider_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "",
                        ),
                        array(
                            'param_name' => 'slider_border',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Border size',
                            'description' => '',
                            'class' => 'tdc-textfield-big',
                            'placeholder' => '0'
                        ),
                        array(
                            "param_name" => "slider_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => '',
                                'Dashed' => 'dashed',
                                'Dotted' => 'dotted',
                                'Double' => 'double',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Images',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "imgs_on_row",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                '1'  => '100%',
                                '2'  => '50%',
                                '3'  => '33.33333333%',
                                '4'  => '25%',
                                '5'  => '20%',
                                '6'  => '16.66666667%',
                                '7'  => '14.28571428%',
                                '8'  => '12.5%',
                                '9'  => '11.11111111%',
                                '10' => '10%',
                            ),
                            "heading"     => 'Images per row',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-small",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "imgs_gap",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Gap',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "img_vertical",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width on Carousel Vertical',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "90",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small"
                        ),
                        array(
                            'param_name'  => 'imgs_opacity',
                            'type'        => 'range-responsive',
                            'value'       => '0.5',
                            'heading'     => 'Opacity',
                            'description' => '',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '1',
                            'range_step'  => '0.1',
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "imgs_border",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "imgs_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => '',
                                'Dashed' => 'dashed',
                                'Dotted' => 'dotted',
                                'Double' => 'double',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small"
                        ),
                        array(
                            'param_name'  => 'imgs_opacity_a',
                            'type'        => 'range-responsive',
                            'value'       => '1',
                            'heading'     => 'Active opacity',
                            'description' => '',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '1',
                            'range_step'  => '0.1',
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "imgs_border_a",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Active border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "imgs_border_style_a",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => '',
                                'Dashed' => 'dashed',
                                'Dotted' => 'dotted',
                                'Double' => 'double',
                            ),
                            "heading" => 'Active border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Navigation',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            'type' => 'range-responsive',
                            'param_name' => 'icon_size',
                            'value' => '19',
                            'heading' => 'Icons size (px)',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '10',
                            'range_max' => '100',
                            'range_step' => '1',
                        ),
                        array(
                            'param_name' => 'icon_spacing',
                            'type' => 'range-responsive',
                            'value' => '1.4',
                            'heading' => 'Icons spacing',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '1',
                            'range_max' => '3',
                            'range_step' => '0.1',
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Style',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Sale tag',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Text color',
                            "param_name"  => "sale_txt_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Background color',
                            "param_name"  => "sale_bg_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Border color',
                            "param_name"  => "sale_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_sale', true, 'Sale tag text'),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Zoom icon',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Icon color',
                            "param_name"  => "zoom_ico_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Icon hover color',
                            "param_name"  => "zoom_ico_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Background color',
                            "param_name"  => "zoom_bg_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Background hover color',
                            "param_name"  => "zoom_bg_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Gallery slider',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Background color',
                            "param_name"  => "slider_bg_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Border color',
                            "param_name"  => "slider_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small"
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Images border color',
                            "param_name"  => "imgs_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Images active border color',
                            "param_name"  => "imgs_border_color_a",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small"
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Navigation icons color',
                            "param_name"  => "nav_ico_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Navigation icons hover color',
                            "param_name"  => "nav_ico_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Navigation background color',
                            "param_name"  => "nav_bg_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Navigation background hover color',
                            "param_name"  => "nav_bg_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Zoomed image modal',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Background color',
                            "param_name"  => "modal_bg_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Image title color',
                            "param_name"  => "modal_title_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small"
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Arrows color',
                            "param_name"  => "modal_arrow_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Arrows hover color',
                            "param_name"  => "modal_arrow_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
					),
					self::get_block_style()
				),
			)

		);
        td_api_block::add( 'td_woo_product_image_bg',
            array(
                'map_in_td_composer' => true,
                "name" => 'Woo Product Background Image',
                "base" => "td_woo_product_image_bg",
                'tdc_category' => 'WooCommerce Single',
                'file' => TD_WOO_DIR . '/shortcodes/td_woo_product_image_bg.php',
                'tdc_style_params' => array(
                    'el_class'
                ),
                'params' => array_merge(
                    array(
                        array(
                            "param_name"  => "image_size",
                            "type"        => "dropdown-responsive",
                            "value"       => self::get_theme_thumbs_full(),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big"
                        ),
                        array(
                            "param_name" => "block_height",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Image height',
                            "description" => "",
                            "placeholder" => "600",
                            "holder" => "div",
                            "class" => "tdc-textfield-small"
                        ),
                        array(
                            'param_name'  => 'image_alignment',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                        ),
                        array(
                            "param_name" => "img_circle",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Rounded image",
                            "description" => "",
                            "holder" => "div",
                            "class" => ""
                        ),
                        array(
                            "param_name" => "img_fixed",
                            "type" => "checkbox-responsive",
                            "value" => '',
                            "heading" => "Fixed image",
                            "description" => "",
                            "holder" => "div",
                            "class" => ""
                        ),
                        array(
                            "param_name" => "overlay",
                            "type" => "gradient",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Overlay color',
                            "value" => '',
                            "description" => '',
                        ),
                        array(
                            "param_name" => "hide_img",
                            "type" => "checkbox",
                            "value" => 'yes',
                            "heading" => "Hide when no featured image",
                            "description" => "",
                            "holder" => "div",
                            "class" => ""
                        ),
                    ),
                    td_config_helper::mix_blend(),
                    td_config_helper::image_filters(),
                    self::get_block_style()
                ),
            )

        );
		td_api_block::add( 'td_woo_product_price',
			array(
				'map_in_td_composer' => true,
				"name" => 'Woo Product Price',
				"base" => "td_woo_product_price",
				'tdc_category' => 'WooCommerce Single',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_product_price.php',
                'tdc_style_params' => array(
                    'add_text',
                    'el_class'
                ),
				'params' => array_merge(
					array(
                        array(
                            'param_name' => 'add_text',
                            'type' => 'textarea_raw_html',
                            'value' => '',
                            'heading' => 'Additional text',
                            'description' => '',
                            'class' => 'tdc-textarea-xxsmall',
                        ),
                        array(
                            'param_name' => 'add_space',
                            'type' => 'range-responsive',
                            'value' => '0',
                            'heading' => 'Text space',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '0',
                            'range_max' => '30',
                            'range_step' => '1',
                        ),
                        array(
                            "param_name" => "content_align_horizontal",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Style',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Additional text color',
                            "param_name"  => "add_text_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Price color',
                            "param_name"  => "price_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Sale price color',
                            "param_name"  => "sale_price_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Old price color',
                            "param_name"  => "old_price_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Fonts',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_text', true, 'Additional text' ),
                    td_config_helper::get_map_block_font_array( 'f_price', false, 'Price text' ),
                    td_config_helper::get_map_block_font_array( 'f_old_price', false, 'Old price text' ),

                    self::get_block_style()
				),
			)

		);
		td_api_block::add( 'td_woo_product_attributes',
			array(
				'map_in_td_composer' => true,
				"name" => 'Woo Product Attributes',
				"base" => "td_woo_product_attributes",
				'tdc_category' => 'WooCommerce Single',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_product_attributes.php',
                'tdc_style_params' => array(
                    'custom_title',
                    'el_class'
                ),
				'params' => array_merge(
					array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Header settings',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "custom_title",
                            "type" => "textfield",
                            "value" => "",
                            "heading" => 'Custom title:',
                            "description" => "Optional - a title for this block, if you leave it blank the block will not have a title",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig",
                        ),
                        array(
                            "param_name" => "block_template_id",
                            "type" => "dropdown",
                            "value" => td_util::get_block_template_ids(),
                            "heading" => 'Header template:',
                            "description" => "Header template used by the current block",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big"
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Layout',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name"  => "label_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Label padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => '7px 14px',
                        ),
                        array(
                            "param_name"  => "val_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Value padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => '7px 14px',
                        ),
                        array(
                            "param_name" => "label_horiz",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Label horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                        ),
                        array(
                            "param_name" => "value_horiz",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Value horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Borders',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "box_border",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Box border size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => '1px 1px 1px 1px',
                        ),
                        array(
                            "param_name"  => "row_border",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Row border size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '1',
                        ),
                        array(
                            "param_name"  => "sep_border",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Separator border size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '1',
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Style',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Rows background color',
                            "param_name"  => "row_bg_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Rows background alternative color',
                            "param_name"  => "row_bg_color_a",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Labels text color',
                            "param_name"  => "label_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Values text color',
                            "param_name"  => "value_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Borders color',
                            "param_name"  => "border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Fonts',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
					),
                    td_config_helper::get_map_block_font_array( 'f_header', true, 'Block header' ),
                    td_config_helper::get_map_block_font_array( 'f_label', false, 'Labels text' ),
                    td_config_helper::get_map_block_font_array( 'f_value', false, 'Values text' ),

                    self::get_block_style()
				),
			)
		);
		td_api_block::add( 'td_woo_product_description',
			array(
				'map_in_td_composer' => true,
				"name" => 'Woo Product Description',
				"base" => "td_woo_product_description",
				'tdc_category' => 'WooCommerce Single',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_product_description.php',
                'tdc_style_params' => array(
                    'el_class'
                ),
				'params' => array_merge(
                    array(
						array(
							"param_name" => "type",
							"type" => "dropdown",
							"value" => array(
								'Default' => 'default',
								'Short' => 'short',
							),
							"heading" => 'Select Description Type',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big"
						),
                        array(
                            "param_name" => "content_align_horizontal",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Description color',
                            "param_name"  => "descr_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "h_color",
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'H1-6 color',
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "a_color",
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Links color',
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "a_hover_color",
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Links hover color',
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "bq_color",
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Default blockquote color',
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_descr', true, 'Description text' ),
                    td_config_helper::get_map_block_font_array( 'f_h1', false, 'H1' ),
                    td_config_helper::get_map_block_font_array( 'f_h2', false, 'H2' ),
                    td_config_helper::get_map_block_font_array( 'f_h3', false, 'H3' ),
                    td_config_helper::get_map_block_font_array( 'f_h4', false, 'H4' ),
                    td_config_helper::get_map_block_font_array( 'f_h5', false, 'H5' ),
                    td_config_helper::get_map_block_font_array( 'f_h6', false, 'H6' ),
                    td_config_helper::get_map_block_font_array( 'f_list', false, 'Lists' ),
                    td_config_helper::get_map_block_font_array( 'f_bq', false, 'Default blockquote' ),
                    self::get_block_style()
                )
			)

		);
		td_api_block::add( 'td_woo_product_categories',
			array(
				'map_in_td_composer' => true,
				"name" => 'Woo Product Categories',
				"base" => "td_woo_product_categories",
				'tdc_category' => 'WooCommerce Single',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_product_categories.php',
                'tdc_style_params' => array(
                    'add_text',
                    'el_class'
                ),
                'tdc_start_values' => base64_encode(
                    json_encode(
                        array(
                            array(
                                "add_text" => "Q2F0ZWdvcnklM0ElMjA=",
                            ),
                        )
                    )
                ),
				'params' => array_merge(
					array(
                        array(
                            'param_name' => 'add_text',
                            'type' => 'textarea_raw_html',
                            'value' => '',
                            'heading' => 'Additional text',
                            'description' => '',
                            'class' => 'tdc-textarea-xxsmall',
                        ),
                        array(
                            'param_name' => 'add_space',
                            'type' => 'range-responsive',
                            'value' => '3',
                            'heading' => 'Text space',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '0',
                            'range_max' => '30',
                            'range_step' => '1',
                        ),
                        array(
                            "param_name" => "content_align_horizontal",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Style',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name"  => "cat_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Categories padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                        ),
                        array(
                            "param_name"  => "cat_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Categories spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                        ),
                        array(
                            'param_name' => 'cat_radius',
                            'type' => 'range-responsive',
                            'value' => '0',
                            'heading' => 'Border radius',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '0',
                            'range_max' => '100',
                            'range_step' => '1',
                        ),
                        array(
                            'param_name' => 'cat_border',
                            'type' => 'range-responsive',
                            'value' => '0',
                            'heading' => 'Border size',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '0',
                            'range_max' => '10',
                            'range_step' => '1',
                        ),
                        array(
                            'param_name' => 'cat_skew',
                            'type' => 'range-responsive',
                            'value' => '0',
                            'heading' => 'Skew',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '-40',
                            'range_max' => '40',
                            'range_step' => '1',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "show_sep",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show separator',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name" => "bg_color",
                            "type" => "gradient",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Background color',
                            "value" => '',
                            "description" => '',
                        ),
                        array(
                            "param_name" => "bg_hover_color",
                            "type" => "gradient",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Background hover color',
                            "value" => '',
                            "description" => '',
                        ),
                        array(
                            "param_name" => "text_color",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Text color',
                            "value" => '',
                            "description" => '',
                        ),
                        array(
                            "param_name" => "text_hover_color",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Text hover color',
                            "value" => '',
                            "description" => '',
                        ),
                        array(
                            "param_name" => "border_color",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Border color',
                            "value" => '',
                            "description" => '',
                        ),
                        array(
                            "param_name" => "border_hover_color",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Border hover color',
                            "value" => '',
                            "description" => '',
                        ),
                        array(
                            "param_name" => "txt_color",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Additional text color',
                            "value" => '',
                            "description" => '',
                        ),
                        array(
                            "param_name" => "sep_color",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Separator color',
                            "value" => '',
                            "description" => '',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small"
                        ),
                    ),

                    td_config_helper::get_map_block_font_array( 'f_cats', true, 'Categories' ),
                    td_config_helper::get_map_block_font_array( 'f_txt', false, 'Additional text' ),

                    self::get_block_style()
				),
			)

		);
		td_api_block::add( 'td_woo_product_tags',
			array(
				'map_in_td_composer' => true,
				"name" => 'Woo Product Tags',
				"base" => "td_woo_product_tags",
				'tdc_category' => 'WooCommerce Single',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_product_tags.php',
                'tdc_style_params' => array(
                    'add_text',
                    'el_class'
                ),
                'tdc_start_values' => base64_encode(
                    json_encode(
                        array(
                            array(
                                "add_text" => "VGFncyUzQSUyMA==",
                            ),
                        )
                    )
                ),
				'params' => array_merge(
                    array(
                        array(
                            'param_name' => 'add_text',
                            'type' => 'textarea_raw_html',
                            'value' => '',
                            'heading' => 'Additional text',
                            'description' => '',
                            'class' => 'tdc-textarea-xxsmall',
                        ),
                        array(
                            'param_name' => 'add_space',
                            'type' => 'range-responsive',
                            'value' => '0',
                            'heading' => 'Text space',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '0',
                            'range_max' => '30',
                            'range_step' => '1',
                        ),
                        array(
                            "param_name" => "content_align_horizontal",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Style',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name"  => "tag_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Tags padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                        ),
                        array(
                            "param_name"  => "tag_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Tags spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                        ),
                        array(
                            'param_name' => 'tag_radius',
                            'type' => 'range-responsive',
                            'value' => '0',
                            'heading' => 'Border radius',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '0',
                            'range_max' => '100',
                            'range_step' => '1',
                        ),
                        array(
                            'param_name' => 'tag_border',
                            'type' => 'range-responsive',
                            'value' => '0',
                            'heading' => 'Border size',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '0',
                            'range_max' => '10',
                            'range_step' => '1',
                        ),
                        array(
                            'param_name' => 'tag_skew',
                            'type' => 'range-responsive',
                            'value' => '0',
                            'heading' => 'Skew',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '-40',
                            'range_max' => '40',
                            'range_step' => '1',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "show_sep",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show separator',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name" => "bg_color",
                            "type" => "gradient",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Background color',
                            "value" => '',
                            "description" => '',
                        ),
                        array(
                            "param_name" => "bg_hover_color",
                            "type" => "gradient",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Background hover color',
                            "value" => '',
                            "description" => '',
                        ),
                        array(
                            "param_name" => "text_color",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Text color',
                            "value" => '',
                            "description" => '',
                        ),
                        array(
                            "param_name" => "text_hover_color",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Text hover color',
                            "value" => '',
                            "description" => '',
                        ),
                        array(
                            "param_name" => "border_color",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Border color',
                            "value" => '',
                            "description" => '',
                        ),
                        array(
                            "param_name" => "border_hover_color",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Border hover color',
                            "value" => '',
                            "description" => '',
                        ),
                        array(
                            "param_name" => "txt_color",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Additional text color',
                            "value" => '',
                            "description" => '',
                        ),
                        array(
                            "param_name" => "sep_color",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Separator color',
                            "value" => '',
                            "description" => '',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small"
                        ),
                    ),

                    td_config_helper::get_map_block_font_array( 'f_tags', true, 'Tags' ),
                    td_config_helper::get_map_block_font_array( 'f_txt', false, 'Additional text' ),

                    self::get_block_style()
				),
			)

		);
		td_api_block::add( 'td_woo_product_tabs',
			array(
				'map_in_td_composer' => true,
				"name" => 'Woo Product Tabs',
				"base" => "td_woo_product_tabs",
				'tdc_category' => 'WooCommerce Single',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_product_tabs.php',
                'tdc_style_params' => array(
                    'el_class'
                ),
				'params' => array_merge(
					array(
                        array(
                            "param_name" => "show_tab",
                            "type" => "dropdown",
                            "value" => array(
                                'Description' => '',
                                'Additional information' => 'attr_tab',
                                'Reviews' => 'rev_tab',
                            ),
                            "heading" => 'Show tab in TD Composer',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Tabs',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "tabs_horiz_align",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Tabs horiz. align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small"
                        ),
                        array(
                            "param_name"  => "tabs_ul_border",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Tabs list border size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "2",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "tabs_ul_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => '',
                                'Dashed' => 'dashed',
                                'Dotted' => 'dotted',
                                'Double' => 'double',
                            ),
                            "heading" => 'Tabs list border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small"
                        ),
                        array(
                            "param_name"  => "tabs_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Tabs space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "tabs_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Tabs padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "6px 12px 7px",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small"
                        ),
                        array(
                            "param_name"  => "tabs_border",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Tabs border size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "tabs_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => '',
                                'Dashed' => 'dashed',
                                'Dotted' => 'dotted',
                                'Double' => 'double',
                            ),
                            "heading" => 'Tabs border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                        ),
                        array(
                            "type" => 'textfield-responsive',
                            "param_name" => 'tabs_border_radius',
                            "value" => '',
                            "heading" => 'Tabs border radius',
                            "class" => 'tdc-textfield-big',
                            "description" => '',
                            "placeholder" => "0",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Style',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Tabs list border color',
                            "param_name" => "tabs_ul_border_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small"
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-triple-a",
                            "heading" => 'Tabs color',
                            "param_name" => "tabs_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-triple-b",
                            "heading" => 'Tabs hover color',
                            "param_name" => "tabs_color_h",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-triple-c",
                            "heading" => 'Tabs active color',
                            "param_name" => "tabs_color_a",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-triple-a",
                            "heading" => 'Tabs background color',
                            "param_name" => "tabs_bg_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-triple-b",
                            "heading" => 'Tabs background hover color',
                            "param_name" => "tabs_bg_color_h",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-triple-c",
                            "heading" => 'Tabs background active color',
                            "param_name" => "tabs_bg_color_a",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-triple-a",
                            "heading" => 'Tabs border color',
                            "param_name" => "tabs_border_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-triple-b",
                            "heading" => 'Tabs border hover color',
                            "param_name" => "tabs_border_color_h",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-triple-c",
                            "heading" => 'Tabs border active color',
                            "param_name" => "tabs_border_color_a",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small"
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_tabs', true, 'Tabs text' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name"  => "content_padd",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "30px 0 0",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "content_border",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "content_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => '',
                                'Dashed' => 'dashed',
                                'Dotted' => 'dotted',
                                'Double' => 'double',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                        ),
                        array(
                            "type" => 'textfield-responsive',
                            "param_name" => 'content_border_radius',
                            "value" => '',
                            "heading" => 'Border radius',
                            "class" => 'tdc-textfield-big',
                            "description" => '',
                            "placeholder" => "0",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Style',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Background color',
                            "param_name" => "content_bg_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Border color',
                            "param_name" => "content_border_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Description tab',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "content_align_horizontal",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group" => ""
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Description color',
                            "param_name"  => "descr_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                         array(
                            "param_name"  => "h_color",
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'H1-6 color',
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "a_color",
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Links color',
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "a_hover_color",
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Links hover color',
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "bq_color",
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Default blockquote color',
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_descr', true, 'Description text' ),
                    td_config_helper::get_map_block_font_array( 'f_h1', false, 'H1' ),
                    td_config_helper::get_map_block_font_array( 'f_h2', false, 'H2' ),
                    td_config_helper::get_map_block_font_array( 'f_h3', false, 'H3' ),
                    td_config_helper::get_map_block_font_array( 'f_h4', false, 'H4' ),
                    td_config_helper::get_map_block_font_array( 'f_h5', false, 'H5' ),
                    td_config_helper::get_map_block_font_array( 'f_h6', false, 'H6' ),
                    td_config_helper::get_map_block_font_array( 'f_list', false, 'Lists' ),
                    td_config_helper::get_map_block_font_array( 'f_bq', false, 'Default blockquote' ),

                    array(
                        array(
                            "param_name" => "show_attr",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none'
                            ),
                            "heading" => 'Show',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Attributes",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Layout',
                            "value"      => "",
                            "class"      => "",
                            "group"       => "Attributes",
                        ),
                        array(
                            "param_name"  => "attr_title_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Title bottom space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '20',
                            "group"       => "Attributes",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Attributes",
                        ),
                        array(
                            "param_name"  => "label_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Label padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => '7px 14px',
                            "group"       => "Attributes",
                        ),
                        array(
                            "param_name"  => "val_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Value padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => '7px 14px',
                            "group"       => "Attributes",
                        ),
                        array(
                            "param_name" => "label_horiz",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Label horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Attributes",
                        ),
                        array(
                            "param_name" => "value_horiz",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Value horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Attributes",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Borders',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Attributes",
                        ),
                        array(
                            "param_name"  => "box_border",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Box border size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => '1px 1px 1px 1px',
                            "group"       => "Attributes",
                        ),
                        array(
                            "param_name"  => "row_border",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Row border size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '1',
                            "group"       => "Attributes",
                        ),
                        array(
                            "param_name"  => "sep_border",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Separator border size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '1',
                            "group"       => "Attributes",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Style',
                            "value"      => "",
                            "group"       => "Attributes",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Title text color',
                            "param_name"  => "attr_title_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Attributes",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Attributes",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Rows background color',
                            "param_name"  => "row_bg_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Attributes",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Rows background alternative color',
                            "param_name"  => "row_bg_color_a",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Attributes",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Attributes",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Labels text color',
                            "param_name"  => "label_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Attributes",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Values text color',
                            "param_name"  => "value_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Attributes",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Attributes",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Borders color',
                            "param_name"  => "border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Attributes",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Fonts',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Attributes",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_attr_title', true, 'Title text', 'Attributes' ),
                    td_config_helper::get_map_block_font_array( 'f_attr_label', false, 'Labels text', 'Attributes' ),
                    td_config_helper::get_map_block_font_array( 'f_value', false, 'Values text', 'Attributes' ),

                    array(
                        array(
                            "param_name" => "show_rev",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none'
                            ),
                            "heading" => 'Show',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Reviews",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Layout',
                            "value"      => "",
                            "class"      => "",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Reviews settings',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name"  => "rev_title_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Title bottom space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '20',
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name"  => "rev_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Reviews bottom space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "20",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name"  => "av_border",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Avatar border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "4",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name"  => "av_border_style",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Solid'  => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Avatar border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name"  => "av_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Avatar border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name"  => "rev_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Review box padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "14px 14px 0 14px",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name"  => "rev_border",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Review box border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "1",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name"  => "rev_border_style",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Solid'  => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Review box border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name"  => "rev_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Review box border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "4",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name"  => "meta_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info bottom space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '14',
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name"  => "show_date",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name"  => "stars_size",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Rating stars size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '14',
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name"  => "stars_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Rating stars space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Review form settings',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name"  => "form_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Top space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "20",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name"  => "form_stars_size",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Rating stars size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '14',
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name"  => "label_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Labels bottom space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name"  => "input_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Inputs padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 9px",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name"  => "input_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Inputs bottom space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "10",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name"  => "input_border",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Inputs border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "1",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name"  => "input_border_style",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Solid'  => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Inputs border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name"  => "input_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Inputs border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name"  => "btn_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Button padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "10",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name"  => "btn_border",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Button border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name"  => "btn_border_style",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Solid'  => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Button border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name"  => "btn_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Button border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Style',
                            "value"      => "",
                            "class"      => "",
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Reviews settings',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Reviews",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Title color',
                            "param_name"  => "rev_title_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Reviews",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Avatar border color',
                            "param_name"  => "av_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Reviews",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Review box background color',
                            "param_name"  => "rev_bg_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Reviews",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Review box border color',
                            "param_name"  => "rev_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Reviews",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author name color',
                            "param_name"  => "auth_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Reviews",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Date color',
                            "param_name"  => "date_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Reviews",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Full stars color',
                            "param_name"  => "stars_full_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Reviews",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Empty stars color',
                            "param_name"  => "stars_empty_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Reviews",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Review text color',
                            "param_name"  => "rev_txt_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Reviews",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_rev_title', true, 'Title text', 'Reviews' ),
                    td_config_helper::get_map_block_font_array( 'f_auth', false, 'Author name text', 'Reviews' ),
                    td_config_helper::get_map_block_font_array( 'f_date', false, 'Date text', 'Reviews' ),
                    td_config_helper::get_map_block_font_array( 'f_txt', false, 'Review text', 'Reviews' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Review form settings',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Reviews",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Title color',
                            "param_name"  => "form_title_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Reviews",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Stars text color',
                            "param_name"  => "form_stars_txt_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Reviews",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Stars color',
                            "param_name"  => "form_stars_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Reviews",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Labels text color',
                            "param_name"  => "label_txt_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Reviews",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Inputs text color',
                            "param_name"  => "input_txt_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Reviews",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Inputs background color',
                            "param_name"  => "input_bg_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Reviews",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Inputs border color',
                            "param_name"  => "input_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Reviews",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Button background color',
                            "param_name"  => "btn_bg_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Reviews",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Button background hover color',
                            "param_name"  => "btn_bg_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Reviews",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Button text color',
                            "param_name"  => "btn_txt_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Reviews",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Button text hover color',
                            "param_name"  => "btn_txt_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Reviews",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Button border color',
                            "param_name"  => "btn_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Reviews",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Button border hover color',
                            "param_name"  => "btn_border_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Reviews",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group"       => "Reviews",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_form_t', true, 'Form title text', 'Reviews' ),
                    td_config_helper::get_map_block_font_array( 'f_rev_label', false, 'Labels text', 'Reviews' ),
                    td_config_helper::get_map_block_font_array( 'f_input', false, 'Inputs text', 'Reviews' ),
                    td_config_helper::get_map_block_font_array( 'f_btn', false, 'Submit button text', 'Reviews' ),

                    self::get_block_style()
				),
			)

		);
		td_api_block::add( 'td_woo_product_sku',
			array(
				'map_in_td_composer' => true,
				"name" => 'Woo Product SKU',
				"base" => "td_woo_product_sku",
				'tdc_category' => 'WooCommerce Single',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_product_sku.php',
                'tdc_style_params' => array(
                    'add_text',
                    'el_class'
                ),
                'tdc_start_values' => base64_encode(
                    json_encode(
                        array(
                            array(
                                'add_text' => 'U0tVJTNBJTIw',
                            ),
                        )
                    )
                ),
				'params' => array_merge(
					array(
                        array(
                            'param_name' => 'add_text',
                            'type' => 'textarea_raw_html',
                            'value' => '',
                            'heading' => 'Additional text',
                            'description' => '',
                            'class' => 'tdc-textarea-xxsmall',
                        ),
                        array(
                            'param_name' => 'add_space',
                            'type' => 'range-responsive',
                            'value' => '0',
                            'heading' => 'Text space',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '0',
                            'range_max' => '30',
                            'range_step' => '1',
                        ),
                        array(
                            "param_name" => "content_align_horizontal",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Style',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Additional text color',
                            "param_name"  => "add_text_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'SKU value color',
                            "param_name"  => "sku_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Fonts',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_text', true, 'Additional text' ),
                    td_config_helper::get_map_block_font_array( 'f_sku', false, 'SKU text' ),

                    self::get_block_style()
				),
			)

		);
		td_api_block::add( 'td_woo_add_to_cart',
			array(
				'map_in_td_composer' => true,
				'base' => 'td_woo_add_to_cart',
				'name' => 'Woo Add to Cart',
				'category' => 'Content',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_add_to_cart.php',
				'tdc_category' => 'WooCommerce Single',
				'tdc_style_params' => array(
					'el_class'
				),
                'tdc_start_values' => base64_encode(
                    json_encode(
                        array(
	                        array_merge(
		                        self::td_woo_attributes_start_values()
	                        )
                        )
                    )
                ),
				'params' => array_merge(
					array(
						array(
							"param_name" => "sample_data_type",
							"type" => "dropdown",
							"value" => array(
								'Default' => 'simple',
								'Variation' => 'variable',
							),
							"heading" => 'Select Sample Data Type',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big"
						),
                        array(
                            "param_name" => "make_inline",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => 'Display inline',
                            "description" => "",
                            "holder" => "div",
                            "class" => ""
                        ),
                        array(
                            "param_name" => "align_horiz",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Variations form',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            'param_name' => 'form_space',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Form bottom space',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'placeholder' => '20'
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            'param_name' => 'stock_txt_space',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Stock information bottom space',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'placeholder' => '20'
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Quantity input',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            'param_name' => 'qty_width',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Width',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'placeholder' => '50'
                        ),
                        array(
                            'param_name' => 'qty_space',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Space',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'placeholder' => '5'
                        ),
                        array(
                            'param_name' => 'qty_padding',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Padding',
                            'description' => '',
                            'class' => 'tdc-textfield-big',
                            'placeholder' => '1px 2px'
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            'param_name' => 'qty_border',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Border size',
                            'description' => '',
                            'class' => 'tdc-textfield-big',
                            'placeholder' => '1'
                        ),
                        array(
                            "param_name" => "qty_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => '',
                                'Dashed' => 'dashed',
                                'Dotted' => 'dotted',
                                'Double' => 'double',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                        ),
                        array(
                            'param_name' => 'qty_border_radius',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Border radius',
                            'description' => '',
                            'class' => 'tdc-textfield-big',
                            'placeholder' => '2'
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Button',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            'param_name' => 'button_tdicon',
                            'type' => 'icon',
                            'heading' => 'Button icon',
                            'class' => 'tdc-textfield-small tdc-hidden',
                            'value' => '',
                        ),
                        array(
                            'param_name' => 'button_icon_size',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Button icon size',
                            'description' => '',
                            'class' => 'tdc-textfield-small tdc-hidden',
                        ),
                        array(
                            "param_name" => "button_icon_position",
                            "type" => "dropdown",
                            "value" => array(
                                'After text' => '',
                                'Before text' => 'icon-before',
                            ),
                            "heading" => __( 'Button icon position', 'td_composer' ),
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big tdc-hidden",
                        ),
                        array(
                            'param_name' => 'button_icon_space',
                            'type' => 'range-responsive',
                            'value' => '14',
                            'heading' => 'Icon space',
                            'description' => '',
                            'range_min' => '0',
                            'range_max' => '50',
                            'range_step' => '1',
                            'class' => 'tdc-textfield-small tdc-hidden',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            'param_name' => 'button_width',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Button min-width',
                            'description' => 'Button width',
                            'class' => 'tdc-textfield-small',
                        ),
                        array(
                            'param_name' => 'button_padding',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Padding',
                            'description' => '',
                            'class' => 'tdc-textfield-big'
                        ),


                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Variations form',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "clear_txt_color",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Clear button color',
                            "value" => '',
                            "description" => '',
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "clear_txt_color_h",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Clear button hover color',
                            "value" => '',
                            "description" => '',
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Style",
                        ),
                        array(
                            "param_name" => "stock_txt_color",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Stock information text color',
                            "value" => '',
                            "description" => '',
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Style",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_clear', true, 'Clear button text', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_stock', false, 'Stock information text', 'Style' ),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Quantity input',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "qty_txt_color",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Text color',
                            "value" => '',
                            "description" => '',
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "qty_bg_color",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Background color',
                            "value" => '',
                            "description" => '',
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "qty_border_color",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Border color',
                            "value" => '',
                            "description" => '',
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Style",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_qty', true, 'Quantity input text', 'Style' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Button',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "tds_w_button",
                            "type" => "dropdown",
                            "value" => td_api_style::get_styles_for_mapping( 'tds_w_button', false ),
                            "heading" => 'Button style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big tdc-add-to-cart-btn-style",
                            "group" => "Style",
                        ),
                    ),

                    self::td_woo_add_to_cart_attributes_settings(),

					array(
						array(
							'param_name' => 'css',
							'value' => '',
							'type' => 'css_editor',
							'heading' => 'Css',
							'group' => 'Design options',
						),
						array(
							'param_name' => 'tdc_css',
							'value' => '',
							'type' => 'tdc_css_editor',
							'heading' => '',
							'group' => 'Design options',
						),
					)
				),
			)
		);
		td_api_block::add( 'td_woo_product_reviews',
			array(
				'map_in_td_composer' => true,
				'base' => 'td_woo_product_reviews',
				'name' => 'Woo Product Reviews',
				'category' => 'Content',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_product_reviews.php',
				'tdc_category' => 'WooCommerce Single',
				'tdc_style_params' => array(
					'el_class'
				),
				'params' => array_merge(
					array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Reviews settings',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name"  => "rev_title",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show title',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "rev_title_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Title bottom space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '20',
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "rev_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Reviews bottom space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "20",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Author avatar',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "av_border",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "4",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "av_border_style",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Solid'  => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "av_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Review box',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "rev_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "14px 14px 0 14px",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "rev_border",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "1",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "rev_border_style",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Solid'  => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "rev_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "4",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Meta info',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "meta_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Bottom space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '14',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "param_name"  => "show_date",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "stars_size",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Rating stars size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '14',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Review form settings',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name"  => "form_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Top space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "20",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "form_stars_size",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Rating stars size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '14',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Labels',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "label_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Bottom space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Inputs',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "input_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 9px",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "input_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Bottom space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "10",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "param_name"  => "input_border",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "1",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "input_border_style",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Solid'  => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "input_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Submit button',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "btn_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "10",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "param_name"  => "btn_border",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "btn_border_style",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Solid'  => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "btn_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Reviews settings',
                            "value"      => "",
                            "class"      => "",
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Title color',
                            "param_name"  => "rev_title_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Author avatar',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Border color',
                            "param_name"  => "av_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Review box',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Background color',
                            "param_name"  => "rev_bg_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Border color',
                            "param_name"  => "rev_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Meta info',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author name color',
                            "param_name"  => "auth_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Date color',
                            "param_name"  => "date_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Full stars color',
                            "param_name"  => "stars_full_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Empty stars color',
                            "param_name"  => "stars_empty_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Review text color',
                            "param_name"  => "rev_txt_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Fonts',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Style",
                        ),
					),
                    td_config_helper::get_map_block_font_array( 'f_title', true, 'Title text', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_auth', false, 'Author name text', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_date', false, 'Date text', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_txt', false, 'Review text', 'Style' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Review form settings',
                            "value"      => "",
                            "class"      => "",
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Title color',
                            "param_name"  => "form_title_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Stars text color',
                            "param_name"  => "form_stars_txt_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Stars color',
                            "param_name"  => "form_stars_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Labels',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Text color',
                            "param_name"  => "label_txt_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Inputs',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Text color',
                            "param_name"  => "input_txt_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Background color',
                            "param_name"  => "input_bg_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Border color',
                            "param_name"  => "input_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Submit button',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Background color',
                            "param_name"  => "btn_bg_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Background hover color',
                            "param_name"  => "btn_bg_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Text color',
                            "param_name"  => "btn_txt_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Text hover color',
                            "param_name"  => "btn_txt_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Border color',
                            "param_name"  => "btn_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Border hover color',
                            "param_name"  => "btn_border_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Fonts',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Style",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_form_t', true, 'Form title text', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_label', false, 'Labels text', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_input', false, 'Inputs text', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_btn', false, 'Submit button text', 'Style' ),

                    self::get_block_style()
				),
			)
		);
		td_api_block::add( 'td_woo_product_rating',
			array(
				'map_in_td_composer' => true,
				"name" => 'Woo Product Rating',
				"base" => "td_woo_product_rating",
				'tdc_category' => 'WooCommerce Single',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_product_rating.php',
				'tdc_style_params' => array(
					'add_text',
					'el_class'
				),
				'params' => array_merge(
					array(
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Layout',
							"value"      => "",
							"class"      => "",
						),
						array(
							'param_name' => 'add_text',
							'type' => 'textarea_raw_html',
							'value' => '',
							'heading' => 'Additional text',
							'description' => '',
							'class' => 'tdc-textarea-xxsmall',
						),
						array(
							'param_name' => 'add_space',
							'type' => 'range-responsive',
							'value' => '0',
							'heading' => 'Text space',
							'description' => '',
							'class' => 'tdc-textfield-small',
							'range_min' => '0',
							'range_max' => '30',
							'range_step' => '1',
						),
						array(
							"param_name" => "content_align_horizontal",
							"type" => "dropdown-responsive",
							"value" => array(
								'Left' => 'content-horiz-left',
								'Center' => 'content-horiz-center',
								'Right' => 'content-horiz-right'
							),
							"heading" => 'Horizontal align',
							"description" => "",
							"holder" => "div",
							'tdc_dropdown_images' => true,
							"class" => "tdc-visual-selector tdc-add-class",
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Stars',
							"value"      => "",
							"class"      => "tdc-separator-small",
						),
						array(
							"param_name"  => "stars_size",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Size',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => '14',
						),
                        array(
                            "param_name"  => "stars_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Stars space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '0',
                        ),
						array(
							"param_name"  => "stars_space",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Right space',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => '4',
						),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Reviews link',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "link_show",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show'  => 'block',
                                'Hide'  => 'none',
                            ),
                            "heading"     => 'Show reviews link',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "",
                        ),

						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Style',
							"value"      => "",
							"class"      => "",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "",
							"heading"     => 'Additional text color',
							"param_name"  => "add_txt_color",
							"value"       => '',
							"description" => '',
							"group"       => "",
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => "",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "",
							"heading"     => 'Full stars color',
							"param_name"  => "stars_full_color",
							"value"       => '',
							"description" => '',
							"group"       => "",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "",
							"heading"     => 'Empty stars color',
							"param_name"  => "stars_empty_color",
							"value"       => '',
							"description" => '',
							"group"       => "",
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => "",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Reviews link color',
							"param_name" => "link_color",
							"value" => '',
							"description" => '',
							"group" => "",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Reviews link hover color',
							"param_name" => "link_color_h",
							"value" => '',
							"description" => '',
							"group" => "",
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => "",
						),
					),
					td_config_helper::get_map_block_font_array( 'f_add', true, 'Additional text' ),
					td_config_helper::get_map_block_font_array( 'f_link', false, 'Reviews link text' ),

					self::get_block_style()
				),
			)
		);
		td_api_block::add( 'td_woo_product_notices',
			array(
				'map_in_td_composer' => true,
				"name" => 'Woo Product Notices',
				"base" => "td_woo_product_notices",
				'tdc_category' => 'WooCommerce Single',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_product_notices.php',
				'tdc_style_params' => array(
					'el_class'
				),
				'params' => array_merge(
					array(
						array(
							"param_name" => "sample_data_type",
							"type" => "dropdown",
							"value" => array(
								'Success' => '',
								'Error' => 'error',
								'Notice' => 'notice',
							),
							"heading" => 'Select Sample Data Type',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big"
						),

						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Layout',
							"value"      => "",
							"class"      => "",
						),
						array(
							"param_name"  => "padding",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Padding',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-big",
							"placeholder" => "11px 20px",
							"group"       => "",
						),
						array(
							"param_name"  => "border_size",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Border size',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-big",
							"placeholder" => "1",
							"group"       => "",
						),
						array(
							"param_name"  => "border_style",
							"type"        => "dropdown",
							"value"       => array(
								'Solid'  => '',
								'Dotted' => 'dotted',
								'Dashed' => 'dashed',
							),
							"heading"     => 'Border style',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-dropdown-big",
							"group"       => "",
						),
						array(
							"param_name"  => "border_radius",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Border radius',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-big",
							"placeholder" => "0",
							"group"       => "",
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Icon',
							"value"      => "",
							"class"      => "tdc-separator-small",
						),
						array(
							"param_name"  => "icon_space",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Right space',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "17",
							"group"       => "",
						),
						array(
							"param_name"  => "icon_size",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Size',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "20",
							"group"       => "",
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Button',
							"value"      => "",
							"class"      => "tdc-separator-small",
						),
						array(
							"param_name"  => "btn_padding",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Padding',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-big",
							"placeholder" => "9px 10px 10px",
							"group"       => "",
						),
						array(
							"param_name"  => "btn_border_size",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Border size',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-big",
							"placeholder" => "0",
							"group"       => "",
						),
						array(
							"param_name"  => "btn_border_style",
							"type"        => "dropdown",
							"value"       => array(
								'Solid'  => '',
								'Dotted' => 'dotted',
								'Dashed' => 'dashed',
							),
							"heading"     => 'Border style',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-dropdown-big",
							"group"       => "",
						),
						array(
							"param_name"  => "btn_border_radius",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Border radius',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-big",
							"placeholder" => "0",
							"group"       => "",
						),

						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Style',
							"value"      => "",
							"class"      => "",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "",
							"heading"     => 'Background color',
							"param_name"  => "bg_color",
							"value"       => '',
							"description" => '',
							"group"       => "",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "",
							"heading"     => 'Success border color',
							"param_name"  => "border_color_s",
							"value"       => '',
							"description" => '',
							"group"       => "",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "",
							"heading"     => 'Error border color',
							"param_name"  => "border_color_e",
							"value"       => '',
							"description" => '',
							"group"       => "",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "",
							"heading"     => 'Notice border color',
							"param_name"  => "border_color_n",
							"value"       => '',
							"description" => '',
							"group"       => "",
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Icon & text',
							"value"      => "",
							"class"      => "tdc-separator-small",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "",
							"heading"     => 'Success icon color',
							"param_name"  => "icon_color_s",
							"value"       => '',
							"description" => '',
							"group"       => "",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "",
							"heading"     => 'Error icon color',
							"param_name"  => "icon_color_e",
							"value"       => '',
							"description" => '',
							"group"       => "",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "",
							"heading"     => 'Notice icon color',
							"param_name"  => "icon_color_n",
							"value"       => '',
							"description" => '',
							"group"       => "",
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => "",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "",
							"heading"     => 'Text color',
							"param_name"  => "txt_color",
							"value"       => '',
							"description" => '',
							"group"       => "",
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Button',
							"value"      => "",
							"class"      => "tdc-separator-small",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Text color',
							"param_name" => "btn_color",
							"value" => '',
							"description" => '',
							"group" => "",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Text hover color',
							"param_name" => "btn_color_h",
							"value" => '',
							"description" => '',
							"group" => "",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Background color',
							"param_name" => "btn_bg_color",
							"value" => '',
							"description" => '',
							"group" => "",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Background hover color',
							"param_name" => "btn_bg_color_h",
							"value" => '',
							"description" => '',
							"group" => "",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Border color',
							"param_name" => "btn_border_color",
							"value" => '',
							"description" => '',
							"group" => "",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Border hover color',
							"param_name" => "btn_border_color_h",
							"value" => '',
							"description" => '',
							"group" => "",
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => "",
						),
					),
					td_config_helper::get_map_block_font_array( 'f_txt', true, 'Notice text' ),
					td_config_helper::get_map_block_font_array( 'f_btn', false, 'Button text' ),

					self::get_block_style()
				),
			)
		);
		td_api_block::add( 'td_woo_product_brand_image',
			array(
				'map_in_td_composer' => true,
				"name" => 'Woo Product Brand Image',
				"base" => "td_woo_product_brand_image",
				'tdc_category' => 'WooCommerce Single',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_product_brand_image.php',
				'tdc_style_params' => array(
					'att_tax',
					'el_class'
				),
				'params' => array_merge(
					array(
						array(
							"param_name" => "att_tax",
							"type" => "dropdown",
							"value" => self::td_woo_get_attributes(),
							"heading" => "Brand attribute",
							"description" => "Set the attribute used as brand",
							"holder" => "div",
							"class" => "tdc-dropdown-big",
							"group" => "",
						),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "make_inline",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => 'Display inline',
                            "description" => "",
                            "holder" => "div",
                            "class" => ""
                        ),
                        array(
                            "param_name" => "horiz_align",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Image',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Layout',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            'param_name' => 'img_width',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Size',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'placeholder' => '48',
                            "group"      => ""
                        ),
                        array(
                            'param_name' => 'img_padd',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Padding',
                            'description' => '',
                            'class' => 'tdc-textfield-big',
                            'placeholder' => '0',
                            "group"      => ""
                        ),
                        array(
                            'param_name' => 'all_img_border',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Border size',
                            'description' => '',
                            'class' => 'tdc-textfield-big',
                            'placeholder' => '0',
                            "group"      => ""
                        ),
                        array(
                            "param_name" => "all_img_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => 'solid',
                                'Dashed' => 'dashed',
                                'Dotted' => 'dotted',
                                'Double' => 'double',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                        ),
                        array(
                            'param_name' => 'img_radius',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Border radius',
                            'description' => '',
                            'class' => 'tdc-textfield-big',
                            'placeholder' => '0',
                            "group"      => ""
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Style',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Background color',
                            "param_name"  => "img_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Background hover color',
                            "param_name"  => "img_bg_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Border color',
                            "param_name"  => "all_img_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Border color',
                            "param_name"  => "img_border_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Tooltip',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Layout',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "show_tooltip",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Show tooltip in composer",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            'param_name' => 'tooltip_width',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Width',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'placeholder' => '80',
                            "group"      => ""
                        ),
                        array(
                            'param_name' => 'tooltip_padd',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Padding',
                            'description' => '',
                            'class' => 'tdc-textfield-big',
                            'placeholder' => '7',
                            "group"      => ""
                        ),
                        array(
                            'param_name' => 'tooltip_radius',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Border radius',
                            'description' => '',
                            'class' => 'tdc-textfield-big',
                            'placeholder' => '3',
                            "group"      => ""
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Style',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name" => "tooltip_txt",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker",
                            "heading" => 'Text color',
                            "value" => '',
                            "description" => '',
                            "group"      => "",
                        ),
                        array(
                            "param_name" => "tooltip_bg",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker",
                            "heading" => 'Background color',
                            "value" => '',
                            "description" => '',
                            "group"      => "",
                        ),
					),
                    td_config_helper::get_map_block_shadow_array('tooltip_shadow', 'Tooltip shadow', 15, 0, 7 ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_tooltip', true, 'Tooltip text' )
				),
			)
		);

		/* td woo common shortcodes */
		td_api_block::add( 'td_woo_title',
			array(
				'map_in_td_composer' => true,
				'base' => 'td_woo_title',
				'name' => 'Woo Page Title',
				'category' => 'Content',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_title.php',
				'tdc_category' => 'WooCommerce Common',
                'tdc_style_params' => array(
	                'add_text',
                    'el_class'
                ),
				'params' => array_merge(
					array(
						array(
							"param_name" => "title_tag",
							"type" => "dropdown",
							"value" => array(
								'H1 - Default' => 'h1',
								'H2' => 'h2',
								'H3' => 'h3',
								'H4' => 'h4',
							),
							"heading" => 'Title tag (SEO)',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big",
						),
						array(
							"param_name"  => "add_text",
							"type"        => "textfield",
							"value"       => '',
							"heading"     => 'Additional text',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-big",
							"placeholder" => '',
						),
						array(
							"param_name" => "add_text_pos",
							"type" => "dropdown",
							"value" => array(
								'Before title' => '',
								'After title' => 'after',
								'Above title' => 'above',
							),
							"heading" => 'Additional text position',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big",
						),
						array(
							"param_name" => "add_text_space",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => 'Additional text space',
							"description" => "",
							"placeholder" => '0',
							"holder" => "div",
							"class" => "tdc-textfield-small"
						),
						array(
							"param_name" => "separator",
							"type"       => "horizontal_separator",
							"value"      => "",
							"class"      => "tdc-separator-small",
						),
						array(
							"param_name" => "line_width",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => 'Line width',
							"description" => "",
							"placeholder" => '0',
							"holder" => "div",
							"class" => "tdc-textfield-small"
						),
						array(
							"param_name" => "line_height",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => 'Line height',
							"description" => "",
							"placeholder" => '2',
							"holder" => "div",
							"class" => "tdc-textfield-small"
						),
						array(
							"type" => 'textfield-responsive',
							"param_name" => 'line_space',
							"value" => '',
							"heading" => 'Line space',
							"class" => 'tdc-textfield-small',
							"description" => '',
							"placeholder" => '50',
						),
						array(
							'type' => 'range-responsive',
							'param_name' => 'line_alignment',
							'value' => '40',
							'heading' => 'Line alignment',
							'description' => '',
							'class' => 'tdc-textfield-small',
							'range_min' => '-100',
							'range_max' => '100',
							'range_step' => '10',
						),
						array(
							"param_name" => "line_position",
							"type" => "dropdown",
							"value" => array(
								'Below text' => '',
								'Above text' => 'above',
							),
							"heading" => 'Line position',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big",
						),
						array(
							"param_name" => "separator",
							"type"       => "horizontal_separator",
							"value"      => "",
							"class"      => "tdc-separator-small",
						),
						array(
							"param_name" => "content_align_horizontal",
							"type" => "dropdown-responsive",
							"value" => array(
								'Left' => 'content-horiz-left',
								'Center' => 'content-horiz-center',
								'Right' => 'content-horiz-right'
							),
							"heading" => 'Horizontal align',
							"description" => "",
							"holder" => "div",
							'tdc_dropdown_images' => true,
							"class" => "tdc-visual-selector tdc-add-class",
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Style',
							"value"      => "",
							"class"      => "",
						),
						array(
							"param_name" => "title_color",
							"holder" => "div",
							"type" => "gradient",
							'heading' => "Title color",
							"value" => "",
							"class" => "",
						),
						array(
							"param_name" => "add_color",
							"holder" => "div",
							"type" => "gradient",
							'heading' => "Additional text color",
							"value" => "",
							"class" => "",
						),
						array(
							"param_name" => "line_color",
							"holder" => "div",
							"type" => "gradient",
							'heading' => "Line color",
							"value" => "",
							"class" => "",
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small"
						),
						array(
							"type"        => "gradient",
							"holder"      => "div",
							"class"       => "",
							"heading"     => 'Title background',
							"param_name"  => "style_bg",
							"value"       => '',
							"description" => '',
						),
						array(
							"param_name" => "style_bg_space",
							"type" => "textfield",
							"value" => '',
							"heading" => 'Title background space',
							"description" => "",
							"placeholder" => "5px 16px",
							"holder" => "div",
							"class" => "tdc-textfield-big"
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small"
						),
						array(
							"param_name" => "first_letter",
							"type" => "checkbox",
							"value" => '',
							"heading" => 'Big first letter',
							"description" => "",
							"holder" => "div",
							"class" => ""
						),
						array(
							'type' => 'range-responsive',
							'param_name' => 'fl_align',
							'value' => '0',
							'heading' => 'V. alignment',
							'description' => '',
							'class' => 'tdc-textfield-small',
							'range_min' => '-50',
							'range_max' => '50',
							'range_step' => '1',
						),
						array(
							"param_name" => "fl_color",
							"holder" => "div",
							"type" => "colorpicker",
							'heading' => "Letter color",
							"value" => "",
							"class" => "",
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small"
						),
					),
					td_config_helper::get_map_block_font_array( 'f_title', true, 'Title text' ),
					td_config_helper::get_map_block_font_array( 'f_letter', false, 'Big first letter' ),
					td_config_helper::get_map_block_font_array( 'f_add', false, 'Additional text' ),
					self::get_block_style()
				),
			)
		);
		td_api_block::add( 'td_woo_breadcrumbs',
			array(
				'map_in_td_composer' => true,
				'base' => 'td_woo_breadcrumbs',
				'name' => 'Woo Breadcrumbs',
				'category' => 'Content',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_breadcrumbs.php',
				'tdc_category' => 'WooCommerce Common',
                'tdc_style_params' => array(
                    'el_class'
                ),
                'tdc_start_values' => base64_encode(
                    json_encode(
                        array(
                            array(
                                'tdicon' => 'td-icon-right',
                            )
                        )
                    )
                ),
				'params' => array_merge(
					array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'General Settings',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "content_align_horizontal",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => ""
                        ),
                        array(
                            "param_name" => "icon_size",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Separator icon size',
                            "description" => "",
                            "placeholder" => "8",
                            "holder" => "div",
                            "class" => "tdc-textfield-small"
                        ),
                        array(
                            "param_name" => "icon_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Separator icon space',
                            "description" => "",
                            "placeholder" => "5",
                            "holder" => "div",
                            "class" => "tdc-textfield-small"
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Style',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Breadcrumbs text color',
                            "param_name"  => "text_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Breadcrumbs links hover color',
                            "param_name"  => "link_h_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Separator icon color',
                            "param_name"  => "icon_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "",
                        )
                    ),
                    td_config_helper::get_map_block_font_array( 'f_text', true, 'Breadcrumbs text' ),
                    self::get_block_style()
				),
			)
		);
		td_api_block::add( 'td_woo_add_to_cart_custom',
			array(
				'map_in_td_composer' => true,
				"name" => 'Woo Custom Add To Cart',
				"base" => "td_woo_add_to_cart_custom",
				'tdc_category' => 'WooCommerce Common',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_add_to_cart_custom.php',
                'tdc_style_params' => array(
                    'product_id',
                    'quantity',
                    'button_text',
                    'el_class'
                ),
				'params' => array_merge(
					array(
						array(
							"param_name" => "product_id",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => 'Product ID',
							"description" => "The ID of the product that you want to add to cart using this button.",
							"placeholder" => '',
							"holder" => "div",
							"class" => "tdc-textfield-small"
						),
						array(
							"param_name" => "quantity",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => 'Quantity',
							"description" => "The button preset quantity. Amount products to add to cart using this button.",
							"placeholder" => '1',
							"holder" => "div",
							"class" => "tdc-textfield-small"
						),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Layout',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            'param_name' => 'button_text',
                            'type' => 'textfield',
                            'value' => '',
                            'heading' => 'Button text',
                            'description' => '',
                            'class' => 'tdc-textfield-extrabig',
                            'placeholder' => 'Custom add to cart',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            'param_name' => 'button_tdicon',
                            'type' => 'icon',
                            'heading' => 'Button icon',
                            'class' => 'tdc-textfield-small',
                            'value' => '',
                        ),
                        array(
                            'param_name' => 'button_icon_size',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Button icon size',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                        ),
                        array(
                            "param_name" => "button_icon_position",
                            "type" => "dropdown",
                            "value" => array(
                                'After text' => '',
                                'Before text' => 'icon-before',
                            ),
                            "heading" => __( 'Button icon position', 'td_composer' ),
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                        ),
                        array(
                            'param_name' => 'button_icon_space',
                            'type' => 'range-responsive',
                            'value' => '14',
                            'heading' => 'Icon space',
                            'description' => '',
                            'range_min' => '0',
                            'range_max' => '50',
                            'range_step' => '1',
                            'class' => 'tdc-textfield-small',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            'param_name' => 'button_width',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Button min-width',
                            'description' => 'Button width',
                            'class' => 'tdc-textfield-small',
                        ),
                        array(
                            'param_name' => 'button_padding',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Padding',
                            'description' => '',
                            'class' => 'tdc-textfield-big'
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "make_inline",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => 'Display inline',
                            "description" => "",
                            "holder" => "div",
                            "class" => ""
                        ),
                        array(
                            "param_name" => "align_horiz",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                        ),

                        array(
                            "param_name" => "tds_w_button",
                            "type" => "dropdown",
                            "value" => td_api_style::get_styles_for_mapping( 'tds_w_button', false ),
                            "heading" => 'Button style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Style",
                        ),
					),
					array(
						array(
							'param_name' => 'css',
							'value' => '',
							'type' => 'css_editor',
							'heading' => 'Css',
							'group' => 'Design options',
						),
						array(
							'param_name' => 'tdc_css',
							'value' => '',
							'type' => 'tdc_css_editor',
							'heading' => '',
							'group' => 'Design options',
						),
					)
				),
			)
		);
		td_api_block::add( 'td_woo_products_loop',
			array(
				'map_in_td_composer' => true,
				"name" => 'Woo Loop',
				"base" => "td_woo_products_loop",
				'tdc_category' => 'WooCommerce Common',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_products_loop.php',
                'tdc_style_params' => array(
                    'custom_title',
                    'custom_url',
                    'products_ids',
                    'sort',
                    'ajax_pagination',
                    'ajax_pagination_infinite_stop',
                    'single_product_page_filter',
                    'limit',
                    'offset',
                    'el_class'
                ),
                'tdc_start_values' => base64_encode(
                    json_encode(
                        array(
                            array(
                                "modules_on_row" => "25%",
                                "limit" => "12",
                                "ajax_pagination" => "numbered",
                            ),
                        )
                    )
                ),
				'params' => array_merge(
                    td_config::get_map_block_general_array(),
                    array(
                        array(
                            "param_name" => "title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H4' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H3' => 'h3',
                                'Div' => 'div'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                        ),
                    ),
					array(
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Extra',
							"value"      => "",
							"class"      => "",
						),
						array(
							"param_name" => "limit",
							"type" => "textfield",
							"value" => '',
							"heading" => 'Limit products number:',
							"description" => "If the field is empty all products will be displayed",
							"holder" => "div",
							"class" => "tdc-textfield-small",
						),
						array(
							"param_name" => "offset",
							"type" => "textfield",
							"value" => '',
							"heading" => 'Offset products:',
							"description" => "Start the count with an offset",
							"holder" => "div",
							"class" => "tdc-textfield-small",
							"group"      => ''
						),
						array(
							"param_name" => "products_ids",
							"type" => "textfield",
							"value" => '',
							"heading" => 'Exclude products ID\'s:',
							"description" => "Filter multiple products by ID. Enter here the products IDs separated by commas (ex: 10,27,233). To exclude products add them with '-' (ex: -7, -16)",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							'group' => ''
						),

						/*
						 * 'orderby'        => '',        // menu_order, title, date, rand, price, popularity, rating, or id.
						 * 'order'          => '',        // ASC or DESC.
						 * default >> menu_order
						 */
						array(
							"param_name" => "sort",
							"type" => "dropdown",
							"value" => array (
								'- Menu Order -' => '',
								'Title' => 'title',
								'Date' => 'date',
								'Random' => 'rand',
								'Price' => 'price',
								'Popularity' => 'popularity',
								'Highest rated' => 'rating',
								'ID' => 'id'
							),
							"heading" => 'Sort order:',
							"description" => "How to sort products.",
							"holder" => "div",
							"class" => "tdc-dropdown-big",
							'group' => ''
						),
						array(
							"param_name" => "ajax_pagination",
							"type" => "dropdown",
							"value" => array(
								'- No pagination -' => '',
								'Normal numbered' => 'numbered',
								'Next Prev ajax' => 'next_prev',
								'Load More button' => 'load_more',
								'Infinite load' => 'infinite'
							),
							"heading" => 'Pagination:',
							"description" => "Our blocks support pagination.",
							"holder" => "div",
							"class" => "tdc-dropdown-big",
							'group' => ''
						),
						array(
							"param_name" => "ajax_pagination_infinite_stop",
							"type" => "textfield",
							"value" => '',
							"heading" => "Infinite load show 'Load more' after x pages:",
							"description" => "ONLY FOR INFINITE LOAD pagination: Shows 'load more' button after x number of pages. Leave this blank to load products forever when infinite load is set for ajax pagination",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							'group' => ''
						),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Results count text',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name" => "res_show",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Show' => 'block',
                                'Hide' => 'none',
                            ),
                            "heading" => 'Show',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group"      => "Layout",
                        ),
                        array(
                            'param_name' => 'res_padding',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Space',
                            'description' => '',
                            'class' => 'tdc-textfield-big',
                            'placeholder' => '0',
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name" => "res_horiz_align",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Default' => 'layout-default',
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"      => "Layout",
                        ),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Layout',
							"value"      => "",
							"class"      => "",
							"group"      => "Layout",
						),

                        array(
                            "param_name"  => "modules_on_row",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                '1'  => '100%',
                                '2'  => '50%',
                                '3'  => '33.33333333%',
                                '4'  => '25%',
                                '5'  => '20%',
                                '6'  => '16.66666667%',
                                '7'  => '14.28571428%',
                                '8'  => '12.5%',
                                '9'  => '11.11111111%',
                                '10' => '10%',
                            ),
                            "heading"     => 'Modules per row',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-small",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "gap",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Products gap',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "30",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "all_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Products bottom space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "40",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Product image',
                            "value"      => "",
                            "class"      => "",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "img_size",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Medium - Default - 696x0px'  => '',
                                '-- [No crop] --' => '__',
                                'XSmall - 150x0px' => 'td_150x0',
                                'Small - 300x0px' => 'td_300x0',
                                'Large - 1068x0px' => 'td_1068x0',
                                'Full - 1920x0px'  => 'td_1920x0',
                                '-- [Other sizes] --' => '__',
                                '218x150px' => 'td_218x150',
                                '324x400px'  => 'td_324x400',
                                '485x360' => 'td_485x360'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name"  => "img_width",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (0-100 percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name"  => "img_height",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            'param_name'  => 'img_alignment',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "img_pos",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Normal'      => 'normal',
                                'Float left'  => 'left',
                                'Float right' => 'right',
                                'Hidden'      => 'hidden',
                            ),
                            "heading"     => 'Image position',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name"  => "img_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image bottom margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "14",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "img_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name"  => "hide_image",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Hide image",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout',
                            "info_img"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Sale tag',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "sale_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Sale tag margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "sale_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Sale tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "10",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "sale_border",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Sale tag border size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "sale_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => 'solid',
                                'Dashed' => 'dashed',
                                'Dotted' => 'dotted',
                                'Double' => 'double',
                            ),
                            "heading" => 'Sale tag border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Layout",
                        ),
                        array(
                            "param_name"  => "sale_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Sale tag border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Favorite button',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "show_favourites",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => 'Show',
                            "description" => "",
                            "holder" => "div",
                            "group"       => "Layout",
                        ),
                        array(
                            'param_name'  => 'fav_size',
                            'type'        => 'range-responsive',
                            'value'       => '2',
                            'heading'     => 'Button size',
                            'description' => '',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '1',
                            'range_max'   => '4',
                            'range_step'  => '1',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "fav_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Button space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "10",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Meta info',
                            "value"      => "",
                            "class"      => "",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_info_align",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Top'     => 'initial',
                                'Center'  => 'center',
                                'Bottom'  => 'flex-end',
                            ),
                            "heading"     => 'Vertical align',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "horiz_align",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "meta_width",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "meta_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name"  => "meta_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "meta_info_border_size",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name"  => "meta_info_border_style",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Solid'  => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Title',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "title_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Title bottom margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "5",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "product_title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Paragraph' => 'p'
                            ),
                            "heading" => 'Product title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Product description',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_excerpt",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Hide' => 'none',
                                'Show' => 'block',
                            ),
                            "heading"     => 'Show description',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_show_excerpt.png",
                        ),
                        array(
                            "param_name"  => "excerpt_type",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Short description' => '',
                                'Long description' => 'long',
                            ),
                            "heading"     => 'Product description type',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_show_excerpt.png",
                        ),
                        array(
                            "param_name"  => "excerpt_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Product excerpt space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "20px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_excerpt_space.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Review stars',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_stars",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show review stars',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "stars_size",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Review stars size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "12",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "stars_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Review stars bottom margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "6",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "price_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Price bottom margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "18",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name" => "horiz_align",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Button',
                            "value"      => "",
                            "class"      => "",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "btn_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "10px 10px 10px 10px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "btn_border",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "btn_border_style",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Solid'  => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "btn_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Button radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_btn",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show button',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Pagination',
							"value"      => "",
							"class"      => "",
							"group"       => 'Layout'
						),
						array(
							"param_name" => "pag_space",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => 'Top space',
							"description" => "",
							"placeholder" => "54",
							"holder" => "div",
							"class" => "tdc-textfield-small",
							'group'      => 'Layout',
						),
						array(
							"param_name"  => "pag_padding",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Padding',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-big",
							"placeholder" => "",
							"group"       => "Layout",
						),
						array(
							"param_name"  => "pag_border_width",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Border width',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "1",
							"group"       => "Layout",
						),
						array(
							"param_name"  => "pag_border_radius",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Border radius',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "0",
							"group"       => "Layout",
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => 'Layout',
						),
						array(
							'param_name' => 'prev_tdicon',
							'type' => 'icon',
							'heading' => 'Prev icon',
							'class' => 'tdc-textfield-small',
							'value' => '',
							"group"       => 'Layout'
						),
						array(
							'param_name' => 'next_tdicon',
							'type' => 'icon',
							'heading' => 'Next icon',
							'class' => 'tdc-textfield-small',
							'value' => '',
							"group"       => 'Layout'
						),
						array(
							"param_name"  => "pag_icons_size",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Icons size',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "",
							"group"       => "Layout",
						),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Results count text',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "res_color",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Text color',
                            "value" => '',
                            "description" => '',
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Sale tag',
                            "value"      => "",
                            "class"      => "",
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Text color',
                            "param_name"  => "sale_txt_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Text hover color',
                            "param_name"  => "sale_txt_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Background color',
                            "param_name"  => "sale_bg_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Background hover color',
                            "param_name"  => "sale_bg_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Border color',
                            "param_name"  => "sale_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Border hover color',
                            "param_name"  => "sale_border_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Favorite button',
                            "value"      => "",
                            "class"      => "",
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Icon color',
                            "param_name"  => "fav_ico_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Icon hover/added color',
                            "param_name"  => "fav_ico_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Background color',
                            "param_name"  => "fav_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Background hover/added color',
                            "param_name"  => "fav_bg_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                    ),
                    td_config_helper::get_map_block_shadow_array('fav_shadow', 'Shadow', 4, 1, 1, 'Style'),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Meta info',
                            "value"      => "",
                            "class"      => "",
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Background color',
                            "param_name"  => "meta_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Border color',
                            "param_name"  => "meta_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Title color',
                            "param_name"  => "title_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Title hover color',
                            "param_name"  => "title_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Product description color',
                            "param_name"  => "ex_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_excerpt.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Full stars color',
                            "param_name"  => "stars_full_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Empty stars color',
                            "param_name"  => "stars_empty_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Price color',
                            "param_name"  => "price_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Sale price color',
                            "param_name"  => "price_sale_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Old price color',
                            "param_name"  => "old_price_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Button',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Text color',
                            "param_name"  => "btn_txt_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Text hover color',
                            "param_name"  => "btn_txt_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Background color',
                            "param_name"  => "btn_bg_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Background hover color',
                            "param_name"  => "btn_bg_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Border color',
                            "param_name"  => "btn_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Border hover color',
                            "param_name"  => "btn_border_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Pagination',
                            "value"      => "",
                            "class"      => "",
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-triple-a",
                            "heading"     => 'Text color',
                            "param_name"  => "pag_text",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-triple-b",
                            "heading"     => 'Text hover color',
                            "param_name"  => "pag_h_text",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-triple-c",
                            "heading"     => 'Active text color',
                            "param_name"  => "pag_a_text",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-triple-a",
                            "heading"     => 'Background color',
                            "param_name"  => "pag_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-triple-b",
                            "heading"     => 'Background hover color',
                            "param_name"  => "pag_h_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-triple-c",
                            "heading"     => 'Active background color',
                            "param_name"  => "pag_a_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-triple-a",
                            "heading"     => 'Border color',
                            "param_name"  => "pag_border",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-triple-b",
                            "heading"     => 'Border hover color',
                            "param_name"  => "pag_h_border",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-triple-c",
                            "heading"     => 'Active border color',
                            "param_name"  => "pag_a_border",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Fonts',
                            "value"      => "",
                            "class"      => "",
                            "group"       => "Style",
                        ),
					),
                    td_config_helper::get_map_block_font_array( 'f_header', true, 'Block title text', 'Style'),
                    td_config_helper::get_map_block_font_array( 'f_res', false, 'Results text', 'Style'),
                    td_config_helper::get_map_block_font_array( 'f_sale', false, 'Sale tag text', 'Style'),
                    td_config_helper::get_map_block_font_array( 'f_title', false, 'Title text', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_ex', false, 'Product description', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_price', false, 'Price text', 'Style'),
                    td_config_helper::get_map_block_font_array( 'f_old_price', false, 'Old price text', 'Style'),
                    td_config_helper::get_map_block_font_array( 'f_btn', false, 'Button text', 'Style'),
                    td_config_helper::get_map_block_font_array( 'f_more', false, 'Pagination/Load button', 'Style'),

					array(
						array(
							'param_name' => 'css',
							'value' => '',
							'type' => 'css_editor',
							'heading' => 'Css',
							'group' => 'Design options',
						),
						array(
							'param_name' => 'tdc_css',
							'value' => '',
							'type' => 'tdc_css_editor',
							'heading' => '',
							'group' => 'Design options',
						),
					)
				),
			)
		);
		td_api_block::add( 'td_woo_loop_sorting_options',
			array(
				'map_in_td_composer' => true,
				"name" => 'Woo Loop Sorting Options',
				"base" => "td_woo_loop_sorting_options",
				'tdc_category' => 'WooCommerce Common',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_loop_sorting_options.php',
				'tdc_style_params' => array(
					'el_class'
				),
				'tdc_start_values' => base64_encode(
					json_encode(
						array(
							array(
								"vert_align" => "middle",
							),
						)
					)
				),
				"params" => array_merge(
					array(
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Layout',
							"value"      => "",
							"class"      => "",
						),
						array(
							"param_name" => "drop_horiz",
							"type" => "dropdown-responsive",
							"value" => array(
								'Default' => 'layout-default',
								'Left' => 'content-horiz-left',
								'Center' => 'content-horiz-center',
								'Right' => 'content-horiz-right'
							),
							"heading" => 'Headers align',
							"description" => "",
							"holder" => "div",
							'tdc_dropdown_images' => true,
							"class" => "tdc-visual-selector tdc-add-class",
						),
						array(
							'param_name' => 'drop_width',
							'type' => 'textfield-responsive',
							'value' => '',
							'heading' => 'Width',
							'description' => '',
							'class' => 'tdc-textfield-small',
							'placeholder' => '280'
						),
						array(
							'param_name' => 'drop_padding',
							'type' => 'textfield-responsive',
							'value' => '',
							'heading' => 'Padding',
							'description' => '',
							'class' => 'tdc-textfield-big',
							'placeholder' => '5px 9px'
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => "",
						),
						array(
							'param_name' => 'drop_arrow_size',
							'type' => 'textfield-responsive',
							'value' => '',
							'heading' => 'Arrow size',
							'description' => '',
							'class' => 'tdc-textfield-small',
							'placeholder' => '14'
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => "",
						),
						array(
							'param_name' => 'drop_border',
							'type' => 'textfield-responsive',
							'value' => '',
							'heading' => 'Border size',
							'description' => '',
							'class' => 'tdc-textfield-big',
							'placeholder' => '1'
						),
						array(
							"param_name" => "drop_border_style",
							"type" => "dropdown-responsive",
							"value" => array(
								'Solid' => '',
								'Dashed' => 'dashed',
								'Dotted' => 'dotted',
								'Double' => 'double',
							),
							"heading" => 'Border style',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big",
							"group" => "",
						),
						array(
							'param_name' => 'drop_border_radius',
							'type' => 'textfield-responsive',
							'value' => '',
							'heading' => 'Border radius',
							'description' => '',
							'class' => 'tdc-textfield-big',
							'placeholder' => '0'
						),

						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Style',
							"value"      => "",
							"class"      => "",
						),
						array(
							"param_name" => "drop_color",
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => 'Text color',
							"value" => '',
							"description" => '',
							"group"      => "",
						),
						array(
							"param_name" => "drop_arrow_color",
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => 'Arrow color',
							"value" => '',
							"description" => '',
							"group"      => "",
						),
						array(
							"param_name" => "drop_bg_color",
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Background color',
							"value" => '',
							"description" => '',
							"group"      => "",
						),
						array(
							"param_name" => "drop_bg_color_f",
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Focus background color',
							"value" => '',
							"description" => '',
							"group"      => "",
						),
						array(
							"param_name" => "drop_border_color",
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Border color',
							"value" => '',
							"description" => '',
							"group"      => "",
						),
						array(
							"param_name" => "drop_border_color_f",
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Focus border color',
							"value" => '',
							"description" => '',
							"group"      => "",
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Fonts',
							"value"      => "",
							"class"      => "tdc-separator-small",
						),
					),
					td_config_helper::get_map_block_font_array( 'f_drop', true, 'Dropdowns text' ),
					self::get_block_style()
				)
			)
		);
		td_api_block::add( 'td_woo_attribute_filter',
			array(
				'map_in_td_composer' => true,
				"name" => 'Woo Attribute Filters',
				"base" => "td_woo_attribute_filter",
				"class" => "",
				"controls" => "full",
				"category" => 'Blocks',
				'tdc_category' => 'WooCommerce Common',
				'icon' => '',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_attribute_filter.php',
				'tdc_style_params' => array(
                    'el_class'
                ),
				'tdc_start_values' => base64_encode(
					json_encode(
						array(
							array(
                                "reset_txt" => "Clear all filters",
                                "reset_tdicon" => "td-icon-modal-close",
								'product_cat_type' => 'off',
								'product_cat_type_action' => 'off',
								'product_tag_type' => 'off'
							)
						)
					)
				),
				'params' => array_merge(
					array(
						array(
							"param_name" => "load_type",
							"type" => "dropdown",
							"value" => array (
								'Page Load - Default' => '',
								'Ajax' => 'ajax',
							),
							"heading" => 'Filters content loading type',
							"description" => "Using this option you can set filters to apply on page load or live using ajax. By default filters will be applied by page load.",
							"holder" => "div",
							"class" => "tdc-dropdown-big",
							'group' => ''
						),
						array(
							"param_name" => "hide_empty",
							"type" => "checkbox",
							"value" => '',
							"heading" => 'Hide empty terms',
							"description" => "",
							"holder" => "div",
							"class" => ""
						),
						array(
							"param_name" => "enable_on_mob",
							"type" => "checkbox",
							"value" => '',
							"heading" => 'Enable Filters on Mobile',
							"description" => "This option will enable filters display on mobile view.",
							"holder" => "div",
							"class" => ""
						),
					),
					self::td_woo_attribute_filter_attributes_settings(),
					self::get_block_style()
				)
			)
		);
		td_api_block::add( 'td_woo_filters_list',
			array(
				'map_in_td_composer' => true,
				"name" => 'Woo Selected Filters',
				"base" => "td_woo_filters_list",
				"class" => "",
				"controls" => "full",
				"category" => 'Blocks',
				'tdc_category' => 'WooCommerce Common',
				'icon' => '',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_filters_list.php',
				'tdc_style_params' => array(),
				'tdc_start_values' => base64_encode(
					json_encode(
						array(
							array()
						)
					)
				),
				'params' => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Layout',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => ""
                        ),
                        array(
                            'param_name' => 'but_wrap_padd',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Container space',
                            'description' => '',
                            'class' => 'tdc-textfield-big',
                            'placeholder' => '',
                            "group"      => ""
                        ),
                        array(
                            "param_name" => "filters_horiz_align",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Start' => 'flex-start',
                                'Center' => 'center',
                                'End' => 'flex-end',
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-flex-selector tdc-flex-row-horiz-align tdc-add-class tdc-img-right",
                            'group' => '',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Filters Layout',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => ""
                        ),
                        array(
                            'param_name' => 'close_tdicon',
                            'type' => 'icon',
                            'heading' => 'Close icon',
                            'class' => 'tdc-textfield-small',
                            'value' => '',
                            "info_img" => "",
                        ),
                        array(
                            'param_name' => 'icon_size',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Icon size',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'placeholder' => '11',
                            "group"      => ""
                        ),
                        array(
                            'param_name' => 'icon_align',
                            'type' => 'range-responsive',
                            'value' => '0',
                            'heading' => 'Icon align',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '-10',
                            'range_max' => '10',
                            'range_step' => '1',
                        ),
                        array(
                            'param_name' => 'icon_space',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Icon space',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'placeholder' => '8',
                            "group"      => ""
                        ),
                        array(
                            'param_name' => 'but_margin',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Margin',
                            'description' => '',
                            'class' => 'tdc-textfield-big',
                            'placeholder' => '3px 6px 3px 0',
                            "group"      => ""
                        ),
                        array(
                            'param_name' => 'but_padd',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Padding',
                            'description' => '',
                            'class' => 'tdc-textfield-big',
                            'placeholder' => '8px 10px',
                            "group"      => ""
                        ),
                        array(
                            'param_name' => 'all_but_border',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Border size',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'placeholder' => '1',
                            "group"      => ""
                        ),
                        array(
                            'param_name' => 'all_but_border_s',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Hover border size',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'placeholder' => '2',
                            "group"      => ""
                        ),
                        array(
                            'param_name' => 'but_radius',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Border radius',
                            'description' => '',
                            'class' => 'tdc-textfield-big',
                            'placeholder' => '0',
                            "group"      => ""
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Style',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => ""
                        ),
                        array(
                            "param_name" => "but_txt",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Text color',
                            "value" => '',
                            "description" => '',
                            "group"      => "",
                        ),
                        array(
                            "param_name" => "but_txt_h",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Hover text color',
                            "value" => '',
                            "description" => '',
                            "group"      => "",
                        ),
                        array(
                            "param_name" => "but_bg",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Background color',
                            "value" => '',
                            "description" => '',
                            "group"      => "",
                        ),
                        array(
                            "param_name" => "but_bg_h",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Hover background color',
                            "value" => '',
                            "description" => '',
                            "group"      => "",
                        ),
                        array(
                            "param_name" => "all_but_border_c",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Border color',
                            "value" => '#dfdfdf',
                            "description" => '',
                            "group"      => "",
                        ),
                        array(
                            "param_name" => "all_but_border_c_h",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Hover border color',
                            "value" => '#444444',
                            "description" => '',
                            "group"      => "",
                        ),
                        array(
                            "param_name" => "close_color",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Icon color',
                            "value" => '',
                            "description" => '',
                            "group"      => "",
                        ),
                        array(
                            "param_name" => "close_color_h",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Hover icon color',
                            "value" => '',
                            "description" => '',
                            "group"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_but', true, 'Text', '' ),
                    self::get_block_style()
				),
			)
		);
		td_api_block::add( 'td_woo_page_description',
			array(
				'map_in_td_composer' => true,
				"name" => 'Woo Page Description',
				"base" => "td_woo_page_description",
				"class" => "",
				"controls" => "full",
				"category" => 'Blocks',
				'tdc_category' => 'WooCommerce Common',
				'icon' => '',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_page_description.php',
				'tdc_style_params' => array(
                    'el_class'
                ),
				'params' => array_merge(
					array(
						array(
							"param_name" => "content_align_horizontal",
							"type" => "dropdown",
							"value" => array(
								'Left' => 'content-horiz-left',
								'Center' => 'content-horiz-center',
								'Right' => 'content-horiz-right'
							),
							"heading" => 'Horizontal align',
							"description" => "",
							"holder" => "div",
							'tdc_dropdown_images' => true,
							"class" => "tdc-visual-selector tdc-add-class",
							"info_img" => "https://cloud.tagdiv.com/help/category_descr_horiz_align.png",
						),
						array(
							"param_name"  => "p_space",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Paragraphs bottom space',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "15",
							"group"       => "",
							"info_img" => "https://cloud.tagdiv.com/help/category_descr_paragraph_space.png",
						),
						array(
							"param_name" => "separator",
							"type"       => "horizontal_separator",
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"      => "",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "",
							"heading"     => 'Description color',
							"param_name"  => "descr_color",
							"value"       => '',
							"description" => '',
							"group"       => "",
							"info_img" => "https://cloud.tagdiv.com/help/category_descr_color.png",
						),
					),
					td_config_helper::get_map_block_font_array( 'f_but', true, 'Text', '' ),
                    self::get_block_style()
				),
			)
		);

		/* td woo header shortcodes */
		td_api_block::add( 'td_woo_products_live_search',
			array(
				'map_in_td_composer' => true,
				"name" => 'Woo Products Live Search',
				"base" => "td_woo_products_live_search",
				'tdc_category' => 'Header shortcodes',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_products_live_search.php',
				'tdc_style_params' => array(
					'show_form',
					'el_class'
				),
				'tdc_start_values' => base64_encode(
					json_encode(
						array(
							array(
								"inline" => "yes",
								"toggle_txt_pos" => "after",
								"form_align" => "content-horiz-right",
								"results_msg_align" => "content-horiz-center",
								"mod_show_btn" => "none"
							)
						)
					)
				),
				'params' => array_merge(
					array(
						array(
							"param_name" => "woo_search_version",
							"type" => "dropdown",
							"value" => array(
								'Dropdown' => '',
								'Search field' => 'regular',
							),
							"heading" => 'Version',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big",
							"group" => "",
						),
						array(
							"param_name" => "show_form",
							"type" => "checkbox",
							"value" => '',
							"heading" => "Show search form",
							"description" => "",
							"holder" => "div",
							"class" => "",
						),
						array(
							"param_name" => "disable_live_search",
							"type" => "checkbox",
							"value" => '',
							"heading" => "Disable Live Search",
							"description" => "",
							"holder" => "div",
							"class" => "",
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Search icon',
							"value" => "",
							"class" => "tdc-separator tdc-woos-dropdown",
							"group" => '',
						),
						array(
							'param_name' => 'tdicon',
							'type' => 'icon',
							'heading' => 'Search icon',
							'class' => 'tdc-textfield-small tdc-woos-dropdown',
							'value' => '',
						),
						array(
							'param_name' => 'icon_size',
							'type' => 'range-responsive',
							'value' => '20',
							'heading' => 'Icon size',
							'description' => '',
							'class' => 'tdc-textfield-small tdc-woos-dropdown',
							'range_min' => '1',
							'range_max' => '60',
							'range_step' => '1',
							"group"       => "",
						),
						array(
							'param_name' => 'icon_padding',
							'type' => 'range-responsive',
							'value' => '2.4',
							'heading' => 'Icon padding',
							'description' => '',
							'class' => 'tdc-textfield-small tdc-woos-dropdown',
							'range_min' => '0',
							'range_max' => '4',
							'range_step' => '0.1',
							"group"       => "",
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small tdc-woos-dropdown",
							"group" => "",
						),
						array(
							"param_name" => "toggle_txt",
							"type" => "textfield",
							"value" => '',
							"heading" => "Text",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big tdc-woos-dropdown",
							"placeholder" => ""
						),
						array(
							"param_name" => "toggle_txt_pos",
							"type" => "dropdown",
							"value" => array(
								'Before icon' => '',
								'After icon' => 'after',
							),
							"heading" => 'Text position',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big tdc-woos-dropdown",
							"group" => "",
						),
						array(
							'param_name' => 'toggle_txt_align',
							'type' => 'range-responsive',
							'value' => '0',
							'heading' => 'Text vert. position',
							'description' => '',
							'class' => 'tdc-textfield-small tdc-woos-dropdown',
							'range_min' => '-10',
							'range_max' => '10',
							'range_step' => '1',
						),
						array(
							"param_name" => "toggle_txt_space",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Text space",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small tdc-woos-dropdown",
							"placeholder" => "0"
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small tdc-woos-dropdown",
							"group" => "",
						),
						array(
							"param_name" => "toggle_horiz_align",
							"type" => "dropdown",
							"value" => array(
								'Left' => 'content-horiz-left',
								'Center' => 'content-horiz-center',
								'Right' => 'content-horiz-right'
							),
							"heading" => 'Horizontal align',
							"description" => "",
							"holder" => "div",
							'tdc_dropdown_images' => true,
							"class" => "tdc-visual-selector tdc-add-class tdc-woos-dropdown",
							"group"       => "",
						),
						array(
							"param_name" => "inline",
							"type" => "checkbox",
							"value" => '',
							"heading" => "Make inline",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-woos-dropdown",
						),
						array(
							"param_name" => "float_block",
							"type" => "checkbox",
							"value" => '',
							"heading" => 'Align block to right',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-woos-dropdown"
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Search form',
							"value" => "",
							"class" => "tdc-separator",
							"group" => '',
						),
						array(
							"param_name" => "form_offset",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Form top offset",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small tdc-woos-dropdown",
							"placeholder" => "0"
						),
						array(
							"param_name" => "form_offset_left",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Form left offset",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small tdc-woos-dropdown",
							"placeholder" => "0"
						),
						array(
							"param_name" => "form_width",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Form width",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small tdc-woos-dropdown",
							"placeholder" => "300"
						),
						array(
							"param_name" => "form_content_width",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Form content width",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small tdc-woos-dropdown",
							"placeholder" => "100%"
						),
						array(
							"param_name" => "form_padding",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Form padding",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big tdc-woos-dropdown",
							"placeholder" => "20px"
						),
						array(
							"param_name" => "form_border",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Form border size",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big tdc-woos-dropdown",
							"placeholder" => "3px 0 0 0"
						),
						array(
							"param_name"  => "form_align_screen",
							"type"        => "dropdown",
							"value"       => array(
								'Relative to menu' => '',
								'Relative to screen' => 'yes',
							),
							"heading"     => 'Position',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-dropdown-big tdc-woos-dropdown",
							"group"       => "",
						),
						array(
							"param_name" => "form_align",
							"type" => "dropdown",
							"value" => array(
								'Left' => 'content-horiz-left',
								'Center' => 'content-horiz-center',
								'Right' => 'content-horiz-right'
							),
							"heading" => 'Form horiz. align',
							"description" => "",
							"holder" => "div",
							'tdc_dropdown_images' => true,
							"class" => "tdc-visual-selector tdc-add-class tdc-woos-dropdown",
							"group"       => "",
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Input',
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"       => "",
						),
						array(
							"param_name" => "input_placeholder",
							"type" => "textfield",
							"value" => '',
							"heading" => "Placeholder",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => ""
						),
						array(
							"param_name" => "input_padding",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Padding",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "3px 9px"
						),
						array(
							"param_name" => "input_border",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Border size",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "1px 1px 1px 1px"
						),
						array(
							"param_name" => "input_radius",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Border radius",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "0"
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Button',
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"       => "",
						),
						array(
							"param_name" => "btn_text",
							"type" => "textfield",
							"value" => 'Search',
							"heading" => "Text",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => ""
						),
						array(
							'param_name' => 'btn_tdicon',
							'type' => 'icon',
							'heading' => 'Icon',
							'class' => 'tdc-textfield-small',
							'value' => '',
						),
						array(
							"param_name" => "btn_icon_pos",
							"type" => "dropdown",
							"value" => array(
								'Before' => '',
								'After' => 'after',
							),
							"heading" => 'Icon position',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big",
							"group" => "",
						),
						array(
							"param_name" => "btn_icon_size",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Icon size",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "12"
						),
						array(
							"param_name" => "btn_icon_space",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Icon space",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "0"
						),
						array(
							'param_name' => 'btn_icon_align',
							'type' => 'range-responsive',
							'value' => '0',
							'heading' => 'Icon align',
							'description' => '',
							'class' => 'tdc-textfield-small',
							'range_min' => '-10',
							'range_max' => '10',
							'range_step' => '1',
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => "",
						),
						array(
							"param_name" => "btn_margin",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Margin",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "0"
						),
						array(
							"param_name" => "btn_padding",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Padding",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "0 15px"
						),
						array(
							"param_name" => "btn_border",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Border size",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "0"
						),
						array(
							"param_name" => "btn_radius",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Border radius",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "0"
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Search results box',
							"value" => "",
							"class" => "tdc-separator",
							"group" => '',
						),
						array(
							"param_name" => "results_padding",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Padding",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "0 15px"
						),
						array(
							"param_name" => "results_border",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Border size",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big tdc-woos-dropdown",
							"placeholder" => "1px 0 0 0"
						),
						array(
							"param_name" => "results_border_reg",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Border size",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big tdc-woos-regular",
							"placeholder" => "0 0 1px"
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Results message',
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"       => "",
						),
						array(
							"param_name" => "results_msg_padding",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Padding",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "4px 0 6px 0"
						),
						array(
							"param_name" => "results_msg_border",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Border size",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "0"
						),
						array(
							"param_name" => "results_msg_align",
							"type" => "dropdown",
							"value" => array(
								'Left' => 'content-horiz-left',
								'Center' => 'content-horiz-center',
								'Right' => 'content-horiz-right'
							),
							"heading" => 'Horizontal align',
							"description" => "",
							"holder" => "div",
							'tdc_dropdown_images' => true,
							"class" => "tdc-visual-selector tdc-add-class",
							"group"       => "",
						),
						array(
							"param_name" => "results_limit",
							"type" => "textfield",
							"value" => '',
							"heading" => "Posts limit",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small",
							"placeholder" => "4",
							"group"       => "Results module",
						),
						array(
							"param_name"  => "modules_on_row",
							"type"        => "dropdown-responsive",
							"value"       => array(
								'1'  => '100%',
								'2'  => '50%',
								'3'  => '33.33333333%',
								'4'  => '25%',
								'5'  => '20%',
								'6'  => '16.66666667%',
								'7'  => '14.28571428%',
								'8'  => '12.5%',
								'9'  => '11.11111111%',
								'10' => '10%',
							),
							"heading"     => 'Modules per row',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-dropdown-small",
							"group"       => "Results module",
						),
						array(
							"param_name"  => "gap",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Products gap',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "20",
							"group"       => "Results module",
						),
						array(
							"param_name"  => "all_space",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Products bottom space',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "20",
							"group"       => "Results module",
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Product image',
							"value"      => "",
							"class"      => "",
							"group"       => "Results module",
						),
                        array(
                            "param_name"  => "img_size",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Medium - Default - 696x0px'  => '',
                                '-- [No crop] --' => '__',
                                'XSmall - 150x0px' => 'td_150x0',
                                'Small - 300x0px' => 'td_300x0',
                                'Large - 1068x0px' => 'td_1068x0',
                                'Full - 1920x0px'  => 'td_1920x0',
                                '-- [Other sizes] --' => '__',
                                '218x150px' => 'td_218x150',
                                '324x400px'  => 'td_324x400',
                                '485x360' => 'td_485x360'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Results module",
                            "info_img" => "",
                        ),
                        array(
                            "param_name"  => "img_width",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (0-100 percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100",
                            "group"       => "Results module",
                            "info_img" => "",
                        ),
                        array(
                            "param_name"  => "img_height",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100",
                            "group"       => "Results module",
                            "info_img" => "",
                        ),
                        array(
                            'param_name'  => 'img_alignment',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Results module",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Results module',
                        ),
                        array(
                            "param_name"  => "img_pos",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Float left'  => 'left',
                                'Float right' => 'right',
                                'Normal'      => 'normal',
                                'Hidden'      => 'hidden',
                            ),
                            "heading"     => 'Image position',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Results module",
                            "info_img" => "",
                        ),
						array(
							"param_name"  => "img_space",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Image right margin',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "16",
							"group"       => "Results module",
						),
                        array(
                            "param_name"  => "img_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "Results module",
                            "info_img" => "",
                        ),
                        array(
                            "param_name"  => "hide_image",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Hide image",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Results module',
                            "info_img"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Sale tag',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Results module",
                        ),
						array(
							"param_name"  => "sale_show",
							"type"        => "dropdown-responsive",
							"value"       => array(
								'Show'  => 'block',
								'Hide'  => 'none',
							),
							"heading"     => 'Show sale tag',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-dropdown-big",
							"group"       => "Results module",
						),
						array(
							"param_name"  => "sale_margin",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Sale tag margin',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-big",
							"placeholder" => "0",
							"group"       => "Results module",
						),
						array(
							"param_name"  => "sale_padding",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Sale tag padding',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-big",
							"placeholder" => "6",
							"group"       => "Results module",
						),
						array(
							"param_name"  => "sale_border",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Sale tag border size',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-big",
							"placeholder" => "0",
							"group"       => "Results module",
						),
						array(
							"param_name" => "sale_border_style",
							"type" => "dropdown-responsive",
							"value" => array(
								'Solid' => 'solid',
								'Dashed' => 'dashed',
								'Dotted' => 'dotted',
								'Double' => 'double',
							),
							"heading" => 'Sale tag border style',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big",
							"group" => "Results module",
						),
						array(
							"param_name"  => "sale_radius",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Sale tag border radius',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-big",
							"placeholder" => "0",
							"group"       => "Results module",
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Meta info',
							"value"      => "",
							"class"      => "",
							"group"       => "Results module",
						),
                        array(
                            "param_name"  => "meta_info_align",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Top'     => 'initial',
                                'Center'  => 'center',
                                'Bottom'  => 'flex-end',
                            ),
                            "heading"     => 'Vertical align',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Results module",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "horiz_align",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Results module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Results module',
                        ),
                        array(
                            "param_name"  => "meta_width",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Results module",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Results module',
                        ),
                        array(
                            "param_name"  => "meta_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Results module",
                            "info_img" => "",
                        ),
                        array(
                            "param_name"  => "meta_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Results module",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Results module',
                        ),
                        array(
                            "param_name"  => "meta_info_border_size",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Results module",
                            "info_img" => "",
                        ),
                        array(
                            "param_name"  => "meta_info_border_style",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Solid'  => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Results module",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Title',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Results module",
                        ),
                        array(
                            "param_name" => "product_title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Paragraph' => 'p'
                            ),
                            "heading" => 'Product title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group"       => "Results module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                        ),
						array(
							"param_name"  => "title_space",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Title bottom margin',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "5",
							"group"       => "Results module",
						),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Product description',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Results module",
                        ),
                        array(
                            "param_name"  => "show_excerpt",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Hide' => 'none',
                                'Show' => 'block',
                            ),
                            "heading"     => 'Show description',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Results module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_show_excerpt.png",
                        ),
                        array(
                            "param_name"  => "excerpt_type",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Short description' => '',
                                'Long description' => 'long',
                            ),
                            "heading"     => 'Product description type',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Results module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_show_excerpt.png",
                        ),
                        array(
                            "param_name"  => "excerpt_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Product excerpt space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "20px 0px 0px 0px",
                            "group"       => "Results module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_excerpt_space.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Review stars',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Results module",
                        ),
						array(
							"param_name"  => "show_stars",
							"type"        => "dropdown-responsive",
							"value"       => array(
								'Show' => 'inline-block',
								'Hide' => 'none',
							),
							"heading"     => 'Show review stars',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-dropdown-big",
							"group"       => "Results module",
						),
						array(
							"param_name"  => "stars_size",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Review stars size',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "11",
							"group"       => "Results module",
						),
						array(
							"param_name"  => "stars_space",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Review stars bottom margin',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "4",
							"group"       => "Results module",
						),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Price',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Results module",
                        ),
						array(
							"param_name"  => "price_space",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Price bottom margin',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "10",
							"group"       => "Results module",
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => 'Results module',
						),
						array(
							"param_name"  => "mod_vert_align",
							"type"        => "dropdown-responsive",
							"value"       => array(
								'Top'     => 'flex-start',
								'Center'  => 'center',
								'Bottom'  => 'flex-end',
							),
							"heading"     => 'Vertical align',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-dropdown-big",
							"group"       => "Results module",
						),
						array(
							"param_name" => "mod_horiz_align",
							"type" => "dropdown-responsive",
							"value" => array(
								'Left' => 'content-horiz-left',
								'Center' => 'content-horiz-center',
								'Right' => 'content-horiz-right'
							),
							"heading" => 'Horizontal align',
							"description" => "",
							"holder" => "div",
							'tdc_dropdown_images' => true,
							"class" => "tdc-visual-selector tdc-add-class",
							"group"       => "Results module",
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Button',
							"value"      => "",
							"class"      => "",
							"group"       => "Results module",
						),
						array(
							"param_name"  => "mod_btn_padding",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Padding',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-big",
							"placeholder" => "8px 8px 8px 8px",
							"group"       => "Results module",
						),
						array(
							"param_name"  => "mod_btn_border",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Border size',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-big",
							"placeholder" => "0",
							"group"       => "Results module",
						),
						array(
							"param_name"  => "mod_btn_border_style",
							"type"        => "dropdown-responsive",
							"value"       => array(
								'Solid'  => 'solid',
								'Dotted' => 'dotted',
								'Dashed' => 'dashed',
							),
							"heading"     => 'Border style',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-dropdown-big",
							"group"       => "Results module",
						),
						array(
							"param_name"  => "mod_btn_radius",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Button radius',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-big",
							"placeholder" => "0",
							"group"       => "Results module",
						),
						array(
							"param_name"  => "mod_show_btn",
							"type"        => "dropdown-responsive",
							"value"       => array(
								'Show' => 'inline-block',
								'Hide' => 'none',
							),
							"heading"     => 'Show button',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-dropdown-big",
							"group"       => "Results module",
						),

						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "tdc-woos-dropdown",
							"heading" => 'Form general background',
							"param_name" => "form_general_bg",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Search icon',
							"value" => "",
							"class" => "tdc-separator tdc-woos-dropdown",
							"group" => 'Style',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a tdc-woos-dropdown",
							"heading" => 'Icon color',
							"param_name" => "icon_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b tdc-woos-dropdown",
							"heading" => 'Icon hover color',
							"param_name" => "icon_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"param_name" => "separator",
							"type"       => "horizontal_separator",
							"value"      => "",
							"class"      => "tdc-separator-small tdc-woos-dropdown",
							"group"       => 'Style',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a tdc-woos-dropdown",
							"heading" => 'Text color',
							"param_name" => "toggle_txt_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b tdc-woos-dropdown",
							"heading" => 'Text hover color',
							"param_name" => "toggle_txt_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
					),
					td_config_helper::get_map_block_font_array( 'f_toggle_txt', true, 'Text', 'Style', '', 'tdc-woos-dropdown'),
					array(
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Search form',
							"value" => "",
							"class" => "tdc-separator",
							"group" => 'Style',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "tdc-woos-dropdown",
							"heading" => 'Form background',
							"param_name" => "form_bg",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "tdc-woos-dropdown",
							"heading" => 'Form border color',
							"param_name" => "form_border_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "tdc-woos-dropdown",
							"heading" => 'Arrow color',
							"param_name" => "arrow_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
					),
					td_config_helper::get_map_block_shadow_array('form_shadow', 'Shadow', 6, 0, 2, 'Style', '', 0, true, 'tdc-woos-dropdown' ),
					array(
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Input',
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => 'Style',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => 'Text color',
							"param_name" => "input_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => 'Placeholder color',
							"param_name" => "placeholder_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => 'Background color',
							"param_name" => "input_bg",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => 'Border color',
							"param_name" => "input_border_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
					),
					td_config_helper::get_map_block_shadow_array('input_shadow', 'Input shadow', 0, 0, 0, "Style" ),
					array(
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Button',
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => 'Style',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Text color',
							"param_name" => "btn_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Hover text color',
							"param_name" => "btn_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Icon color',
							"param_name" => "btn_icon_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Icon hover color',
							"param_name" => "btn_icon_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "gradient",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Background color',
							"param_name" => "btn_bg",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "gradient",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Hover background color',
							"param_name" => "btn_bg_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Border color',
							"param_name" => "btn_border_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Hover border color',
							"param_name" => "btn_border_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
					),
					td_config_helper::get_map_block_shadow_array('btn_shadow', 'Button shadow', 0, 0, 0, "Style" ),
					array(
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Fonts',
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => 'Style',
						),
					),
					td_config_helper::get_map_block_font_array( 'f_input', true, 'Input text', 'Style' ),
					td_config_helper::get_map_block_font_array( 'f_placeholder', false, 'Placeholder text', 'Style' ),
					td_config_helper::get_map_block_font_array( 'f_btn', false, 'Button text', 'Style' ),
					array(
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Search results box',
							"value"      => "",
							"class"      => "",
							"group"      => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => 'Background color',
							"param_name" => "results_bg",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => 'Border color',
							"param_name" => "results_border_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
					),
					td_config_helper::get_map_block_shadow_array('results_shadow', 'Shadow', 6, 0, 2, 'Style', '', 0, true, 'tdc-woos-regular' ),
					array(
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Results message',
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"       => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Text color',
							"param_name" => "results_msg_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Text hover color',
							"param_name" => "results_msg_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => 'Background color',
							"param_name" => "results_msg_bg",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => 'Border color',
							"param_name" => "results_msg_border_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
					),
					td_config_helper::get_map_block_font_array( 'f_results_msg', true, 'Text', 'Style' ),
					array(
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Search results module',
							"value"      => "",
							"class"      => "",
							"group"       => "Style",
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Sale tag',
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"       => "Style",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-a",
							"heading"     => 'Text color',
							"param_name"  => "sale_txt_color",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-b",
							"heading"     => 'Text hover color',
							"param_name"  => "sale_txt_color_h",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-a",
							"heading"     => 'Background color',
							"param_name"  => "sale_bg_color",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-b",
							"heading"     => 'Background hover color',
							"param_name"  => "sale_bg_color_h",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-a",
							"heading"     => 'Border color',
							"param_name"  => "sale_border_color",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-b",
							"heading"     => 'Border hover color',
							"param_name"  => "sale_border_color_h",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Meta info',
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"       => "Style",
						),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Background color',
                            "param_name"  => "meta_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Border color',
                            "param_name"  => "meta_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Title',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Style",
                        ),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-a",
							"heading"     => 'Title color',
							"param_name"  => "title_color",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-b",
							"heading"     => 'Title hover color',
							"param_name"  => "title_color_h",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Product description',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Product description color',
                            "param_name"  => "ex_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_excerpt.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Review stars',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Style",
                        ),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "",
							"heading"     => 'Full stars color',
							"param_name"  => "stars_full_color",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "",
							"heading"     => 'Empty stars color',
							"param_name"  => "stars_empty_color",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Price',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Style",
                        ),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "",
							"heading"     => 'Price color',
							"param_name"  => "price_color",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Sale price color',
                            "param_name"  => "sale_price_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "",
							"heading"     => 'Old price color',
							"param_name"  => "old_price_color",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Button',
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"       => "Style",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-a",
							"heading"     => 'Text color',
							"param_name"  => "mod_btn_txt_color",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-b",
							"heading"     => 'Text hover color',
							"param_name"  => "mod_btn_txt_color_h",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-a",
							"heading"     => 'Background color',
							"param_name"  => "mod_btn_bg_color",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-b",
							"heading"     => 'Background hover color',
							"param_name"  => "mod_btn_bg_color_h",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-a",
							"heading"     => 'Border color',
							"param_name"  => "mod_btn_border_color",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-b",
							"heading"     => 'Border hover color',
							"param_name"  => "mod_btn_border_color_h",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Fonts',
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"       => "Style",
						),
					),
					td_config_helper::get_map_block_font_array( 'f_sale', true, 'Sale tag text', 'Style'),
					td_config_helper::get_map_block_font_array( 'f_title', false, 'Title text', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_ex', false, 'Product description', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_price', false, 'Price text', 'Style'),
					td_config_helper::get_map_block_font_array( 'f_old_price', false, 'Old price text', 'Style'),
					td_config_helper::get_map_block_font_array( 'f_mod_btn', false, 'Button text', 'Style'),

					self::get_block_style()
				)
			)
		);

		td_api_block::add( 'td_woo_menu_cart',
			array(
				'map_in_td_composer' => true,
				"name" => 'Woo Menu Cart',
				"base" => "td_woo_menu_cart",
				"class" => "",
				"controls" => "full",
				"category" => 'Blocks',
				'tdc_category' => 'Header shortcodes',
				'icon' => 'icon-pagebuilder-td_woo_menu_cart',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_menu_cart.php',
				'tdc_style_params' => array(
					'show_version',
					'show_cart',
					'tdicon',
					'el_class'
				),
				'tdc_start_values' => base64_encode(
					json_encode(
						array(
							array(
								"tdicon" => "td-icon-cart-empty",
								"inline" => "yes",
								"cart_horiz_align" => "content-horiz-right",
								"subtotal_horiz" => "content-horiz-right",
							)
						)
					)
				),
				'params' => array_merge(
					array(
						array(
							"param_name" => "show_version",
							"type" => "dropdown",
							"value" => array(
								'With items' => '',
								'Without items' => 'no_items',
							),
							"heading" => 'Show',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big",
							"group" => "",
						),
						array(
							"param_name" => "show_cart",
							"type" => "checkbox",
							"value" => '',
							"heading" => "Show cart",
							"description" => "",
							"holder" => "div",
							"class" => "",
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Toggle',
							"value" => "",
							"class" => "tdc-separator",
							"group" => '',
						),
						array(
							'param_name' => 'tdicon',
							'type' => 'icon',
							'heading' => 'Icon',
							'class' => 'tdc-textfield-small',
							'value' => '',
						),
						array(
							'param_name' => 'icon_size',
							'type' => 'range-responsive',
							'value' => '24',
							'heading' => 'Icon size',
							'description' => '',
							'class' => 'tdc-textfield-small',
							'range_min' => '1',
							'range_max' => '60',
							'range_step' => '1',
							"group"       => "",
						),
						array(
							"param_name" => "icon_space",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Icon space",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small",
							"placeholder" => "12"
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => "",
						),
						array(
							"param_name" => "toggle_txt_pos",
							"type" => "dropdown",
							"value" => array(
								'After icon' => '',
								'Before icon' => 'before',
							),
							"heading" => 'Text position',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big",
							"group" => "",
						),
						array(
							'param_name' => 'toggle_txt_align',
							'type' => 'range-responsive',
							'value' => '0',
							'heading' => 'Text vert. position',
							'description' => '',
							'class' => 'tdc-textfield-small',
							'range_min' => '-10',
							'range_max' => '10',
							'range_step' => '1',
						),
						array(
							"param_name"  => "show_count",
							"type"        => "dropdown-responsive",
							"value"       => array(
								'Show' => 'flex',
								'Hide' => 'none',
							),
							"heading"     => 'Show cart items count',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-dropdown-big",
							"group"       => "",
						),
						array(
							"param_name"  => "show_value",
							"type"        => "dropdown-responsive",
							"value"       => array(
								'Show' => 'flex',
								'Hide' => 'none',
							),
							"heading"     => 'Show cart value',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-dropdown-big",
							"group"       => "",
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => "",
						),
						array(
							"param_name" => "toggle_horiz_align",
							"type" => "dropdown-responsive",
							"value" => array(
								'Left' => 'content-horiz-left',
								'Center' => 'content-horiz-center',
								'Right' => 'content-horiz-right'
							),
							"heading" => 'Horizontal align',
							"description" => "",
							"holder" => "div",
							'tdc_dropdown_images' => true,
							"class" => "tdc-visual-selector tdc-add-class",
							"group"       => "",
						),
						array(
							"param_name" => "inline",
							"type" => "checkbox",
							"value" => '',
							"heading" => "Make inline",
							"description" => "",
							"holder" => "div",
							"class" => "",
						),
						array(
							"param_name" => "float_block",
							"type" => "checkbox",
							"value" => '',
							"heading" => 'Align block to right',
							"description" => "",
							"holder" => "div",
							"class" => ""
						),

						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Cart',
							"value" => "",
							"class" => "tdc-separator",
							"group" => '',
						),
						array(
							"param_name" => "cart_offset",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Top offset",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small",
							"placeholder" => "20"
						),
						array(
							"param_name" => "cart_width",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Width",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small",
							"placeholder" => "290"
						),
						array(
							"param_name" => "cart_border",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Border size",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "0"
						),
						array(
							"param_name" => "cart_border_style",
							"type" => "dropdown-responsive",
							"value" => array(
								'Solid' => '',
								'Dashed' => 'dashed',
								'Dotted' => 'dotted',
								'Double' => 'double',
							),
							"heading" => 'Border style',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big",
							"group" => "",
						),
						array(
							"param_name" => "cart_border_radius",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Border radius",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "0"
						),
						array(
							"param_name" => "cart_horiz_align",
							"type" => "dropdown-responsive",
							"value" => array(
								'Left' => 'content-horiz-left',
								'Center' => 'content-horiz-center',
								'Right' => 'content-horiz-right'
							),
							"heading" => 'Horizontal align',
							"description" => "",
							"holder" => "div",
							'tdc_dropdown_images' => true,
							"class" => "tdc-visual-selector tdc-add-class",
							"group"       => "",
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'With items',
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"       => "",
						),
						array(
							"param_name" => "cart_padding",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Padding",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "7px 0 15px"
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Empty',
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"       => "",
						),
						array(
							"param_name" => "cart_padding_e",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Padding",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "15"
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Items list',
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"       => "",
						),
						array(
							"param_name"  => "items_padd",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Padding',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-big",
							"placeholder" => "0 0 7px",
							"group"       => "",
						),
						array(
							"param_name"  => "items_border",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Bottom border size',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "1",
							"group"       => "",
						),
						array(
							"param_name" => "items_border_style",
							"type" => "dropdown-responsive",
							"value" => array(
								'Solid' => '',
								'Dashed' => 'dashed',
								'Dotted' => 'dotted',
								'Double' => 'double',
							),
							"heading" => 'Bottom border style',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big",
							"group" => "",
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Items',
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"       => "",
						),
						array(
							"param_name"  => "item_space",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Bottom space',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "0",
							"group"       => "",
						),
						array(
							"param_name"  => "item_tb_padd",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Padding top & bottom',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "8",
							"group"       => "",
						),
						array(
							"param_name"  => "item_lr_padd",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Padding left & right',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "15",
							"group"       => "",
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => '',
						),
						array(
							'param_name' => 'image_width',
							'type' => 'range-responsive',
							'value' => '40',
							'heading' => 'Image width',
							'description' => '',
							'class' => 'tdc-textfield-small',
							'range_min' => '10',
							'range_max' => '150',
							'range_step' => '1',
							"group" => "",
						),
						array(
							'param_name' => 'image_space',
							'type' => 'range-responsive',
							'value' => '6',
							'heading' => 'Image right space',
							'description' => '',
							'class' => 'tdc-textfield-small',
							'range_min' => '0',
							'range_max' => '50',
							'range_step' => '1',
							"group" => "",
						),
						array(
							"param_name"  => "image_radius",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Image radius',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "0",
							"group"       => "",
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => '',
						),
						array(
							"param_name"  => "meta_info_vert",
							"type"        => "dropdown-responsive",
							"value"       => array(
								'Top'     => 'flex-start',
								'Center'  => 'center',
								'Bottom'  => 'flex-end',
							),
							"heading"     => 'Meta info vertical align',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-dropdown-big",
							"group"       => "",
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => '',
						),
						array(
							'param_name' => 'qty_align',
							'type' => 'range-responsive',
							'value' => '2',
							'heading' => 'Quantity vert. align',
							'description' => '',
							'class' => 'tdc-textfield-small',
							'range_min' => '-20',
							'range_max' => '20',
							'range_step' => '1',
							"group"       => "",
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => '',
						),
						array(
							"param_name"  => "var_top",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Variations top space',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "4",
							"group"       => "",
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Cart info',
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"       => "",
						),
						array(
							"param_name"  => "subtotal_padd",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Subtotal padding',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-big",
							"placeholder" => "15",
							"group"       => "",
						),
						array(
							"param_name" => "subtotal_horiz",
							"type" => "dropdown-responsive",
							"value" => array(
								'Left' => 'content-horiz-left',
								'Center' => 'content-horiz-center',
								'Right' => 'content-horiz-right'
							),
							"heading" => 'Subtotal horiz align',
							"description" => "",
							"holder" => "div",
							'tdc_dropdown_images' => true,
							"class" => "tdc-visual-selector tdc-add-class",
							"group"       => "",
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => '',
						),
						array(
							"param_name"  => "btns_padd",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Buttons group padding',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-big",
							"placeholder" => "0 15px",
							"group"       => "",
						),
						array(
							"param_name"  => "btn_gap",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Buttons gap',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "10",
							"group"       => "",
						),
						array(
							"param_name"  => "btn_radius",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Buttons border radius',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "0",
							"group"       => "",
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "",
							"group" => '',
						),

						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Toggle',
							"value" => "",
							"class" => "tdc-separator",
							"group" => 'Style',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Icon color',
							"param_name" => "icon_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Icon hover color',
							"param_name" => "icon_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"param_name" => "separator",
							"type"       => "horizontal_separator",
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"       => 'Style',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => 'Cart items counts text color',
							"param_name" => "count_txt_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => 'Cart items counts background color',
							"param_name" => "count_bg_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"param_name" => "separator",
							"type"       => "horizontal_separator",
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"       => 'Style',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Cart value text color',
							"param_name" => "toggle_txt_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Cart value text hover color',
							"param_name" => "toggle_txt_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"param_name" => "separator",
							"type"       => "horizontal_separator",
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"       => 'Style',
						),
					),
					td_config_helper::get_map_block_font_array( 'f_count', true, 'Cart items count text', 'Style' ),
					td_config_helper::get_map_block_font_array( 'f_toggle', false, 'Cart value text', 'Style' ),
					array(
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Cart',
							"value" => "",
							"class" => "tdc-separator",
							"group" => 'Style',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => 'Background',
							"param_name" => "cart_bg",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => 'Border color',
							"param_name" => "cart_border_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => 'Arrow color',
							"param_name" => "cart_arrow_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
					),
					td_config_helper::get_map_block_shadow_array('cart_shadow', 'Shadow', 6, 0, 2, 'Style' ),
					array(
						array(
							"param_name" => "separator",
							"type"       => "horizontal_separator",
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"       => 'Style',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => 'No items text color',
							"param_name" => "cart_no_items_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
					),
					td_config_helper::get_map_block_font_array( 'f_noitems', true, 'No items text', 'Style' ),
					array(
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Items list',
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => 'Style',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => 'Bottom border color',
							"param_name" => "items_border_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Items',
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => 'Style',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Background color',
							"param_name" => "item_bg_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Background hover color',
							"param_name" => "item_bg_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"param_name" => "separator",
							"type"       => "horizontal_separator",
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"       => 'Style',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Title color',
							"param_name" => "title_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Title hover color',
							"param_name" => "title_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Amount color',
							"param_name" => "amount_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Amount color',
							"param_name" => "amount_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Variations color',
							"param_name" => "var_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Variations color',
							"param_name" => "var_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Delete link color',
							"param_name" => "delete_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Delete link hover color',
							"param_name" => "delete_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"param_name" => "separator",
							"type"       => "horizontal_separator",
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"       => 'Style',
						),
					),
					td_config_helper::get_map_block_font_array( 'f_title', true, 'Items title text', 'Style' ),
					td_config_helper::get_map_block_font_array( 'f_amount', false, 'Items amount text', 'Style' ),
					td_config_helper::get_map_block_font_array( 'f_var', false, 'Variations text', 'Style' ),
					array(
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Cart info',
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => 'Style',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => 'Subtotal color',
							"param_name" => "subtotal_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"param_name" => "separator",
							"type"       => "horizontal_separator",
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"       => 'Style',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'View cart button color',
							"param_name" => "btn1_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'View cart button hover color',
							"param_name" => "btn1_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'View cart button background color',
							"param_name" => "btn1_bg_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'View cart button background hover color',
							"param_name" => "btn1_bg_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"param_name" => "separator",
							"type"       => "horizontal_separator",
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"       => 'Style',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Checkout button color',
							"param_name" => "btn2_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Checkout button hover color',
							"param_name" => "btn2_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Checkout button background color',
							"param_name" => "btn2_bg_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Checkout button background hover color',
							"param_name" => "btn2_bg_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"param_name" => "separator",
							"type"       => "horizontal_separator",
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"       => 'Style',
						),
					),
					td_config_helper::get_map_block_font_array( 'f_subtotal', true, 'Subtotal text', 'Style' ),
					td_config_helper::get_map_block_font_array( 'f_btns', false, 'Buttons text', 'Style' ),
					array(

						array (
							'param_name' => 'css',
							'value' => '',
							'type' => 'css_editor',
							'heading' => 'Css',
							'group' => 'Design options',
						),
						array (
							'param_name' => 'tdc_css',
							'value' => '',
							'type' => 'tdc_css_editor',
							'heading' => '',
							'group' => 'Design options',
						),
						array(
							'param_name' => 'el_class',
							'type' => 'textfield',
							'value' => '',
							'heading' => 'Extra class',
							'description' => 'Style particular content element differently - add a class name and refer to it in custom CSS',
							'class' => 'tdc-textfield-extrabig',
						),
					)
				)
			)
		);

		td_api_block::add( 'td_woo_menu_login',
			array(
				'map_in_td_composer' => true,
				"name" => 'Woo Menu Login',
				"base" => "td_woo_menu_login",
				"class" => "",
				"controls" => "full",
				"category" => 'Blocks',
				'tdc_category' => 'Header shortcodes',
				'icon' => 'icon-pagebuilder-td_woo_menu_login',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_menu_login.php',
				'tdc_style_params' => array(
					'show_version',
					'guest_tdicon',
					'logout_tdicon',
					'menu_gh_txt',
					'menu_gc_btn1_txt',
					'menu_gc_btn2_txt',
					'el_class'
				),
				'tdc_start_values' => base64_encode(
					json_encode(
						array(
							array(
								"inline" => "yes",
								"guest_tdicon" => "td-icon-profile",
								"toggle_txt" => "My account",
								"logout_tdicon" => "td-icon-log-out",
								"menu_gh_txt" => "Get into your account."
							),
						)
					)
				),
				'params' => array_merge(
					array(
						array(
							"param_name" => "show_version",
							"type" => "dropdown",
							"value" => array(
								'Logged in version' => '',
								'Guest version' => 'guest',
							),
							"heading" => 'Show',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big",
							"group" => "",
						),
						array(
							"param_name" => "show_menu",
							"type" => "checkbox",
							"value" => '',
							"heading" => "Show menu",
							"description" => "",
							"holder" => "div",
							"class" => "",
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Toggle',
							"value" => "",
							"class" => "tdc-separator",
							"group" => '',
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Guest',
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => '',
						),
						array(
							'param_name' => 'guest_tdicon',
							'type' => 'icon',
							'heading' => 'Icon',
							'class' => 'tdc-textfield-small',
							'value' => '',
						),
						array(
							'param_name' => 'icon_size',
							'type' => 'range-responsive',
							'value' => '24',
							'heading' => 'Icon size',
							'description' => '',
							'class' => 'tdc-textfield-small',
							'range_min' => '1',
							'range_max' => '60',
							'range_step' => '1',
							"group"       => "",
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Logged in user',
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => '',
						),
						array(
							"param_name" => "avatar_size",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Avatar size",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small",
							"placeholder" => "25"
						),
						array(
							"param_name" => "avatar_radius",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Avatar radius",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small",
							"placeholder" => "100"
						),
						array(
							"param_name"  => "show_avatar",
							"type"        => "dropdown-responsive",
							"value"       => array(
								'Show' => 'block',
								'Hide' => 'none',
							),
							"heading"     => 'Show avatar',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-dropdown-big",
							"group"       => "",
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'General',
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => '',
						),
						array(
							"param_name" => "ia_space",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Icon/avatar space",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small",
							"placeholder" => "12"
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => "",
						),
						array(
							"param_name" => "toggle_txt",
							"type" => "textfield",
							"value" => '',
							"heading" => "Text",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => ""
						),
						array(
							"param_name" => "toggle_txt_pos",
							"type" => "dropdown",
							"value" => array(
								'After icon/avatar' => '',
								'Before icon/avatar' => 'before',
							),
							"heading" => 'Text position',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big",
							"group" => "",
						),
						array(
							"param_name" => "toggle_hide",
							"type" => "checkbox-responsive",
							"value" => '',
							"heading" => "Hide text",
							"description" => "",
							"holder" => "div",
							"class" => ""
						),
						array(
							'param_name' => 'toggle_txt_align',
							'type' => 'range-responsive',
							'value' => '0',
							'heading' => 'Text vert. position',
							'description' => '',
							'class' => 'tdc-textfield-small',
							'range_min' => '-10',
							'range_max' => '10',
							'range_step' => '1',
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => "",
						),
						array(
							"param_name" => "toggle_horiz_align",
							"type" => "dropdown-responsive",
							"value" => array(
								'Left' => 'content-horiz-left',
								'Center' => 'content-horiz-center',
								'Right' => 'content-horiz-right'
							),
							"heading" => 'Horizontal align',
							"description" => "",
							"holder" => "div",
							'tdc_dropdown_images' => true,
							"class" => "tdc-visual-selector tdc-add-class",
							"group"       => "",
						),
						array(
							"param_name" => "inline",
							"type" => "checkbox",
							"value" => '',
							"heading" => "Make inline",
							"description" => "",
							"holder" => "div",
							"class" => "",
						),

						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Menu',
							"value" => "",
							"class" => "tdc-separator",
							"group" => '',
						),
						array(
							"param_name" => "menu_offset_top",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Menu top offset",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small",
							"placeholder" => "20"
						),
						array(
							'param_name' => 'menu_offset_horiz',
							'type' => 'range-responsive',
							'value' => '8',
							'heading' => 'Menu horizontal offset',
							'description' => '',
							'class' => 'tdc-textfield-small',
							'range_min' => '0',
							'range_max' => '100',
							'range_step' => '1',
							"group"       => "",
						),
						array(
							"param_name" => "menu_width",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Width",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small",
							"placeholder" => "200"
						),
						array(
							"param_name" => "menu_padding",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Padding",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "0"
						),
						array(
							"param_name" => "menu_border",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Border size",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "0"
						),
						array(
							"param_name" => "menu_border_style",
							"type" => "dropdown-responsive",
							"value" => array(
								'Solid' => '',
								'Dashed' => 'dashed',
								'Dotted' => 'dotted',
								'Double' => 'double',
							),
							"heading" => 'Border style',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big",
							"group" => "",
						),
						array(
							"param_name" => "menu_border_radius",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Border radius",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "0"
						),
						array(
							"param_name" => "menu_horiz_align",
							"type" => "dropdown-responsive",
							"value" => array(
								'Left' => 'content-horiz-left',
								'Center' => 'content-horiz-center',
								'Right' => 'content-horiz-right'
							),
							"heading" => 'Horizontal align',
							"description" => "",
							"holder" => "div",
							'tdc_dropdown_images' => true,
							"class" => "tdc-visual-selector tdc-add-class",
							"group"       => "",
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Logged in menu',
							"value" => "",
							"class" => "tdc-separator",
							"group" => '',
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Header',
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => '',
						),
						array(
							"param_name" => "menu_uh_padd",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Padding",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "11px 20px"
						),
						array(
							"param_name" => "menu_uh_border",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Border bottom size",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small",
							"placeholder" => "1"
						),
						array(
							"param_name" => "menu_uh_border_style",
							"type" => "dropdown-responsive",
							"value" => array(
								'Solid' => '',
								'Dashed' => 'dashed',
								'Dotted' => 'dotted',
								'Double' => 'double',
							),
							"heading" => 'Border bottom style',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big",
							"group" => "",
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Content',
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => '',
						),
						array(
							"param_name" => "menu_ul_padd",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Padding",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "10px 20px"
						),
						array(
							"param_name" => "menu_ul_space",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Links space",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small",
							"placeholder" => "0"
						),
                        array(
                            "param_name" => "menu_ul_sep_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => "Links separator space",
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "8"
                        ),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Footer',
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => '',
						),
						array(
							"param_name" => "menu_ulo_txt",
							"type" => "textfield",
							"value" => '',
							"heading" => "Logout text",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "Log out"
						),
						array(
							'param_name' => 'logout_tdicon',
							'type' => 'icon',
							'heading' => 'Icon',
							'class' => 'tdc-textfield-small',
							'value' => '',
						),
						array(
							'param_name' => 'logout_size',
							'type' => 'range-responsive',
							'value' => '14',
							'heading' => 'Icon size',
							'description' => '',
							'class' => 'tdc-textfield-small',
							'range_min' => '1',
							'range_max' => '60',
							'range_step' => '1',
							"group"       => "",
						),
						array(
							"param_name" => "logout_space",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Icon space",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small",
							"placeholder" => "8"
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => "",
						),
						array(
							"param_name" => "menu_ulo_padd",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Padding",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "11px 20px"
						),
						array(
							"param_name" => "menu_ulo_border",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Border top size",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small",
							"placeholder" => "1"
						),
						array(
							"param_name" => "menu_ulo_border_style",
							"type" => "dropdown-responsive",
							"value" => array(
								'Solid' => '',
								'Dashed' => 'dashed',
								'Dotted' => 'dotted',
								'Double' => 'double',
							),
							"heading" => 'Border top style',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big",
							"group" => "",
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Guest menu',
							"value" => "",
							"class" => "tdc-separator",
							"group" => '',
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Header',
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => '',
						),
						array(
							"param_name" => "menu_gh_txt",
							"type" => "textfield",
							"value" => '',
							"heading" => "Text",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => ""
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => "",
						),
						array(
							"param_name" => "menu_gh_padd",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Padding",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "11px 20px"
						),
						array(
							"param_name" => "menu_gh_border",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Border bottom size",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small",
							"placeholder" => "1"
						),
						array(
							"param_name" => "menu_gh_border_style",
							"type" => "dropdown-responsive",
							"value" => array(
								'Solid' => '',
								'Dashed' => 'dashed',
								'Dotted' => 'dotted',
								'Double' => 'double',
							),
							"heading" => 'Border bottom style',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big",
							"group" => "",
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Content',
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => '',
						),
						array(
							"param_name" => "menu_gc_padd",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Padding",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "15px 20px"
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => "",
						),
						array(
							"param_name" => "menu_gc_btn1_txt",
							"type" => "textfield",
							"value" => '',
							"heading" => "Login button text",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "Login"
						),
						array(
							"param_name" => "menu_gc_btn1_padd",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Login button padding",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "9px 14px 11px"
						),
						array(
							"param_name" => "menu_gc_btn1_border",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Login button border size",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "0"
						),
						array(
							"param_name" => "menu_gc_btn1_border_style",
							"type" => "dropdown-responsive",
							"value" => array(
								'Solid' => '',
								'Dashed' => 'dashed',
								'Dotted' => 'dotted',
								'Double' => 'double',
							),
							"heading" => 'Login button border style',
							"description" => "",
							"holder" => "div",
							"class" => "tdc-dropdown-big",
							"group" => "",
						),
						array(
							"param_name" => "menu_gc_btn1_radius",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Login button border radius",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small",
							"placeholder" => "0"
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => "",
						),
						array(
							"param_name" => "menu_gc_btn2_txt",
							"type" => "textfield",
							"value" => '',
							"heading" => "Signup button text",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							"placeholder" => "Register"
						),
						array(
							"param_name" => "menu_gc_btn2_space",
							"type" => "textfield-responsive",
							"value" => '',
							"heading" => "Signup button left space",
							"description" => "",
							"holder" => "div",
							"class" => "tdc-textfield-small",
							"placeholder" => "12"
						),

						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Toggle',
							"value" => "",
							"class" => "tdc-separator",
							"group" => 'Style',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Icon color',
							"param_name" => "icon_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Icon hover color',
							"param_name" => "icon_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"param_name" => "separator",
							"type"       => "horizontal_separator",
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"       => 'Style',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Text color',
							"param_name" => "toggle_txt_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Text hover color',
							"param_name" => "toggle_txt_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
					),
					td_config_helper::get_map_block_font_array( 'f_toggle', true, 'Toggle text', 'Style' ),
					array(
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Menu',
							"value" => "",
							"class" => "tdc-separator",
							"group" => 'Style',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => 'Background',
							"param_name" => "menu_bg",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => 'Border color',
							"param_name" => "menu_border_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => 'Arrow color',
							"param_name" => "menu_arrow_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
					),
					td_config_helper::get_map_block_shadow_array('menu_shadow', 'Shadow', 6, 0, 2, 'Style' ),
					array(
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Logged in menu',
							"value" => "",
							"class" => "tdc-separator",
							"group" => 'Style',
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Header',
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => 'Style',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => 'Text color',
							"param_name" => "menu_uh_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => 'Bottom border color',
							"param_name" => "menu_uh_border_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Content',
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => 'Style',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Links color',
							"param_name" => "menu_ul_link_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Links hover color',
							"param_name" => "menu_ul_link_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Links separator color',
                            "param_name" => "menu_ul_sep_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Style",
                        ),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Footer',
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => 'Style',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Text color',
							"param_name" => "menu_uf_txt_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Text hover color',
							"param_name" => "menu_uf_txt_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Icon color',
							"param_name" => "menu_uf_icon_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Icon hover color',
							"param_name" => "menu_uf_icon_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => 'Top border color',
							"param_name" => "menu_uf_border_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Fonts',
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => 'Style',
						),
					),
					td_config_helper::get_map_block_font_array( 'f_uh', true, 'Header text', 'Style' ),
					td_config_helper::get_map_block_font_array( 'f_links', false, 'Links text', 'Style' ),
					td_config_helper::get_map_block_font_array( 'f_uf', false, 'Footer text', 'Style' ),
					array(
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Guest menu',
							"value" => "",
							"class" => "tdc-separator",
							"group" => 'Style',
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Header',
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => 'Style',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => 'Text color',
							"param_name" => "menu_gh_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => 'Bottom border color',
							"param_name" => "menu_gh_border_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Content',
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => 'Style',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Login button color',
							"param_name" => "menu_gc_btn1_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Login button hover color',
							"param_name" => "menu_gc_btn1_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Login button background color',
							"param_name" => "menu_gc_btn1_bg_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Login button background hover color',
							"param_name" => "menu_gc_btn1_bg_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Login button border color',
							"param_name" => "menu_gc_btn1_border_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Login button border hover color',
							"param_name" => "menu_gc_btn1_border_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"param_name" => "separator",
							"type"       => "horizontal_separator",
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"       => 'Style',
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-a",
							"heading" => 'Signup button color',
							"param_name" => "menu_gc_btn2_color",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "td-colorpicker-double-b",
							"heading" => 'Signup button hover color',
							"param_name" => "menu_gc_btn2_color_h",
							"value" => '',
							"description" => '',
							"group" => "Style",
						),
						array(
							"param_name" => "separator",
							"type" => "text_separator",
							'heading' => 'Fonts',
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => 'Style',
						),
					),
					td_config_helper::get_map_block_font_array( 'f_gh', true, 'Header text', 'Style' ),
					td_config_helper::get_map_block_font_array( 'f_btn1', false, 'Login button text', 'Style' ),
					td_config_helper::get_map_block_font_array( 'f_btn2', false, 'Signup button text', 'Style' ),

					self::get_block_style()
				)
			)
		);

        td_api_block::add( 'td_woo_menu_favorites',
            array(
                'map_in_td_composer' => true,
                "name" => 'Woo Menu Favorites',
                "base" => "td_woo_menu_favorites",
                "class" => "",
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Header shortcodes',
                'icon' => 'icon-pagebuilder-td_woo_menu_favorites',
                'file' => TD_WOO_DIR . '/shortcodes/td_woo_menu_favorites.php',
                'tdc_style_params' => array(
                    'url',
                    'tdicon',
                    'add_txt',
                    'el_class'
                ),
                'tdc_start_values' => base64_encode(
                    json_encode(
                        array(
                            array(
                                "tdicon" => "td-icon-heart-full",
                                "inline" => "yes",
                            )
                        )
                    )
                ),
                'params' => array_merge(
                    array(
                        array(
                            'param_name' => 'url',
                            'type' => 'textfield',
                            'value' => '',
                            'heading' => 'Favorites page url',
                            'description' => '',
                            'class' => 'tdc-textfield-big',
                            'placeholder' => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "new_tab",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Open url in new window",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Layout',
                            "value"      => "",
                            "class"      => "",
                            'group' => ''
                        ),
                        array(
                            'param_name' => 'tdicon',
                            'type' => 'icon',
                            'heading' => 'Icon',
                            'class' => 'tdc-textfield-small',
                            'value' => '',
                        ),
                        array(
                            'type' => 'range-responsive',
                            'param_name' => 'icon_size',
                            'value' => '22',
                            'heading' => 'Icon size',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '10',
                            'range_max' => '150',
                            'range_step' => '5',
                        ),
                        array(
                            'param_name' => 'icon_space',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Icon space',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'placeholder' => '12',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "param_name"  => "show_count",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'flex',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show favorites count',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            'param_name' => 'add_txt',
                            'type' => 'textfield',
                            'value' => '',
                            'heading' => 'Additional text',
                            'description' => '',
                            'class' => 'tdc-textfield-big',
                            'placeholder' => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "add_txt_pos",
                            "type" => "dropdown",
                            "value" => array(
                                'After icon' => '',
                                'Before text' => 'before',
                            ),
                            "heading" => 'Additional text position',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "horiz_align",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "inline",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Make inline",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                        ),
                        array(
                            "param_name" => "float_block",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => 'Align block to right',
                            "description" => "",
                            "holder" => "div",
                            "class" => ""
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Style',
                            "value"      => "",
                            "class"      => "",
                            'group' => ''
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Icon color',
                            "param_name" => "icon_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Icon hover color',
                            "param_name" => "icon_color_h",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => '',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Favorites count text color',
                            "param_name" => "count_txt_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Favorites coun background color',
                            "param_name" => "count_bg_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => '',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Additional text color',
                            "param_name" => "add_txt_color",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Additional text hover color',
                            "param_name" => "add_txt_color_h",
                            "value" => '',
                            "description" => '',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => '',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_count', true, 'Favorites count text' ),
                    td_config_helper::get_map_block_font_array( 'f_add', false, 'Additional text' ),
                    self::get_block_style()
                )
            )
        );

        /* td woo products archive shortcodes */
		td_api_block::add( 'td_woo_archive_subcategories_list',
			array(
				'map_in_td_composer' => true,
				"name" => 'Woo Archive Sucategories List',
				"base" => "td_woo_archive_subcategories_list",
				'tdc_category' => 'WooCommerce Archive',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_archive_subcategories_list.php',
				'tdc_style_params' => array(
					'custom_title',
					'el_class'
				),
                'tdc_start_values' => base64_encode(
                    json_encode(
                        array(
                            array(
                                "columns" => "25%",
                                "name_pos" => "bellow",
                                "descr_pos" => "bellow",
                            )
                        )
                    )
                ),
				"params" => array_merge(
					array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Header settings',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "custom_title",
                            "type" => "textfield",
                            "value" => "",
                            "heading" => 'Custom title:',
                            "description" => "Optional - a title for this block, if you leave it blank the block will not have a title",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig",
                        ),
                        array(
                            "param_name" => "block_template_id",
                            "type" => "dropdown",
                            "value" => td_util::get_block_template_ids(),
                            "heading" => 'Header template:',
                            "description" => "Header template used by the current block",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big"
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Layout',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name"  => "columns",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                '1'  => '100%',
                                '2'  => '50%',
                                '3'  => '33.33333333%',
                                '4'  => '25%',
                                '5'  => '20%',
                                '6'  => '16.66666667%',
                                '7'  => '14.28571428%',
                                '8'  => '12.5%',
                                '9'  => '11.11111111%',
                                '10' => '10%',
                            ),
                            "heading"     => 'Columns',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-small",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "gap",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Columns gap',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "30",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Categories space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "30",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Category image',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "",
                        ),
                        array(
                            "param_name"  => "img_height",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Height',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "60%",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "img_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "show_img",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show image',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Top info',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "",
                        ),
                        array(
                            "param_name"  => "info_margin1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "info_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "info_border1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "info_border_style1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Solid'  => '',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "info_horiz1",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Bottom info',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "",
                        ),
                        array(
                            "param_name"  => "info_margin2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "17px 0px 0px 0px",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "info_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "info_border2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "info_border_style2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Solid'  => '',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "info_horiz2",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Name',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "",
                        ),
                        array(
                            "param_name"  => "name_pos",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Above image'  => 'above',
                                'Bellow image'  => 'bellow',
                            ),
                            "heading"     => 'Position',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "name_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 8px 0px",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Description',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "",
                        ),
                        array(
                            "param_name"  => "descr_pos",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Above image'  => 'above',
                                'Bellow image'  => 'bellow',
                            ),
                            "heading"     => 'Position',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "descr_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "show_descr",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show description',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "",
                        ),

                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category background color',
                            "param_name"  => "bg_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Category image',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "gradient",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Overlay color',
                            "param_name"  => "img_overlay",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "gradient",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Overlay hover color',
                            "param_name"  => "img_overlay_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Category info',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Top info background color',
                            "param_name"  => "info_bg_color1",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Top info border color',
                            "param_name"  => "info_border_color1",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Bottom info background color',
                            "param_name"  => "info_bg_color2",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Bottom info border color',
                            "param_name"  => "info_border_color2",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Name color',
                            "param_name"  => "name_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Nme hover color',
                            "param_name"  => "name_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Description color',
                            "param_name"  => "descr_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Fonts',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Style",
                        ),
					),
                    td_config_helper::get_map_block_font_array( 'f_header', true, 'Block header', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_name', false, 'Name text', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_descr', false, 'Description text', 'Style' ),
					self::get_block_style()
				)
			)
		);

		/* td woo products search archive shortcodes */

		/* td woocommerce shortcodes */
		td_api_block::add( 'td_woo_checkout',
			array(
				'map_in_td_composer' => true,
				'base' => 'td_woo_checkout',
				'name' => 'Woo Checkout',
				'icon' => '',
				'category' => 'Content',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_checkout.php',
				'tdc_category' => 'External',
				'tdc_style_params' => array(
					'el_class'
				),
				'params' => array_merge(
					array(
                        array(
                            "param_name" => "show_page",
                            "type" => "dropdown",
                            "value" => array (
                                'Order placement page' => '',
                                'Checkout confirmation page' => 'confirmation',
                            ),
                            "heading" => 'Show in composer',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            'group' => ''
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Titles',
                            "value"      => "",
                            "class"      => "tdc-separator",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Titles text color',
                            "param_name"  => "title_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_title', true, 'Titles text'),
                    array(

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Billing details',
                            "value"      => "",
                            "class"      => "tdc-separator",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Background color',
                            "param_name"  => "bill_bg_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Form',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Labels text color',
                            "param_name"  => "label_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Inputs text color',
                            "param_name"  => "input_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Inputs focus text color',
                            "param_name"  => "input_color_f",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Inputs placeholder color',
                            "param_name"  => "input_place_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Inputs background color',
                            "param_name"  => "input_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Inputs focus background color',
                            "param_name"  => "input_bg_f",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Inputs border color',
                            "param_name"  => "input_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Inputs focus border color',
                            "param_name"  => "input_border_color_f",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "input_border_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Inputs border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_label', true, 'Form labels text'),
                    td_config_helper::get_map_block_font_array( 'f_input', false, 'Form inputs text'),
                    array(

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Order review',
                            "value"      => "",
                            "class"      => "tdc-separator",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Coupon notice',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Text color',
                            "param_name"  => "coupon_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Background color',
                            "param_name"  => "coupon_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Products table',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Header text color',
                            "param_name"  => "prod_head_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Body text color',
                            "param_name"  => "prod_body_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Footer text color',
                            "param_name"  => "prod_foot_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Borders color',
                            "param_name"  => "prod_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Payment options',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Option name color',
                            "param_name"  => "pay_name_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Option description color',
                            "param_name"  => "pay_descr_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Option description background color',
                            "param_name"  => "pay_descr_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Option description border color',
                            "param_name"  => "pay_descr_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "pay_descr_border_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Options description border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "2",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Agreement text color',
                            "param_name"  => "pay_agree_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Borders color',
                            "param_name"  => "pay_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Button text color',
                            "param_name"  => "pay_btn_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Button hover text color',
                            "param_name"  => "pay_btn_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Button background color',
                            "param_name"  => "pay_btn_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Button hover background color',
                            "param_name"  => "pay_btn_bg_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Button border color',
                            "param_name"  => "pay_btn_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Button hover border color',
                            "param_name"  => "pay_btn_border_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "pay_btn_border_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Button border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "3",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_coupon', true, 'Coupon notice text'),
                    td_config_helper::get_map_block_font_array( 'f_prod_head', false, 'Products table header text'),
                    td_config_helper::get_map_block_font_array( 'f_prod_body', false, 'Products table body text'),
                    td_config_helper::get_map_block_font_array( 'f_prod_foot', false, 'Products table footer text'),
                    td_config_helper::get_map_block_font_array( 'f_pay_name', false, 'Payment option name text'),
                    td_config_helper::get_map_block_font_array( 'f_pay_descr', false, 'Payment option descr. text'),
                    td_config_helper::get_map_block_font_array( 'f_pay_agree', false, 'Agreement text'),
                    td_config_helper::get_map_block_font_array( 'f_pay_btn', false, 'Button text'),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'General',
                            "value"      => "",
                            "class"      => "tdc-separator",
                            "group"      => "Confirmation"
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Titles text color',
                            "param_name"  => "c_title_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Confirmation",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Thank you message text color',
                            "param_name"  => "c_thx_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Confirmation",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Confirmation',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_c_title', true, 'Titles text', 'Confirmation' ),
                    td_config_helper::get_map_block_font_array( 'f_c_thx', false, 'Thank you message text', 'Confirmation' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Order overview table',
                            "value"      => "",
                            "class"      => "tdc-separator",
                            "group"      => "Confirmation"
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Text color',
                            "param_name"  => "c_over_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Confirmation",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Borders color',
                            "param_name"  => "c_over_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Confirmation",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Confirmation',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_c_over', true, 'Table text', 'Confirmation' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Bank details',
                            "value"      => "",
                            "class"      => "tdc-separator",
                            "group"      => "Confirmation"
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Title color',
                            "param_name"  => "c_bank_title_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Confirmation",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Table',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Confirmation"
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Text color',
                            "param_name"  => "c_bank_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Confirmation",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Borders color',
                            "param_name"  => "c_bank_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Confirmation",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Confirmation',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_c_bank_title', true, 'Title text', 'Confirmation' ),
                    td_config_helper::get_map_block_font_array( 'f_c_bank', false, 'Table text', 'Confirmation' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Order details table',
                            "value"      => "",
                            "class"      => "tdc-separator",
                            "group"      => "Confirmation"
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Text color',
                            "param_name"  => "c_det_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Confirmation",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Links color',
                            "param_name"  => "c_det_a_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Confirmation",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Background color',
                            "param_name"  => "c_det_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Confirmation",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Borders color',
                            "param_name"  => "c_det_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Confirmation",
                        ),
                        array(
                            "param_name"  => "c_det_border_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "5",
                            "group"       => "Confirmation",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Confirmation',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_c_det', true, 'Table text', 'Confirmation' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Billing address section',
                            "value"      => "",
                            "class"      => "tdc-separator",
                            "group"      => "Confirmation"
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Text color',
                            "param_name"  => "c_add_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Confirmation",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Background color',
                            "param_name"  => "c_add_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Confirmation",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Borders color',
                            "param_name"  => "c_add_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Confirmation",
                        ),
                        array(
                            "param_name"  => "c_add_border_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "5",
                            "group"       => "Confirmation",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Confirmation',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_c_add', true, 'Section text', 'Confirmation' ),

					self::get_block_style()
				),
			)
		);

		td_api_block::add( 'td_woo_cart',
			array(
				'map_in_td_composer' => true,
				'base' => 'td_woo_cart',
				'name' => 'Woo Cart',
				'icon' => '',
				'category' => 'Content',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_cart.php',
				'tdc_category' => 'External',
				'tdc_style_params' => array(
					'el_class'
				),
				'params' => array_merge(
					array(
                        array(
                            "param_name" => "show_page",
                            "type" => "dropdown",
                            "value" => array (
                                'Cart with products' => '',
                                'Empty cart' => 'empty',
                            ),
                            "heading" => 'Show in composer',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            'group' => ''
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Products table',
                            "value"      => "",
                            "class"      => "tdc-separator",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Table header text color',
                            "param_name"  => "prod_head_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_prod_head', true, 'Table header text'),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Product row',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Product title color',
                            "param_name"  => "prod_title_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Product hover title color',
                            "param_name"  => "prod_title_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Price & subtotal color',
                            "param_name"  => "prod_price_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Quantity text color',
                            "param_name"  => "prod_qty_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Quantity focus text color',
                            "param_name"  => "prod_qty_color_f",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Quantity background color',
                            "param_name"  => "prod_qty_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Quantity focus background color',
                            "param_name"  => "prod_qty_bg_f",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Quantity border color',
                            "param_name"  => "prod_qty_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Quantity focus border color',
                            "param_name"  => "prod_qty_border_color_f",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "prod_qty_border_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Ouantity focus border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Remove button text color',
                            "param_name"  => "prod_del_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Remove button hover text color',
                            "param_name"  => "prod_del_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Remove button background color',
                            "param_name"  => "prod_del_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Remove button hover background color',
                            "param_name"  => "prod_del_bg_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "prod_del_border_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Remove button border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_prod_title', true, 'Product title text'),
                    td_config_helper::get_map_block_font_array( 'f_prod_price', false, 'Price & subtotal text'),
                    td_config_helper::get_map_block_font_array( 'f_qty', false, 'Quantity text'),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Coupon code area',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Background color',
                            "param_name"  => "coup_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Input text color',
                            "param_name"  => "coup_input_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Input focus text color',
                            "param_name"  => "coup_input_color_f",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Input placeholder color',
                            "param_name"  => "coup_input_place",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Input background color',
                            "param_name"  => "coup_input_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Input focus background color',
                            "param_name"  => "coup_input_bg_f",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Input border color',
                            "param_name"  => "coup_input_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Input focus border color',
                            "param_name"  => "coup_input_border_color_f",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "coup_input_border_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Input border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Buttons text color',
                            "param_name"  => "coup_btn_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Buttons hover text color',
                            "param_name"  => "coup_btn_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Buttons background color',
                            "param_name"  => "coup_btn_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Buttons hover background color',
                            "param_name"  => "coup_btn_bg_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Buttons border color',
                            "param_name"  => "coup_btn_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Buttons hover border color',
                            "param_name"  => "coup_btn_border_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "coup_btn_border_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Buttons border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "3",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_coup', true, 'Input text'),
                    td_config_helper::get_map_block_font_array( 'f_coup_btn', false, 'Buttons text'),

					array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Cart totals',
                            "value"      => "",
                            "class"      => "tdc-separator",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Background color',
                            "param_name"  => "total_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Title color',
                            "param_name"  => "total_title_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_total_title', true, 'Title text'),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Breakdown table',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Labels text color',
                            "param_name"  => "break_label_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Values text color',
                            "param_name"  => "break_val_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Borders color',
                            "param_name"  => "break_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_break_label', true, 'Labels text'),
                    td_config_helper::get_map_block_font_array( 'f_break_val', false, 'Values text'),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Checkout button',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Text color',
                            "param_name"  => "check_btn_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Hover text color',
                            "param_name"  => "check_btn_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Background color',
                            "param_name"  => "check_btn_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Hover background color',
                            "param_name"  => "check_btn_bg_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Border color',
                            "param_name"  => "check_btn_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Hover border color',
                            "param_name"  => "check_btn_border_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "check_btn_border_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "3",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_check_btn', true, 'Button text' ),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Notices',
                            "value"      => "",
                            "class"      => "",
                            "group"       => "Empty cart",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Text color',
                            "param_name"  => "notice_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Empty cart",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Links color',
                            "param_name"  => "notice_color_a",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Empty cart",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Background color',
                            "param_name"  => "notice_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Empty cart",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Info border color',
                            "param_name"  => "notice_info_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Empty cart",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Success border color',
                            "param_name"  => "notice_succ_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Empty cart",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_notice', true, 'Notice text', 'Empty cart'),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Button',
                            "value"      => "",
                            "class"      => "",
                            "group"       => "Empty cart",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Text color',
                            "param_name"  => "empty_btn_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Empty cart",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Hover text color',
                            "param_name"  => "empty_btn_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Empty cart",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Background color',
                            "param_name"  => "empty_btn_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Empty cart",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Hover background color',
                            "param_name"  => "empty_btn_bg_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Empty cart",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Border color',
                            "param_name"  => "empty_btn_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Empty cart",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Hover border color',
                            "param_name"  => "empty_btn_border_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Empty cart",
                        ),
                        array(
                            "param_name"  => "empty_btn_border_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "3",
                            "group"       => "Empty cart",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Empty cart',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_empty_btn', true, 'Button text', 'Empty cart'),
					self::get_block_style()
				),
			)
		);

		td_api_block::add( 'td_woo_my_account',
			array(
				'map_in_td_composer' => true,
				'base' => 'td_woo_my_account',
				'name' => 'Woo My Account',
				'icon' => '',
				'category' => 'Content',
				'file' => TD_WOO_DIR . '/shortcodes/td_woo_my_account.php',
				'tdc_category' => 'External',
				'tdc_style_params' => array(
					'el_class'
				),
				'params' => array_merge(
					array(
                        array(
                            "param_name" => "show_page",
                            "type" => "dropdown",
                            "value" => array (
                                'Dashboard' => '',
                                'Orders history' => 'orders',
                                'Order details' => 'order',
                                'Downloads' => 'downloads',
                                'Addresses' => 'addresses',
                                'Edit address' => 'address',
                                'Account details' => 'acc_details',
                                'Guest' => 'guest',
                            ),
                            "heading" => 'Show in composer',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            'group' => ''
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'General',
                            "value"      => "",
                            "class"      => "tdc-separator",
                            'group'      => ''
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Texts color',
                            "param_name"  => "texts_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_texts', true, 'Texts'),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Forms',
                            "value"      => "",
                            "class"      => "tdc-separator",
                            'group'      => ''
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Labels text color',
                            "param_name"  => "label_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Inputs text color',
                            "param_name"  => "input_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Inputs focus text color',
                            "param_name"  => "input_color_f",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Inputs placeholder color',
                            "param_name"  => "input_place_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Inputs help color',
                            "param_name"  => "input_help_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Inputs background color',
                            "param_name"  => "input_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Inputs focus background color',
                            "param_name"  => "input_bg_f",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Inputs border color',
                            "param_name"  => "input_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Inputs focus border color',
                            "param_name"  => "input_border_color_f",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "input_border_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Inputs border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Extra text color',
                            "param_name"  => "form_ex_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Links color',
                            "param_name"  => "form_a_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Links hover color',
                            "param_name"  => "form_a_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Buttons text color',
                            "param_name"  => "btn_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Buttons hover text color',
                            "param_name"  => "btn_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Buttons background color',
                            "param_name"  => "btn_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Buttons hover background color',
                            "param_name"  => "btn_bg_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Buttons border color',
                            "param_name"  => "btn_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Buttons hover border color',
                            "param_name"  => "btn_border_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "param_name"  => "btn_border_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Buttons border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "3",
                            "group"       => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_label', true, 'Labels text'),
                    td_config_helper::get_map_block_font_array( 'f_input', false, 'Inputs text'),
                    td_config_helper::get_map_block_font_array( 'f_help', false, 'Inputs help text'),
                    td_config_helper::get_map_block_font_array( 'f_f_extra', false, 'Form extra text' ),
                    td_config_helper::get_map_block_font_array( 'f_btn', false, 'Buttons text'),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'General',
                            "value"      => "",
                            "class"      => "tdc-separator",
                            'group'      => 'Logged in'
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Tables',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            'group'      => 'Logged in'
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Table header text color',
                            "param_name"  => "table_head_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Logged in",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Table body text color',
                            "param_name"  => "table_body_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Logged in",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Table footer text color',
                            "param_name"  => "table_foot_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Logged in",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Logged in',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Background color',
                            "param_name"  => "table_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Logged in",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Borders color',
                            "param_name"  => "table_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Logged in",
                        ),
                        array(
                            "param_name"  => "table_border_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "5",
                            "group"       => "Logged in",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Logged in',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Buttons text color',
                            "param_name"  => "table_btn_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Logged in",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Buttons hover text color',
                            "param_name"  => "table_btn_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Logged in",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Buttons background color',
                            "param_name"  => "table_btn_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Logged in",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Buttons hover background color',
                            "param_name"  => "table_btn_bg_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Logged in",
                        ),
                        array(
                            "param_name"  => "table_btn_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Buttons border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "3",
                            "group"       => "Logged in",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Logged in',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_t_head', true, 'Table header text', 'Logged in' ),
                    td_config_helper::get_map_block_font_array( 'f_t_body', false, 'Table body text', 'Logged in' ),
                    td_config_helper::get_map_block_font_array( 'f_t_foot', false, 'Table footer text', 'Logged in' ),
                    td_config_helper::get_map_block_font_array( 'f_t_btn', false, 'Table buttons', 'Logged in' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Navigation',
                            "value"      => "",
                            "class"      => "tdc-separator",
                            'group'      => 'Logged in'
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Background color',
                            "param_name"  => "nav_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Logged in",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-a",
                            "heading"     => 'Links color',
                            "param_name"  => "nav_a_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Logged in",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "tdc-colorpicker-double-b",
                            "heading"     => 'Links hover & active color',
                            "param_name"  => "nav_a_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Logged in",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Logged in',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_nav', true, 'Table text', 'Logged in' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Dashboard',
                            "value"      => "",
                            "class"      => "tdc-separator",
                            'group'      => 'Logged in'
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Text color',
                            "param_name"  => "dash_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Logged in",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Logged in',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_dash', true, 'Text', 'Logged in' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Order details',
                            "value"      => "",
                            "class"      => "tdc-separator",
                            'group'      => 'Logged in'
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Titles color',
                            "param_name"  => "order_titles_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Logged in",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Logged in',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_order_title', true, 'Titles text', 'Logged in' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Addresses',
                            "value"      => "",
                            "class"      => "tdc-separator",
                            'group'      => 'Logged in'
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Titles color',
                            "param_name"  => "add_title_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Logged in",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Address text color',
                            "param_name"  => "add_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Logged in",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Logged in',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_add_title', true, 'Titles text', 'Logged in' ),
                    td_config_helper::get_map_block_font_array( 'f_add', false, 'Address text', 'Logged in' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Account details',
                            "value"      => "",
                            "class"      => "tdc-separator",
                            'group'      => 'Logged in'
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Password change box',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            'group'      => 'Logged in'
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Title color',
                            "param_name"  => "pass_title_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Logged in",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Box background color',
                            "param_name"  => "pass_box_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Logged in",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Box border color',
                            "param_name"  => "pass_box_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Logged in",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Logged in',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_pass_title', true, 'Titles text', 'Logged in' ),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'General',
                            "value"      => "",
                            "class"      => "tdc-separator",
                            'group'      => 'Guest'
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Titles color',
                            "param_name"  => "g_title_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Guest",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Guest',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_g_title', true, 'Titles text', 'Guest' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Boxes',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            'group'      => 'Guest'
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Background color',
                            "param_name"  => "g_box_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Guest",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Border color',
                            "param_name"  => "g_box_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Guest",
                        ),
                        array(
                            "param_name"  => "g_box_border_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "Guest",
                        ),
					),
					self::get_block_style()
				),
			)
		);

		/* woo products block */
		td_api_block::add( 'td_woo_products_block',
			array(
				'map_in_td_composer'     => true,
				"name"                   => 'Woo Product Block',
				"base"                   => 'td_woo_products_block',
				"category"               => 'Blocks',
				'tdc_category'           => 'Blocks',
				'file'                   => TD_WOO_DIR . '/shortcodes/td_woo_products_block.php',
				'tdc_style_params' => array(
					'custom_title',
					'custom_url',
					'products_ids',
					'product_cat',
					'product_categories_ids',
					'product_tag_slug',
					'sort',
					'td_ajax_filter_type',
					'td_ajax_filter_ids',
					'td_filter_default_txt',
					'td_ajax_preloading',
					'ajax_pagination',
					'ajax_pagination_infinite_stop',
					'single_product_page_filter',
					'limit',
					'offset',
					'el_class'
				),
				'tdc_start_values' => base64_encode(
					json_encode(
						array(
							array(
								"modules_on_row" => "33.33333333%",
							),
						)
					)
				),
				"params" => array_merge(
					td_config::get_map_block_general_array(),
                    array(
                        array(
                            "param_name" => "title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H4' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H3' => 'h3',
                                'Div' => 'div'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                            ),
                    ),

					self::get_map_filter_array(),
					self::get_map_block_ajax_filter_array(),
					array (
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Extra',
							"value"      => "",
							"class"      => "",
							'group' => 'Filter'
						),
						array(
							"param_name" => "ajax_pagination",
							"type" => "dropdown",
							"value" => array('- No pagination -' => '', 'Next Prev ajax' => 'next_prev', 'Load More button' => 'load_more', 'Infinite load' => 'infinite'),
							"heading" => 'Pagination:',
							"description" => "Our blocks support pagination.",
							"holder" => "div",
							"class" => "tdc-dropdown-big",
							'group' => 'Filter'
						),
						array(
							"param_name" => "ajax_pagination_infinite_stop",
							"type" => "textfield",
							"value" => '',
							"heading" => "Infinite load show 'Load more' after x pages:",
							"description" => "ONLY FOR INFINITE LOAD pagination: Shows 'load more' button after x number of pages. Leave this blank to load posts forever when infinite load is set for ajax pagination",
							"holder" => "div",
							"class" => "tdc-textfield-big",
							'group' => 'Filter'
						),
						array(
							"param_name" => "single_product_page_filter",
							"type" => "dropdown",
							"value" => array (
								'- Default -' => '',
								'Upsells' => 'upsells',
								'Related Categories & Tags' => 'related',
								'Related Categories' => 'related_categories',
								'Related Tags' => 'related_tags',
							),
							"heading" => 'Single Products Page Filter:',
							"description" => "You can set this filter to display product upsells or related products on single product pages. 
Please note that this filter type only works on single post templates.",
							"holder" => "div",
							"class" => "tdc-dropdown-big",
							'group' => 'Filter'
						),
						array(
							"param_name"  => "modules_on_row",
							"type"        => "dropdown-responsive",
							"value"       => array(
								'1'  => '100%',
								'2'  => '50%',
								'3'  => '33.33333333%',
								'4'  => '25%',
								'5'  => '20%',
								'6'  => '16.66666667%',
								'7'  => '14.28571428%',
								'8'  => '12.5%',
								'9'  => '11.11111111%',
								'10' => '10%',
							),
							"heading"     => 'Modules per row',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-dropdown-small",
							"group"       => "Layout",
						),
						array(
							"param_name"  => "gap",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Products gap',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "30",
							"group"       => "Layout",
						),
						array(
							"param_name"  => "all_space",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Products bottom space',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "40",
							"group"       => "Layout",
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Product image',
							"value"      => "",
							"class"      => "",
							"group"       => "Layout",
						),
                        array(
                            "param_name"  => "img_size",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Medium - Default - 696x0px'  => '',
                                '-- [No crop] --' => '__',
                                'XSmall - 150x0px' => 'td_150x0',
                                'Small - 300x0px' => 'td_300x0',
                                'Large - 1068x0px' => 'td_1068x0',
                                'Full - 1920x0px'  => 'td_1920x0',
                                '-- [Other sizes] --' => '__',
                                '218x150px' => 'td_218x150',
                                '324x400px'  => 'td_324x400',
                                '485x360' => 'td_485x360'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name"  => "img_width",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (0-100 percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name"  => "img_height",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            'param_name'  => 'img_alignment',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "img_pos",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Normal'      => 'normal',
                                'Float left'  => 'left',
                                'Float right' => 'right',
                                'Hidden'      => 'hidden',
                            ),
                            "heading"     => 'Image position',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
						array(
							"param_name"  => "img_space",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Image bottom margin',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "14",
							"group"       => "Layout",
						),
                        array(
                            "param_name"  => "img_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name"  => "hide_image",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Hide image",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout',
                            "info_img"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Sale tag',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "sale_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Sale tag margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                        ),
						array(
							"param_name"  => "sale_padding",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Sale tag padding',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-big",
							"placeholder" => "10",
							"group"       => "Layout",
						),
                        array(
                            "param_name"  => "sale_border",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Sale tag border size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "sale_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => 'solid',
                                'Dashed' => 'dashed',
                                'Dotted' => 'dotted',
                                'Double' => 'double',
                            ),
                            "heading" => 'Sale tag border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Layout",
                        ),
                        array(
                            "param_name"  => "sale_radius",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Sale tag border radius',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Favorite button',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "show_favourites",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => 'Show button',
                            "description" => "",
                            "holder" => "div",
                            "group"       => "Layout",
                        ),
                        array(
                            'param_name'  => 'fav_size',
                            'type'        => 'range-responsive',
                            'value'       => '2',
                            'heading'     => 'Button size',
                            'description' => '',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '1',
                            'range_max'   => '4',
                            'range_step'  => '1',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "fav_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Button space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "10",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Meta info',
							"value"      => "",
							"class"      => "",
							"group"       => "Layout",
						),
                        array(
                            "param_name"  => "meta_info_align",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Top'     => 'initial',
                                'Center'  => 'center',
                                'Bottom'  => 'flex-end',
                            ),
                            "heading"     => 'Vertical align',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "horiz_align",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "meta_width",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "meta_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name"  => "meta_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name"  => "meta_info_border_size",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Border width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name"  => "meta_info_border_style",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Solid'  => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading"     => 'Border style',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Title',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
						array(
							"param_name"  => "title_space",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Title bottom margin',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "5",
							"group"       => "Layout",
						),
                        array(
                            "param_name" => "product_title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Paragraph' => 'p'
                            ),
                            "heading" => 'Product title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Product description',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_excerpt",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Hide' => 'none',
                                'Show' => 'block',
                            ),
                            "heading"     => 'Show description',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_show_excerpt.png",
                        ),
                        array(
                            "param_name"  => "excerpt_type",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Short description' => '',
                                'Long description' => 'long',
                            ),
                            "heading"     => 'Product description type',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_show_excerpt.png",
                        ),
                        array(
                            "param_name"  => "excerpt_space",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Product excerpt space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "20px 0px 0px 0px",
                            "group"       => "Layout",
                            "info_img" => "https://cloud.tagdiv.com/help/module_excerpt_space.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Review stars',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
						array(
							"param_name"  => "show_stars",
							"type"        => "dropdown-responsive",
							"value"       => array(
								'Show' => 'inline-block',
								'Hide' => 'none',
							),
							"heading"     => 'Show review stars',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-dropdown-big",
							"group"       => "Layout",
						),
						array(
							"param_name"  => "stars_size",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Review stars size',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "12",
							"group"       => "Layout",
						),
						array(
							"param_name"  => "stars_space",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Review stars bottom margin',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "6",
							"group"       => "Layout",
						),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Price',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Layout",
                        ),
						array(
							"param_name"  => "price_space",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Price bottom margin',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "18",
							"group"       => "Layout",
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Button',
							"value"      => "",
							"class"      => "",
							"group"       => "Layout",
						),
						array(
							"param_name"  => "btn_padding",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Padding',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-big",
							"placeholder" => "10px 10px 10px 10px",
							"group"       => "Layout",
						),
						array(
							"param_name"  => "btn_border",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Border size',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-big",
							"placeholder" => "0",
							"group"       => "Layout",
						),
						array(
							"param_name"  => "btn_border_style",
							"type"        => "dropdown-responsive",
							"value"       => array(
								'Solid'  => 'solid',
								'Dotted' => 'dotted',
								'Dashed' => 'dashed',
							),
							"heading"     => 'Border style',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-dropdown-big",
							"group"       => "Layout",
						),
						array(
							"param_name"  => "btn_radius",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Button radius',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-big",
							"placeholder" => "0",
							"group"       => "Layout",
						),
						array(
							"param_name"  => "show_btn",
							"type"        => "dropdown-responsive",
							"value"       => array(
								'Show' => 'inline-block',
								'Hide' => 'none',
							),
							"heading"     => 'Show button',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-dropdown-big",
							"group"       => "Layout",
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Pagination',
							"value"      => "",
							"class"      => "",
							"group"       => 'Layout'
						),
						array(
							"param_name" => "pag_space",
							"type" => "textfield",
							"value" => '',
							"heading" => 'Top space',
							"description" => "",
							"placeholder" => "40",
							"holder" => "div",
							"class" => "tdc-textfield-small",
							'group'      => 'Layout',
						),
						array(
							"param_name"  => "pag_padding",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Padding',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-big",
							"placeholder" => "",
							"group"       => "Layout",
						),
						array(
							"param_name"  => "pag_border_width",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Border width',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "1",
							"group"       => "Layout",
						),
						array(
							"param_name"  => "pag_border_radius",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Border radius',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "0",
							"group"       => "Layout",
						),
						array(
							"param_name" => "separator",
							"type" => "horizontal_separator",
							"value" => "",
							"class" => "tdc-separator-small",
							"group" => 'Layout',
						),
						array(
							'param_name' => 'prev_tdicon',
							'type' => 'icon',
							'heading' => 'Prev icon',
							'class' => 'tdc-textfield-small',
							'value' => '',
							"group"       => 'Layout'
						),
						array(
							'param_name' => 'next_tdicon',
							'type' => 'icon',
							'heading' => 'Next icon',
							'class' => 'tdc-textfield-small',
							'value' => '',
							"group"       => 'Layout'
						),
						array(
							"param_name"  => "pag_icons_size",
							"type"        => "textfield-responsive",
							"value"       => '',
							"heading"     => 'Icons size',
							"description" => "",
							"holder"      => "div",
							"class"       => "tdc-textfield-small",
							"placeholder" => "",
							"group"       => "Layout",
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Sale tag',
							"value"      => "",
							"class"      => "",
							"group"       => "Style",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-a",
							"heading"     => 'Text color',
							"param_name"  => "sale_txt_color",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-b",
							"heading"     => 'Text hover color',
							"param_name"  => "sale_txt_color_h",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-a",
							"heading"     => 'Background color',
							"param_name"  => "sale_bg_color",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-b",
							"heading"     => 'Background hover color',
							"param_name"  => "sale_bg_color_h",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Border color',
                            "param_name"  => "sale_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Border hover color',
                            "param_name"  => "sale_border_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Favorite button',
                            "value"      => "",
                            "class"      => "",
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Icon color',
                            "param_name"  => "fav_ico_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Icon hover/added color',
                            "param_name"  => "fav_ico_color_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-a",
                            "heading"     => 'Background color',
                            "param_name"  => "fav_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "td-colorpicker-double-b",
                            "heading"     => 'Background hover/added color',
                            "param_name"  => "fav_bg_h",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                    ),
                    td_config_helper::get_map_block_shadow_array('fav_shadow', 'Shadow', 4, 1, 1, 'Style'),
                    array(
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Meta info',
							"value"      => "",
							"class"      => "",
							"group"       => "Style",
						),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Background color',
                            "param_name"  => "meta_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Border color',
                            "param_name"  => "meta_border_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Title',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Style",
                        ),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-a",
							"heading"     => 'Title color',
							"param_name"  => "title_color",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-b",
							"heading"     => 'Title hover color',
							"param_name"  => "title_color_h",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Product description',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Product description color',
                            "param_name"  => "ex_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_excerpt.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Review stars',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Style",
                        ),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "",
							"heading"     => 'Full stars color',
							"param_name"  => "stars_full_color",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "",
							"heading"     => 'Empty stars color',
							"param_name"  => "stars_empty_color",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Price',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"       => "Style",
                        ),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "",
							"heading"     => 'Price color',
							"param_name"  => "price_color",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Sale price color',
                            "param_name"  => "sale_price_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "Style",
                        ),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "",
							"heading"     => 'Old price color',
							"param_name"  => "old_price_color",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Button',
							"value"      => "",
							"class"      => "tdc-separator-small",
							"group"       => "Style",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-a",
							"heading"     => 'Text color',
							"param_name"  => "btn_txt_color",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-b",
							"heading"     => 'Text hover color',
							"param_name"  => "btn_txt_color_h",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-a",
							"heading"     => 'Background color',
							"param_name"  => "btn_bg_color",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-b",
							"heading"     => 'Background hover color',
							"param_name"  => "btn_bg_color_h",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-a",
							"heading"     => 'Border color',
							"param_name"  => "btn_border_color",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-b",
							"heading"     => 'Border hover color',
							"param_name"  => "btn_border_color_h",
							"value"       => '',
							"description" => '',
							"group"       => "Style",
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Pagination',
							"value"      => "",
							"class"      => "",
							"group"       => 'Style',
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-a",
							"heading"     => 'Text color',
							"param_name"  => "pag_text",
							"value"       => '',
							"description" => '',
							"group"       => 'Style',
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-b",
							"heading"     => 'Text hover color',
							"param_name"  => "pag_h_text",
							"value"       => '',
							"description" => '',
							"group"       => 'Style',
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-a",
							"heading"     => 'Background color',
							"param_name"  => "pag_bg",
							"value"       => '',
							"description" => '',
							"group"       => 'Style',
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-b",
							"heading"     => 'Background hover color',
							"param_name"  => "pag_h_bg",
							"value"       => '',
							"description" => '',
							"group"       => 'Style',
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-a",
							"heading"     => 'Border color',
							"param_name"  => "pag_border",
							"value"       => '',
							"description" => '',
							"group"       => 'Style',
						),
						array(
							"type"        => "colorpicker",
							"holder"      => "div",
							"class"       => "td-colorpicker-double-b",
							"heading"     => 'Border hover color',
							"param_name"  => "pag_h_border",
							"value"       => '',
							"description" => '',
							"group"       => 'Style',
						),
						array(
							"param_name" => "separator",
							"type"       => "text_separator",
							'heading'    => 'Fonts',
							"value"      => "",
							"class"      => "",
							"group"       => "Style",
						),
					),
					td_config_helper::get_map_block_font_array( 'f_header', true, 'Block title text', 'Style'),
					td_config_helper::get_map_block_font_array( 'f_ajax', false, 'Ajax categories', 'Style' ),
					td_config_helper::get_map_block_font_array( 'f_sale', false, 'Sale tag text', 'Style'),
					td_config_helper::get_map_block_font_array( 'f_title', false, 'Title text', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_ex', false, 'Product description', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_price', false, 'Price text', 'Style'),
					td_config_helper::get_map_block_font_array( 'f_old_price', false, 'Old price text', 'Style'),
					td_config_helper::get_map_block_font_array( 'f_btn', false, 'Button text', 'Style'),
					td_config_helper::get_map_block_font_array( 'f_more', false, 'Pagination text', 'Style'),

					array(
						array (
							'param_name' => 'css',
							'value' => '',
							'type' => 'css_editor',
							'heading' => 'Css',
							'group' => 'Design options',
						),
						array (
							'param_name' => 'tdc_css',
							'value' => '',
							'type' => 'tdc_css_editor',
							'heading' => '',
							'group' => 'Design options',
						),
					)
				)
			)
		);

        td_api_block::add( 'td_woo_product_favourite',
            array(
                'map_in_td_composer' => true,
                "name" => 'Woo Product Favorite',
                "base" => "td_woo_product_favourite",
                'tdc_category' => 'WooCommerce Single',
                'file' => TD_WOO_DIR . '/shortcodes/td_woo_product_favourite.php',
                'tdc_style_params' => array(
                    'tdicon',
                    'tdicon_added',
                    'tds_w_favorite',
                    'tds_w_favorite2-text_init',
                    'tds_w_favorite2-text_init',
                    'el_class'
                ),
                'tdc_start_values' => base64_encode(
                    json_encode(
                        array(
                            array(
                                "tdicon" => "td-icon-heart-empty",
                                "tdicon_added" => "td-icon-heart-full",
                                "tds_w_favorite2-btn_horiz_align" => "content-horiz-center",
                                "tds_w_favorite2-text_init" => "Add to favorites",
                                "tds_w_favorite2-text_init" => "Added to favorites",
                            ),
                        )
                    )
                ),
                'params' => array_merge(
                    array(
                        array(
                            'param_name' => 'tdicon',
                            'type' => 'icon',
                            'heading' => 'Initial icon',
                            'class' => 'tdc-textfield-small',
                            'value' => '',
                        ),
                        array(
                            'param_name' => 'tdicon_added',
                            'type' => 'icon',
                            'heading' => 'Hover/added icon',
                            'class' => 'tdc-textfield-small',
                            'value' => '',
                        ),
                        array(
                            "param_name" => "make_inline",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Show inline",
                            "description" => "",
                            "holder" => "div",
                            "class" => ""
                        ),
                        array(
                            "param_name" => "horiz_align",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            "param_name" => "tds_w_favorite",
                            "type" => "dropdown",
                            "value" => td_api_style::get_styles_for_mapping( 'tds_w_favorite', false ),
                            "heading" => 'Style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-extrabig",
                            "group" => "General",
                        ),
                    ),
                    self::get_block_style()
                ),
            )

        );

		/* woo products module */
		td_api_module::add( 'td_woo_product_module',
			array(
				'file'                         => TD_WOO_DIR . '/modules/td_woo_product_module.php',
				'text'                         => 'Product Module',
				'img'                          => '',
				'used_on_blocks'               => array( 'td_woo_products_block' ),
				'excerpt_title'                => 25,
				'excerpt_content'              => 25,
				'enabled_excerpt_in_panel'     => false,
				'enabled_on_more_articles_box' => false,
				'enabled_on_loops'             => false,
				'uses_columns'                 => false,
				// if the module uses columns on the page template + loop
				'category_label'               => false,
				'class'                        => 'td_module_wrap td-animation-stack',
				'group'                        => ''
				// '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
			)
		);

	}

    /**
     * Helper function
     * returns an array containing all registered theme thumbnails dimensions
     * @return array
     */
    static function get_theme_thumbs_full() {
        $values_array = array();
        $values_array[ ' Full ' ] = '';

        foreach ( td_api_thumb::get_all() as $thumb ) {
            $values_array[$thumb['width'] . ' x ' . $thumb['height']] = $thumb['name'];
        }

        return $values_array;
    }

    static function get_block_style ($group = '') {
        return array(
            array(
                "param_name" => "separator",
                "type" => "horizontal_separator",
                "value" => "",
                "class" => "",
                'group' => $group,
            ),
            array(
                'param_name' => 'el_class',
                'type' => 'textfield',
                'value' => '',
                'heading' => 'Extra class',
                'description' => 'Style particular content element differently - add a class name and refer to it in custom CSS',
                'class' => 'tdc-textfield-extrabig',
                'group' => $group,
            ),
            array(
                'param_name' => 'tdc_css',
                'value' => '',
                'type' => 'tdc_css_editor',
                'heading' => '',
                'group' => 'Design options',
            )
        );
    }

    static function register_styles() {

        // Button styles
        td_api_style::add( 'tds_w_button1', array(
                'group' => 'tds_w_button',
                'title' => 'Style 1 - Solid',
                'file' => TD_WOO_DIR . '/styles/tds_w_button/tds_w_button1.php',
                'params' => array_merge(
                    array(
                        array(
                            "param_name" => "background_color",
                            "holder" => "div",
                            "class"       => "td-colorpicker-double-a",
                            "type" => "gradient",
                            'heading' => "Background color",
                            "value" => "",
                            "description" => 'Optional - Choose a custom background color for the button',
                            "group" => "Style",
                        ),
                        array(
                            "param_name" => "background_hover_color",
                            "holder" => "div",
                            "class"       => "td-colorpicker-double-b",
                            "type" => "gradient",
                            'heading' => "Hover background color",
                            "value" => "",
                            "description" => 'Optional - Choose a custom background hover color for the button',
                            "group" => "Style",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Text color',
                            "param_name" => "text_color",
                            "value" => '',
                            "description" => 'Optional - Choose a custom text color for the button',
                            "group" => "Style",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Hover text color',
                            "param_name" => "text_hover_color",
                            "value" => '',
                            "description" => 'Optional - Choose a custom text hover color for the button',
                            "group" => "Style",
                        ),
                        array(
                            "type" => "gradient",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Icon color',
                            "param_name" => "icon_color",
                            "value" => '',
                            "description" => 'Optional - Choose a custom icon color for the button',
                            "group" => "Style",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Hover icon color',
                            "param_name" => "icon_hover_color",
                            "value" => '',
                            "description" => 'Optional - Choose a custom icon hover color for the button',
                            "group" => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Style",
                        ),
                        array(
                            "type" => 'textfield-responsive',
                            "param_name" => 'border_radius',
                            "value" => '',
                            "heading" => 'Border radius',
                            "class" => 'tdc-textfield-small',
                            "description" => 'Optional - Choose a custom border radius for the button',
                            "placeholder" => "0",
                            "group" => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Style",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_btn_text', true, 'Button text', 'Style' )
                )
            )
        );

        td_api_style::add( 'tds_w_button2', array(
                'group' => 'tds_w_button',
                'title' => 'Style 2 - Bordered',
                'file' => TD_WOO_DIR . '/styles/tds_w_button/tds_w_button2.php',
                'params' => array_merge(
                    array(
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Text color',
                            "param_name" => "text_color",
                            "value" => '',
                            "description" => 'Optional - Choose a custom text color for the button',
                            "group" => "Style",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Hover text color',
                            "param_name" => "text_hover_color",
                            "value" => '',
                            "description" => 'Optional - Choose a custom text hover color for the button',
                            "group" => "Style",
                        ),
                        array(
                            "type" => "gradient",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Icon color',
                            "param_name" => "icon_color",
                            "value" => '',
                            "description" => 'Optional - Choose a custom icon color for the button',
                            "group" => "Style",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Hover icon color',
                            "param_name" => "icon_hover_color",
                            "value" => '',
                            "description" => 'Optional - Choose a custom icon hover color for the button',
                            "group" => "Style",
                        ),
                        array(
                            "type" => 'textfield-responsive',
                            "param_name" => 'border_size',
                            "value" => '',
                            "heading" => 'Border size',
                            "class" => 'tdc-textfield-small',
                            "description" => 'Optional - Choose a custom border size for the button',
                            "placeholder" => "2",
                            "group" => "Style",
                        ),
                        array(
                            "type" => "gradient",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Border color',
                            "param_name" => "border_color",
                            "value" => '',
                            "description" => 'Optional - Choose a custom border color for the button',
                            "group" => "Style",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Hover border color',
                            "param_name" => "border_hover_color",
                            "value" => '',
                            "description" => 'Optional - Choose a custom border hover color for the button',
                            "group" => "Style",
                        ),
                        array(
                            "param_name" => "border_style",
                            "type" => "dropdown",
                            "value" => array(
                                'Solid - default' => '',
                                'Dashed' => 'dashed',
                                'Dotted' => 'dotted',
                                'Double' => 'double',
                            ),
                            "heading" => 'Border style',
                            "description" => "Optional - Choose a custom border type for the button",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Style",
                        ),
                        array(
                            "type" => 'textfield-responsive',
                            "param_name" => 'border_radius',
                            "value" => '',
                            "heading" => 'Border radius',
                            "class" => 'tdc-textfield-small',
                            "description" => 'Optional - Choose a custom border radius for the button',
                            "placeholder" => "0",
                            "group" => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Style",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_btn_text', true, 'Button text', 'Style' )
                )
            )
        );

        td_api_style::add( 'tds_w_button3', array(
                'group' => 'tds_w_button',
                'title' => 'Style 3 - With shadow',
                'file' => TD_WOO_DIR . '/styles/tds_w_button/tds_w_button3.php',
                'params' => array_merge(array(
                    array(
                        "param_name" => "background_color",
                        "holder" => "div",
                        "class" => "td-colorpicker-double-a",
                        "type" => "gradient",
                        'heading' => "Background color",
                        "value" => "",
                        "description" => 'Optional - Choose a custom background color for the button',
                        "group" => "Style",
                    ),
                    array(
                        "param_name" => "background_hover_color",
                        "holder" => "div",
                        "class" => "td-colorpicker-double-b",
                        "type" => "gradient",
                        'heading' => "Hover background color",
                        "value" => "",
                        "description" => 'Optional - Choose a custom background hover color for the button',
                        "group" => "Style",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "td-colorpicker-double-a",
                        "heading" => 'Text color',
                        "param_name" => "text_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom text color for the button',
                        "group" => "Style",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "td-colorpicker-double-b",
                        "heading" => 'Hover text color',
                        "param_name" => "text_hover_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom text hover color for the button',
                        "group" => "Style",
                    ),
                    array(
                        "type" => "gradient",
                        "holder" => "div",
                        "class" => "td-colorpicker-double-a",
                        "heading" => 'Icon color',
                        "param_name" => "icon_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom icon color for the button',
                        "group" => "Style",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "td-colorpicker-double-b",
                        "heading" => 'Hover icon color',
                        "param_name" => "icon_hover_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom icon hover color for the button',
                        "group" => "Style",
                    ),
                    array(
                        "param_name" => "separator",
                        "type" => "horizontal_separator",
                        "value" => "",
                        "class" => "tdc-separator-small",
                        "group" => "Style",
                    ),
                ),
                    td_config_helper::get_map_block_shadow_array('shadow', 'Shadow', 16, 0, 2),
                    td_config_helper::get_map_block_shadow_array('shadow_hover', 'Hover shadow', 26, 0, 2, '', '', 0, false),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Style",
                        ),
                        array(
                            "type" => 'textfield-responsive',
                            "param_name" => 'border_radius',
                            "value" => '',
                            "heading" => 'Border radius',
                            "class" => 'tdc-textfield-small',
                            "description" => 'Optional - Choose a custom border radius for the button',
                            'placeholder' => '0',
                            "group" => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Style",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_btn_text', true, 'Button text', 'Style' )
                )
            )
        );

        td_api_style::add( 'tds_w_button4', array(
                'group' => 'tds_w_button',
                'title' => 'Style 4 - Text',
                'file' => TD_WOO_DIR . '/styles/tds_w_button/tds_w_button4.php',
                'params' => array_merge( array(
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "td-colorpicker-double-a",
                        "heading" => 'Text color',
                        "param_name" => "text_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom text color for the button',
                        "group" => "Style",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "td-colorpicker-double-b",
                        "heading" => 'Hover text color',
                        "param_name" => "text_hover_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom text hover color for the button',
                        "group" => "Style",
                    ),
                    array(
                        "type" => "gradient",
                        "holder" => "div",
                        "class" => "td-colorpicker-double-a",
                        "heading" => 'Icon color',
                        "param_name" => "icon_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom icon color for the button',
                        "group" => "Style",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "td-colorpicker-double-b",
                        "heading" => 'Hover icon color',
                        "param_name" => "icon_hover_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom icon hover color for the button',
                        "group" => "Style",
                    ),
                ),
                    td_config_helper::get_map_block_font_array( 'f_btn_text', true, 'Button text', 'Style' )
                ),
            )
        );

        td_api_style::add( 'tds_w_button5', array(
                'group' => 'tds_w_button',
                'title' => 'Style 5 - Bordered with shadow',
                'file' => TD_WOO_DIR . '/styles/tds_w_button/tds_w_button5.php',
                'params' => array_merge( array(
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "td-colorpicker-double-a",
                        "heading" => 'Text color',
                        "param_name" => "text_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom text color for the button',
                        "group" => "Style",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "td-colorpicker-double-b",
                        "heading" => 'Hover text color',
                        "param_name" => "text_hover_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom text hover color for the button',
                        "group" => "Style",
                    ),
                    array(
                        "type" => "gradient",
                        "holder" => "div",
                        "class" => "td-colorpicker-double-a",
                        "heading" => 'Icon color',
                        "param_name" => "icon_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom icon color for the button',
                        "group" => "Style",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "td-colorpicker-double-b",
                        "heading" => 'Hover icon color',
                        "param_name" => "icon_hover_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom icon hover color for the button',
                        "group" => "Style",
                    ),
                    array(
                        "param_name" => "separator",
                        "type" => "horizontal_separator",
                        "value" => "",
                        "class" => "tdc-separator-small",
                        "group" => "Style",
                    ),
                    array(
                        "type" => 'textfield-responsive',
                        "param_name" => 'border_size',
                        "value" => '',
                        "heading" => 'Border size',
                        "class" => 'tdc-textfield-small',
                        "description" => 'Optional - Choose a custom border size for the button',
                        "placeholder" => "1",
                        "group" => "Style",
                    ),
                    array(
                        "type" => "gradient",
                        "holder" => "div",
                        "class" => "td-colorpicker-double-a",
                        "heading" => 'Border color',
                        "param_name" => "border_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom border color for the button',
                        "group" => "Style",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "td-colorpicker-double-b",
                        "heading" => 'Hover border color',
                        "param_name" => "border_hover_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom border hover color for the button',
                        "group" => "Style",
                    ),
                    array(
                        "param_name" => "border_style",
                        "type" => "dropdown",
                        "value" => array(
                            'Solid - default' => '',
                            'Dashed' => 'dashed',
                            'Dotted' => 'dotted',
                            'Double' => 'double',
                        ),
                        "heading" => 'Border style',
                        "description" => "Optional - Choose a custom border type for the button",
                        "holder" => "div",
                        "class" => "tdc-dropdown-big",
                        "group" => "Style",
                    ),
                    array(
                        "type" => 'textfield-responsive',
                        "param_name" => 'border_radius',
                        "value" => '',
                        "heading" => 'Border radius',
                        "class" => 'tdc-textfield-small',
                        "description" => 'Optional - Choose a custom border radius for the button',
                        "placeholder" => "0",
                        "group" => "Type",
                    ),
                    array(
                        "param_name" => "separator",
                        "type" => "horizontal_separator",
                        "value" => "",
                        "class" => "tdc-separator-small",
                        "group" => "Style",
                    ),
                    array(
                        'param_name' => 'shadow_offset',
                        'type' => 'range-responsive',
                        'value' => '4',
                        'heading' => 'Shadow offset',
                        'description' => '',
                        'class' => 'tdc-textfield-small',
                        'range_min' => '-40',
                        'range_max' => '40',
                        'range_step' => '1',
                        "group" => "Style",
                    ),
                    array(
                        'param_name' => 'shadow_hover_offset',
                        'type' => 'range-responsive',
                        'value' => '0',
                        'heading' => 'Shadow hover offset',
                        'description' => '',
                        'class' => 'tdc-textfield-small',
                        'range_min' => '-40',
                        'range_max' => '40',
                        'range_step' => '1',
                        "group" => "Style",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "td-colorpicker-double-a",
                        "heading" => 'Shadow color',
                        "param_name" => "shadow_color",
                        "value" => '',
                        "description" => '',
                        "group" => "Style",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "td-colorpicker-double-b",
                        "heading" => 'Shadow hover color',
                        "param_name" => "shadow_hover_color",
                        "value" => '',
                        "description" => '',
                        "group" => "Style",
                    ),
                    array(
                        "param_name" => "separator",
                        "type" => "horizontal_separator",
                        "value" => "",
                        "class" => "tdc-separator-small",
                        "group" => "Style",
                    ),
                ),
                    td_config_helper::get_map_block_font_array( 'f_btn_text', true, 'Button text', 'Style' )
                ),
            )
        );

        td_api_style::add( 'tds_w_button6', array(
                'group' => 'tds_w_button',
                'title' => 'Style 6 - Circle animation',
                'file' => TD_WOO_DIR . '/styles/tds_w_button/tds_w_button6.php',
                'params' => array_merge(array(
                    array(
                        "param_name" => "background_color",
                        "holder" => "div",
                        "class" => "td-colorpicker-double-a",
                        "type" => "gradient",
                        'heading' => "Background color",
                        "value" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiIjMjIyMjIyIiwiY29sb3IyIjoiIzZiNmI2YiIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiLTYwIiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoLTYwZGVnLCM2YjZiNmIsIzIyMjIyMik7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KC02MGRlZywjNmI2YjZiLCMyMjIyMjIpOyIsImNzc1BhcmFtcyI6Ii02MGRlZywjNmI2YjZiLCMyMjIyMjIifQ==",
                        "description" => 'Optional - Choose a custom background color for the button',
                        "group" => "Style",
                    ),
                    array(
                        "param_name" => "background_hover_color",
                        "holder" => "div",
                        "class" => "td-colorpicker-double-b",
                        "type" => "gradient",
                        'heading' => "Hover background color",
                        "value" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiIjNTE4OGY3IiwiY29sb3IyIjoiIzRkYjJlYyIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiLTYwIiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoLTYwZGVnLCM0ZGIyZWMsIzUxODhmNyk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KC02MGRlZywjNGRiMmVjLCM1MTg4ZjcpOyIsImNzc1BhcmFtcyI6Ii02MGRlZywjNGRiMmVjLCM1MTg4ZjcifQ==",
                        "description" => 'Optional - Choose a custom background hover color for the button',
                        "group" => "Style",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "td-colorpicker-double-a",
                        "heading" => 'Text color',
                        "param_name" => "text_color",
                        "value" => '#fff',
                        "description" => 'Optional - Choose a custom text color for the button',
                        "group" => "Style",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "td-colorpicker-double-b",
                        "heading" => 'Hover text color',
                        "param_name" => "text_hover_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom text hover color for the button',
                        "group" => "Style",
                    ),
                    array(
                        "type" => "gradient",
                        "holder" => "div",
                        "class" => "td-colorpicker-double-a",
                        "heading" => 'Icon color',
                        "param_name" => "icon_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom icon color for the button',
                        "group" => "Style",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "td-colorpicker-double-b",
                        "heading" => 'Hover icon color',
                        "param_name" => "icon_hover_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom icon hover color for the button',
                        "group" => "Style",
                    ),
                    array(
                        "param_name" => "zoom_effect",
                        "type" => "checkbox",
                        "value" => 'yes',
                        "heading" => "Enable zoom effect",
                        "description" => "",
                        "holder" => "div",
                        "class" => "",
                        "group" => "Style",
                    ),
                    array(
                        "param_name" => "separator",
                        "type" => "horizontal_separator",
                        "value" => "",
                        "class" => "tdc-separator-small",
                        "group" => "Style",
                    ),
                ),
                    td_config_helper::get_map_block_shadow_array('shadow', 'Shadow', 16, 0, 2),
                    td_config_helper::get_map_block_shadow_array('shadow_hover', 'Hover shadow', 26, 0, 4, '', '', 0, false),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Style",
                        ),
                        array(
                            "type" => 'textfield-responsive',
                            "param_name" => 'border_radius',
                            "value" => '4',
                            "heading" => 'Border radius',
                            "class" => 'tdc-textfield-small',
                            "description" => 'Optional - Choose a custom border radius for the button',
                            'placeholder' => '0',
                            "group" => "Style",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Style",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_btn_text', true, 'Button text', 'Style' )
                )
            )
        );


        // Product favorite styles
        td_api_style::add( 'tds_w_favorite1', array(
                'group' => 'tds_w_favorite',
                'title' => 'Style 1 - Icon only',
                'file' => TD_WOO_DIR . '/styles/tds_w_favorite/tds_w_favorite1.php',
                'params' => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Layout',
                            "value"      => "",
                            "class"      => "",
                            'group' => ''
                        ),
                        array(
                            'type' => 'range-responsive',
                            'param_name' => 'icon_size',
                            'value' => '20',
                            'heading' => 'Icon size (px)',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '10',
                            'range_max' => '150',
                            'range_step' => '5',
                        ),
                        array(
                            'param_name' => 'icon_spacing',
                            'type' => 'range-responsive',
                            'value' => '2',
                            'heading' => 'Icon spacing',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '1',
                            'range_max' => '3',
                            'range_step' => '0.1',
                        ),
                        array(
                            'param_name' => 'vert_align',
                            'type' => 'range-responsive',
                            'value' => '0',
                            'heading' => 'Vertical align',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '-20',
                            'range_max' => '20',
                            'range_step' => '1',
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            'param_name' => 'all_ico_border_size',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Border size',
                            'description' => '',
                            'class' => 'tdc-textfield-big',
                            'placeholder' => '0',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "all_ico_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => 'solid',
                                'Dashed' => 'dashed',
                                'Dotted' => 'dotted',
                                'Double' => 'double',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                        ),
                        array(
                            'param_name' => 'ico_border_radius',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Border radius',
                            'description' => '',
                            'class' => 'tdc-textfield-big',
                            'placeholder' => '100%',
                            "group" => "",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Style',
                            "value"      => "",
                            "class"      => "",
                            'group' => ''
                        ),
                        array(
                            "param_name" => "icon_color",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-a",
                            "heading" => 'Icon color',
                            "value" => '',
                            "description" => '',
                            "group"      => "",
                        ),
                        array(
                            "param_name" => "icon_color_h",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-b",
                            "heading" => 'Icon hover/added color',
                            "value" => '',
                            "description" => '',
                            "group"      => "",
                        ),
                        array(
                            "param_name" => "icon_bg",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-a",
                            "heading" => 'Icon background color',
                            "value" => '',
                            "description" => '',
                            "group"      => "",
                        ),
                        array(
                            "param_name" => "icon_bg_h",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-b",
                            "heading" => 'Icon background hover/added color',
                            "value" => '',
                            "description" => '',
                            "group"      => "",
                        ),
                        array(
                            "param_name" => "all_ico_border_color",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-a",
                            "heading" => 'Icon border color',
                            "value" => '',
                            "description" => '',
                            "group"      => "",
                        ),
                        array(
                            "param_name" => "ico_border_color_h",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-b",
                            "heading" => 'Icon border hover/added color',
                            "value" => '',
                            "description" => '',
                            "group"      => "",
                        ),
                    ),
                    td_config_helper::get_map_block_shadow_array('ico_shadow', 'Shadow', 0, 0, 0)
                )
            )
        );

        td_api_style::add( 'tds_w_favorite2', array(
                'group' => 'tds_w_favorite',
                'title' => 'Style 2 - Icon with text',
                'file' => TD_WOO_DIR . '/styles/tds_w_favorite/tds_w_favorite2.php',
                'params' => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Layout',
                            "value"      => "",
                            "class"      => "",
                            'group' => ''
                        ),
                        array(
                            'param_name' => 'min_width',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Minimum width',
                            'description' => '',
                            'class' => 'tdc-textfield-big',
                            'placeholder' => 'auto',
                            "group" => "",
                        ),
                        array(
                            'param_name' => 'padding',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Padding',
                            'description' => '',
                            'class' => 'tdc-textfield-big',
                            'placeholder' => '10px 15px',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "btn_horiz_align",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Horizontal align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class"
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "",
                        ),
                        array(
                            'param_name' => 'all_border_size',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Border size',
                            'description' => '',
                            'class' => 'tdc-textfield-big',
                            'placeholder' => '0',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "all_border_style",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Solid' => 'solid',
                                'Dashed' => 'dashed',
                                'Dotted' => 'dotted',
                                'Double' => 'double',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                        ),
                        array(
                            'param_name' => 'border_radius',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Border radius',
                            'description' => '',
                            'class' => 'tdc-textfield-big',
                            'placeholder' => '0',
                            "group" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Icon',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            'group' => ''
                        ),
                        array(
                            'type' => 'range-responsive',
                            'param_name' => 'icon_size',
                            'value' => '17',
                            'heading' => 'Size (px)',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '10',
                            'range_max' => '150',
                            'range_step' => '5',
                        ),
                        array(
                            "param_name" => "icon_pos",
                            "type" => "dropdown",
                            "value" => array(
                                'Before the text' => '',
                                'After the text' => 'after',
                            ),
                            "heading" => 'Position',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "",
                        ),
                        array(
                            'param_name' => 'icon_space',
                            'type' => 'textfield-responsive',
                            'value' => '',
                            'heading' => 'Space',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'placeholder' => '10',
                            "group" => "",
                        ),
                        array(
                            'param_name' => 'vert_align',
                            'type' => 'range-responsive',
                            'value' => '0',
                            'heading' => 'Vertical align',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '-20',
                            'range_max' => '20',
                            'range_step' => '1',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Text',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            'group' => ''
                        ),
                        array(
                            'param_name' => 'text_init',
                            'type' => 'textfield',
                            'value' => '',
                            'heading' => 'Initial text',
                            'description' => '',
                            'class' => 'tdc-textfield-big',
                            'placeholder' => '',
                            "group" => "",
                        ),
                        array(
                            'param_name' => 'text_added',
                            'type' => 'textfield',
                            'value' => '',
                            'heading' => 'Added text',
                            'description' => '',
                            'class' => 'tdc-textfield-big',
                            'placeholder' => '',
                            "group" => "",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Style',
                            "value"      => "",
                            "class"      => "",
                            'group' => ''
                        ),
                        array(
                            "param_name" => "bg",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-a",
                            "heading" => 'Background color',
                            "value" => '',
                            "description" => '',
                            "group"      => "",
                        ),
                        array(
                            "param_name" => "bg_h",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-b",
                            "heading" => 'Background hover/added color',
                            "value" => '',
                            "description" => '',
                            "group"      => "",
                        ),
                        array(
                            "param_name" => "all_border_color",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-a",
                            "heading" => 'Border color',
                            "value" => '',
                            "description" => '',
                            "group"      => "",
                        ),
                        array(
                            "param_name" => "border_color_h",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-b",
                            "heading" => 'Border hover/added color',
                            "value" => '',
                            "description" => '',
                            "group"      => "",
                        ),
                    ),
                    td_config_helper::get_map_block_shadow_array('shadow', 'Shadow', 0, 0, 0),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Icon',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            'group' => ''
                        ),
                        array(
                            "param_name" => "icon_color",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-a",
                            "heading" => 'Icon color',
                            "value" => '',
                            "description" => '',
                            "group"      => "",
                        ),
                        array(
                            "param_name" => "icon_color_h",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-b",
                            "heading" => 'Icon hover/added color',
                            "value" => '',
                            "description" => '',
                            "group"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Text',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            'group' => ''
                        ),
                        array(
                            "param_name" => "txt_color",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-a",
                            "heading" => 'Text color',
                            "value" => '',
                            "description" => '',
                            "group"      => "",
                        ),
                        array(
                            "param_name" => "txt_color_h",
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-colorpicker-double-b",
                            "heading" => 'Text hover/added color',
                            "value" => '',
                            "description" => '',
                            "group"      => "",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_txt', true, 'Text' )
                )
            )
        );
    }

	/**
	 * the product filters array ( used by td_woo_products_block filters )
	 * @param string $group
	 *
	 * @return array
	 */
	static function get_map_filter_array ( $group = 'Filter' ) {
		return array(
			array(
				"param_name" => "separator",
				"type"       => "text_separator",
				'heading'    => 'Filters',
				"value"      => "",
				"class"      => "",
				'group' => $group
			),
			array(
				"param_name" => "products_ids",
				"type" => "textfield",
				"value" => '',
				"heading" => 'Products ID filter:',
				"description" => "Filter multiple products by ID. Enter here the product IDs separated by commas (ex: 10,27,233). To exclude products from this block add them with '-' (ex: -7, -16)",
				"holder" => "div",
				"class" => "tdc-textfield-big",
				'group' => $group
			),
			array(
				"param_name" => "product_cat",
				"type" => "dropdown",
				"value" => td_woo_util::products_categories2id_array(),
				"heading" => 'Product Categories Filter:',
				"description" => "A single product category filter. If you want to filter multiple categories, use the 'Multiple Categories Filter' and leave this to default",
				"holder" => "div",
				"class" => "tdc-dropdown-big",
				'group' => $group
			),
			array(
				"param_name" => "product_categories_ids",
				"type" => "textfield",
				"value" => '',
				"heading" => 'Multiple Product Categories Filter:',
				"description" => "Filter multiple product categories by ID. Enter here the product categories IDs separated by commas (ex: 13,23,18). To exclude categories, add them with '-' (ex: -9, -10)",
				"holder" => "div",
				"class" => "tdc-textfield-big",
				'group' => $group
			),
			array(
				"param_name" => "product_tag_slug",
				"type" => "textfield",
				"value" => '',
				"heading" => 'Filter products by tag slug:',
				"description" => "To filter multiple tag slugs, enter here the tag slugs separated by commas (ex: tag1,tag2,tag3)",
				"holder" => "div",
				"class" => "tdc-textfield-big",
				'group' => $group
			),
			array(
				"param_name" => "sort",
				"type" => "dropdown",
				"value" => array (
					'- Menu Order -' => '',
					'Title' => 'title',
					'Date' => 'date',
					'Random' => 'rand',
					'Price' => 'price',
					'Popularity' => 'popularity',
					'Highest rated' => 'rating',
					'ID' => 'id',
					'Favourites' => 'favourites',
				),
				"heading" => 'Sort order:',
				"description" => "How to sort the products.",
				"holder" => "div",
				"class" => "tdc-dropdown-big",
				'group' => $group
			),

			// this are added to the main group
			array(
				"param_name" => "separator",
				"type"       => "text_separator",
				'heading'    => 'Extra',
				"value"      => "",
				"class"      => "",
			),
			array(
				"param_name" => "limit",
				"type" => "textfield",
				"value" => '5',
				"heading" => 'Limit products number:',
				"description" => "If the field is empty the limit products number will be the number from Wordpress settings -> Reading",
				"holder" => "div",
				"class" => "tdc-textfield-small",
			),
			array(
				"param_name" => "offset",
				"type" => "textfield",
				"value" => '',
				"heading" => 'Offset products:',
				"description" => "Start the count with an offset. If you have a block that shows 5 posts before this one, you can make this one start from the 6'th post (by using offset 5)",
				"holder" => "div",
				"class" => "tdc-textfield-small",
			),
			array(
				'param_name' => 'el_class',
				'type' => 'textfield',
				'value' => '',
				'heading' => 'Extra class',
				'description' => 'This option helps you style particular content element differently - add a class name and refer to it in custom CSS',
				'class' => 'tdc-textfield-extrabig',
			)

		);
	}

	/**
	 * the product ajax filters array ( used by td_woo_products_block filters )
	 *
	 * @return array
	 */
	static function get_map_block_ajax_filter_array() {
		return array (
			array (
				"param_name" => "separator",
				"type"       => "text_separator",
				'heading'    => 'Ajax products categories dropdown',
				"value"      => "",
				"class"      => "",
				'group' =>  'Filter'
			),

			// custom filter types
			array (
				"param_name" => "td_ajax_filter_type", // this is used to build the filter list (for example a list of categories from the id-s bellow)
				"type" => "dropdown",
				"value" => array (
					'- No drop down ajax filter -' => '',
					'Filter by product categories' => 'td_products_category_ids_filter',
					'Filter by tag IDs' => 'td_products_tag_slug_filter',
				),
				"heading" => 'Filter type:',
				"description" => "Show the ajax drop down filter. The ajax filters require an additional parameter. If no ids are provided in the input below, the filter will show all the available items ( ex: all products categories etc.. )",
				"holder" => "div",
				"class" => "tdc-dropdown-big",
				'group' =>  'Filter'
			),

			// filter by ids
			array (
				"param_name" => "td_ajax_filter_ids", //the ids that we will show in the list
				"type" => "textfield",
				"value" => '',
				"heading" => 'Show the following IDs:',
				"description" => "The ajax drop down shows only the ( products categories IDs OR tag IDs ) that you enter here separated by comas",
				"holder" => "div",
				"class" => "tdc-textfield-big",
				'group' =>  'Filter'
			),

			// default pull down text
			array (
				"param_name" => "td_filter_default_txt",
				"type" => "textfield",
				"value" => 'All',
				"heading" => 'Filter dropdown text:',
				"description" => "The default text for the first item from the drop down. The first item shows the default block settings ( the settings from the Filter tab )",
				"holder" => "div",
				"class" => "tdc-textfield-big",
				'group' =>  'Filter'
			),

			array (
				"param_name" => "td_ajax_preloading",  // preloader settings
				"type" => "dropdown",
				"value" => array(
					'- No preloading -' => '',
					'Optimized preloading' => 'preload',
					'Preload all' => 'preload_all'
				),
				"heading" => 'Content preloading:',
				"description" => "The content that is displayed when a user clicks on an ajax filter from the dropdown is preloaded on each pageview. WARNING: This feature consumes more resources on the server.",
				"holder" => "div",
				"class" => "tdc-dropdown-big",
				'group' =>  'Filter'
			),
		);
	}

	/**
	 * product attributes settings array ( used by td_woo_attribute_filter shortcode )
	 *
	 * @return array
	 */
	static function td_woo_attribute_filter_attributes_settings() {

		// attributes taxonomies ... these are retrieved straight from the database
		$attributes_taxonomies = wc_get_attribute_taxonomies();

		// ..default product taxonomies
		$default_taxonomies = array(
			(object) array(
				'name' => 'product_cat',
				'label' => 'Product categories'
			),
			(object) array(
				'name' => 'product_tag',
				'label' => 'Product tags'
			)
		);

		$taxonomies = array_merge( $attributes_taxonomies, $default_taxonomies );

		$settings = array();

        if ( !empty( $taxonomies ) && is_array( $taxonomies ) ) {
	        $settings[] = array(
                "param_name" => "separator",
                "type"       => "text_separator",
                'heading'    => 'Filters type',
                "value"      => "",
                "class"      => "tdc-separator",
                "group"      => ""
            );

            $settings[] = array(
                "param_name" => "filter_header",
                "type" => "filter_header",
                "value" => "",
                "class" => '',
            );

            foreach ( $taxonomies as $taxonomy ) {
	            $tax_name  = $taxonomy->attribute_name ?? ( $taxonomy->name ?? '' );
	            $tax_label = $taxonomy->attribute_label ?? ( $taxonomy->label ?? '' );

                // control name
                $settings[] = array(
                    "param_name" => "filter_title",
                    "type" => "filter_title",
                    "value" => $tax_label,
                    "class" => '',
                    "info_img" => '',
                    "description" => '',
                );

	            // control type
	            $settings[] = array(
		            "param_name"  => strtolower( $tax_name ) . "_type",
		            "type"        => "dropdown",
		            "value"       => array(
			            'Default'    => '',
			            'OFF'        => 'off',
			            '----------' => '__',
			            'Dropdown'   => 'select',
			            'Color'      => 'color',
			            'Button'     => 'button',
			            'Checkbox'   => 'checkbox',
			            'Image'      => 'image',
		            ),
		            "heading"     => $tax_label,
		            "description" => "Option to disable filter or change its type. By default the global attributes type will be used or, if global type is not available, the button type will be used as default type.",
		            "holder"      => "div",
		            "class"       => "tdc-filter-controller tdc-filter-type",
		            "group"       => "",
	            );

	            // prod attributes action type
	            // add option to set the behaviour of product attributes filters ( to allow multiple selection or go to selected )
	            if ( isset( $taxonomy->attribute_id ) ) { // is attribute tax

		            $settings[] = array(
			            "param_name"  => strtolower( $tax_name ) . "_multiple_selection",
			            "type"        => "checkbox",
			            "value"       => '',
			            "heading"     => 'Enable multiple selection on ' . $tax_label,
			            "description" => "unchecked > Single selection - filter products just from the selected attribute.
OR
checked > Multiple selection - filter products from multiple attributes based on selection.",
			            "holder"      => "div",
			            "class"       => "tdc-filter-controller tdc-filter-multiple",
			            "group"       => "",
		            );

	            }

	            // for product cat taxonomies..
	            if ( $tax_name === 'product_cat' ) {
		            // add option to set the behaviour of product cats filters ( to allow multiple selection or go to selected )
		            $settings[] = array(
			            "param_name" => "product_cat_type_action",
			            "type" => "checkbox",
			            "value" => "",
			            "heading" => 'Product categories filter type',
			            "description" => "unchecked > Single selection - filter products just from the selected category.
OR
checked > Multiple selection - filter products from multiple categories based on selection.",
			            "holder" => "div",
			            "class" => "tdc-filter-controller tdc-filter-multiple",
			            "group" => "",
		            );
	            }
            }
        }

		$settings = array_merge(
			$settings,
			array(
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'General settings',
                    "value"      => "",
                    "class"      => "",
                ),
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Headers',
                    "value"      => "",
                    "class"      => "tdc-separator-small",
                ),
                array(
                    "param_name" => "custom_title",
                    "type" => "textfield",
                    "value" => "",
                    "heading" => 'Custom title:',
                    "description" => "Optional - a title for this block, if you leave it blank the block will not have a title",
                    "holder" => "div",
                    "class" => "tdc-textfield-extrabig tdc-hidden",
                    "info_img" => "https://cloud.tagdiv.com/help/custom_title.png",
                ),
                array(
                    "param_name" => "block_template_id",
                    "type" => "dropdown",
                    "value" => td_util::get_block_template_ids(),
                    "heading" => 'Header template:',
                    "description" => "Header template used by the current block",
                    "holder" => "div",
                    "class" => "tdc-dropdown-big",
                    "info_img" => "https://cloud.tagdiv.com/help/header_template.png",
                ),
                array(
                    "param_name" => "content_align_horizontal",
                    "type" => "dropdown-responsive",
                    "value" => array(
                        'Default' => 'layout-default',
                        'Left' => 'content-horiz-left',
                        'Center' => 'content-horiz-center',
                        'Right' => 'content-horiz-right'
                    ),
                    "heading" => 'Headers align',
                    "description" => "",
                    "holder" => "div",
                    'tdc_dropdown_images' => true,
                    "class" => "tdc-visual-selector tdc-add-class",
                ),
                array(
                    'param_name' => 'label_space',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Headers bottom space',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '',
                    "group"      => ""
                ),
                array(
                    "param_name" => "separator",
                    "type" => "horizontal_separator",
                    "value" => "",
                    "class" => "tdc-separator-small",
                    "group" => "",
                ),
            ),
            td_config_helper::get_map_block_font_array( 'f_label', true, 'Headers text' ),
            array(
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Filters',
                    "value"      => "",
                    "class"      => "tdc-separator-small",
                ),
                array(
                    "param_name" => "filters_bg",
                    "type" => "gradient",
                    "holder" => "div",
                    "class" => "",
                    "heading" => 'Filters background color',
                    "value" => '',
                    "description" => '',
                    "group"      => "",
                ),
                array(
                    'param_name' => 'filters_space',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Filters space',
                    'description' => '',
                    'class' => 'tdc-textfield-big',
                    'placeholder' => '0',
                    "group"      => ""
                ),
                array(
                    'param_name' => 'filters_radius',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Filters border radius',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '0',
                    "group"      => ""
                ),
                array(
                    'param_name' => 'filters_bottom_space',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Filters bottom space',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '25',
                    "group"      => ""
                ),
                array(
                    "param_name" => "filters_layout",
                    "type" => "dropdown-responsive",
                    "value" => array(
                        'Vertical' => '',
                        'Horizontal' => 'horizontal',
                    ),
                    "heading" => 'Filters layout',
                    "description" => "",
                    "holder" => "div",
                    "class" => "tdc-dropdown-big",
                    "group" => "",
                ),
                array(
                    "param_name" => "filters_horiz_align",
                    "type" => "dropdown-responsive",
                    "value" => array(
                        'Start' => 'flex-start',
                        'Center' => 'center',
                        'End' => 'flex-end',
                        'Space between' => 'space-between',
                        'Space evenly' => 'space-evenly',
                    ),
                    "heading" => 'Horizontal align',
                    "description" => "",
                    "holder" => "div",
                    'tdc_dropdown_images' => true,
                    "class" => "tdc-visual-selector tdc-flex-selector tdc-flex-row-horiz-align tdc-add-class",
                    'group' => '',
                ),
                array(
                    "param_name" => "filters_wrap",
                    "type" => "dropdown-responsive",
                    "value" => array(
                        'Stay on one line (nowrap)' => '',
                        'Multiple lines (wrap)' => 'wrap',
                    ),
                    "heading" => 'Filters wrap',
                    "description" => "",
                    "holder" => "div",
                    "class" => "tdc-dropdown-big",
                    "group" => "",
                ),
                array(
                    'param_name' => 'filters_width',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Filters maxim width',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '',
                    "group"      => ""
                ),
            ),
            td_config_helper::get_map_block_shadow_array('filters_shadow', 'Filters shadow', 0, 0, 0, ''),
            array(
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Terms count',
                    "value"      => "",
                    "class"      => "",
                    "group"      => ""
                ),
                array(
                    "param_name" => "show_count",
                    "type" => "checkbox",
                    "value" => '',
                    "heading" => 'Show terms count',
                    "description" => "This option will enable the display of available results for terms(filters)",
                    "holder" => "div",
                    "class" => ""
                ),
                array(
                    'param_name' => 'count_padd',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Padding',
                    'description' => '',
                    'class' => 'tdc-textfield-big',
                    'placeholder' => '0 5px',
                    "group"      => ""
                ),
                array(
                    'param_name' => 'count_horiz',
                    'type' => 'range-responsive',
                    'value' => '0',
                    'heading' => 'Horizontal align',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'range_min' => '-30',
                    'range_max' => '30',
                    'range_step' => '1',
                    "group" => "",
                ),
                array(
                    'param_name' => 'count_vert',
                    'type' => 'range-responsive',
                    'value' => '0',
                    'heading' => 'Vertical align',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'range_min' => '-30',
                    'range_max' => '30',
                    'range_step' => '1',
                    "group" => "",
                ),
                array(
                    'param_name' => 'count_radius',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Border radius',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '30',
                    "group"      => ""
                ),
                array(
                    "param_name" => "count_txt_color",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "tdc-colorpicker-double-a",
                    "heading" => 'Text color',
                    "value" => '#ffffff',
                    "description" => '',
                    "group"      => "",
                ),
                array(
                    "param_name" => "count_txt_color_h",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "tdc-colorpicker-double-b",
                    "heading" => 'Text hover color',
                    "value" => '',
                    "description" => '',
                    "group"      => "",
                ),
                array(
                    "param_name" => "count_bg_color",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "tdc-colorpicker-double-a",
                    "heading" => 'Background color',
                    "value" => '#4db2ec',
                    "description" => '',
                    "group"      => "",
                ),
                array(
                    "param_name" => "count_bg_color_h",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "tdc-colorpicker-double-b",
                    "heading" => 'Background hover color',
                    "value" => '',
                    "description" => '',
                    "group"      => "",
                ),
            ),
            td_config_helper::get_map_block_font_array( 'f_count', true, 'Count text' ),
            array(
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Reset filters button',
                    "value"      => "",
                    "class"      => "",
                    "group"      => ""
                ),
                array(
                    "param_name" => "reset_show",
                    "type" => "checkbox",
                    "value" => '',
                    "heading" => 'Show in composer',
                    "description" => "",
                    "holder" => "div",
                    "class" => ""
                ),
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Button style',
                    "value"      => "",
                    "class"      => "tdc-separator-small",
                    "group"      => ""
                ),
                array(
                    "param_name" => "reset_full",
                    "type" => "checkbox-responsive",
                    "value" => '',
                    "heading" => 'Full button',
                    "description" => "",
                    "holder" => "div",
                    "class" => ""
                ),
                array(
                    "param_name" => "reset_horizontal",
                    "type" => "dropdown-responsive",
                    "value" => array(
                        'Default' => 'layout-default',
                        'Left' => 'content-horiz-left',
                        'Center' => 'content-horiz-center',
                        'Right' => 'content-horiz-right'
                    ),
                    "heading" => 'Align',
                    "description" => "",
                    "holder" => "div",
                    'tdc_dropdown_images' => true,
                    "class" => "tdc-visual-selector tdc-add-class",
                ),
                array(
                    'param_name' => 'reset_padd',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Padding',
                    'description' => '',
                    'class' => 'tdc-textfield-big',
                    'placeholder' => '9px 9px 9px 9px',
                    "group"      => ""
                ),
                array(
                    'param_name' => 'reset_border',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Border size',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '1',
                    "group"      => ""
                ),
                array(
                    'param_name' => 'reset_radius',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Border radius',
                    'description' => '',
                    'class' => 'tdc-textfield-big',
                    'placeholder' => '0',
                    "group"      => ""
                ),
                array(
                    "param_name" => "reset_border_color",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "tdc-colorpicker-double-a",
                    "heading" => 'Border color',
                    "value" => '',
                    "description" => '',
                    "group"      => "",
                ),
                array(
                    "param_name" => "reset_border_color_h",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "tdc-colorpicker-double-b",
                    "heading" => 'Border hover color',
                    "value" => '',
                    "description" => '',
                    "group"      => "",
                ),
                array(
                    "param_name" => "separator",
                    "type" => "horizontal_separator",
                    "value" => "",
                    "class" => "tdc-separator-small",
                    "group" => "",
                ),
                array(
                    'param_name' => 'reset_txt',
                    'type' => 'textfield',
                    'value' => '',
                    'heading' => 'Text',
                    'description' => '',
                    'class' => 'tdc-textfield-big',
                    'placeholder' => 'Clear all filters',
                    "group"      => ""
                ),
                array(
                    "param_name" => "reset_bg",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "tdc-colorpicker-double-a",
                    "heading" => 'Background color',
                    "value" => '',
                    "description" => '',
                    "group"      => "",
                ),
                array(
                    "param_name" => "reset_bg_h",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "tdc-colorpicker-double-b",
                    "heading" => 'Background hover color',
                    "value" => '',
                    "description" => '',
                    "group"      => "",
                ),
                array(
                    "param_name" => "reset_color",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "tdc-colorpicker-double-a",
                    "heading" => 'Text color',
                    "value" => '',
                    "description" => '',
                    "group"      => "",
                ),
                array(
                    "param_name" => "reset_color_h",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "tdc-colorpicker-double-b",
                    "heading" => 'Text hover color',
                    "value" => '',
                    "description" => '',
                    "group"      => "",
                ),
                array(
                    'param_name' => 'reset_txt_space',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Text space',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '9',
                    "group"      => ""
                ),
                array(
                    'param_name' => 'reset_space',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Bottom space',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '25',
                    "group"      => ""
                ),
                array(
                    "param_name" => "separator",
                    "type" => "horizontal_separator",
                    "value" => "",
                    "class" => "tdc-separator-small",
                    "group" => "",
                ),
                array(
                    'param_name' => 'reset_tdicon',
                    'type' => 'icon',
                    'heading' => 'Icon',
                    'class' => 'tdc-textfield-small',
                    'value' => '',
                ),
                array(
                    'param_name' => 'reset_icon_size',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Icon size',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '10',
                    "group"      => ""
                ),
                array(
                    "param_name" => "reset_icon_color",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "tdc-colorpicker-double-a",
                    "heading" => 'Icon color',
                    "value" => '',
                    "description" => '',
                    "group"      => "",
                ),
                array(
                    "param_name" => "reset_icon_color_h",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "tdc-colorpicker-double-b",
                    "heading" => 'Icon hover color',
                    "value" => '',
                    "description" => '',
                    "group"      => "",
                ),
            ),
            td_config_helper::get_map_block_font_array( 'f_reset', true, 'Button text' ),
            array(
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Mobile filters button',
                    "value"      => "",
                    "class"      => "",
                    "group"      => ""
                ),
                array(
                    "param_name" => "fmob_color",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "",
                    "heading" => 'Background color',
                    "value" => '',
                    "description" => '',
                    "group"      => "",
                ),
            ),
            td_config_helper::get_map_block_shadow_array('fmob_shadow', 'Button shadow', 8, 2, 3 ),
            array(
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Dropdowns',
                    "value"      => "",
                    "class"      => "",
                    "group"      => "Filters style"
                ),
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Layout',
                    "value"      => "",
                    "class"      => "tdc-separator-small",
                    "group"      => "Filters style"
                ),
                array(
                    'param_name' => 'drop_padding',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Padding',
                    'description' => '',
                    'class' => 'tdc-textfield-big',
                    'placeholder' => '9px 9px 9px 9px',
                    "group"      => "Filters style"
                ),
                array(
                    "param_name" => "separator",
                    "type" => "horizontal_separator",
                    "value" => "",
                    "class" => "tdc-separator-small",
                    "group" => "Filters style",
                ),
                array(
                    'param_name' => 'drop_arrow_size',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Arrow size',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '14',
                    "group"      => "Filters style"
                ),
                array(
                    "param_name" => "separator",
                    "type" => "horizontal_separator",
                    "value" => "",
                    "class" => "tdc-separator-small",
                    "group" => "Filters style",
                ),
                array(
                    'param_name' => 'drop_border',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Border size',
                    'description' => '',
                    'class' => 'tdc-textfield-big',
                    'placeholder' => '1',
                    "group"      => "Filters style"
                ),
                array(
                    "param_name" => "drop_border_style",
                    "type" => "dropdown-responsive",
                    "value" => array(
                        'Solid' => '',
                        'Dashed' => 'dashed',
                        'Dotted' => 'dotted',
                        'Double' => 'double',
                    ),
                    "heading" => 'Border style',
                    "description" => "",
                    "holder" => "div",
                    "class" => "tdc-dropdown-big",
                    "group" => "Filters style",
                ),
                array(
                    'param_name' => 'drop_border_radius',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Border radius',
                    'description' => '',
                    'class' => 'tdc-textfield-big',
                    'placeholder' => '0',
                    "group"      => "Filters style"
                ),
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Style',
                    "value"      => "",
                    "class"      => "tdc-separator-small",
                    "group"      => "Filters style"
                ),
                array(
                    "param_name" => "drop_color",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "",
                    "heading" => 'Text color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "drop_arrow_color",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "",
                    "heading" => 'Arrow color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "drop_bg_color",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-a",
                    "heading" => 'Background color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "drop_bg_color_f",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-b",
                    "heading" => 'Focus background color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "drop_border_color",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-a",
                    "heading" => 'Border color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "drop_border_color_f",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-b",
                    "heading" => 'Focus border color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "separator",
                    "type" => "horizontal_separator",
                    "value" => "",
                    "class" => "tdc-separator-small",
                    "group" => "Filters style",
                ),
            ),
            td_config_helper::get_map_block_font_array( 'f_drop', true, 'Dropdowns text', 'Filters style' ),
            array(
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Colors',
                    "value"      => "",
                    "class"      => "",
                    "group"      => "Filters style"
                ),
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Layout',
                    "value"      => "",
                    "class"      => "tdc-separator-small",
                    "group"      => "Filters style"
                ),
                array(
                    'param_name' => 'color_size',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Size',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '26',
                    "group"      => "Filters style"
                ),
                array(
                    'param_name' => 'color_margin',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Margin',
                    'description' => '',
                    'class' => 'tdc-textfield-big',
                    'placeholder' => '0 10px 0 0',
                    "group"      => "Filters style"
                ),
                array(
                    'param_name' => 'color_padd',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Padding',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '4',
                    "group"      => "Filters style"
                ),
                array(
                    'param_name' => 'all_color_border',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Border size',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '1',
                    "group"      => "Filters style"
                ),
                array(
                    'param_name' => 'all_color_border_s',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Selected option border size',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '2',
                    "group"      => "Filters style"
                ),
                array(
                    'param_name' => 'color_radius',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Border radius',
                    'description' => '',
                    'class' => 'tdc-textfield-big',
                    'placeholder' => '0',
                    "group"      => "Filters style"
                ),
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Style',
                    "value"      => "",
                    "class"      => "tdc-separator-small",
                    "group"      => "Filters style"
                ),
                array(
                    "param_name" => "color_bg",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-a",
                    "heading" => 'Background color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "color_bg_s",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-b",
                    "heading" => 'Selected item background color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "all_color_border_c",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-a",
                    "heading" => 'Border color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "all_color_border_c_s",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-b",
                    "heading" => 'Selected item border color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),

                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Buttons',
                    "value"      => "",
                    "class"      => "",
                    "group"      => "Filters style"
                ),
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Layout',
                    "value"      => "",
                    "class"      => "tdc-separator-small",
                    "group"      => "Filters style"
                ),
                array(
                    'param_name' => 'but_size',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Size',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '30',
                    "group"      => "Filters style"
                ),
                array(
                    'param_name' => 'but_margin',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Margin',
                    'description' => '',
                    'class' => 'tdc-textfield-big',
                    'placeholder' => '0 10px 0 0',
                    "group"      => "Filters style"
                ),
                array(
                    'param_name' => 'but_padd',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Padding',
                    'description' => '',
                    'class' => 'tdc-textfield-big',
                    'placeholder' => '0 5px',
                    "group"      => "Filters style"
                ),
                array(
                    'param_name' => 'all_but_border',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Border size',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '1',
                    "group"      => "Filters style"
                ),
                array(
                    'param_name' => 'all_but_border_s',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Selected option border size',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '2',
                    "group"      => "Filters style"
                ),
                array(
                    'param_name' => 'but_radius',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Border radius',
                    'description' => '',
                    'class' => 'tdc-textfield-big',
                    'placeholder' => '0',
                    "group"      => "Filters style"
                ),
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Style',
                    "value"      => "",
                    "class"      => "tdc-separator-small",
                    "group"      => "Filters style"
                ),
                array(
                    "param_name" => "but_txt",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-a",
                    "heading" => 'Text color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "but_txt_s",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-b",
                    "heading" => 'Selected item text color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "but_bg",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-a",
                    "heading" => 'Background color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "but_bg_s",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-b",
                    "heading" => 'Selected item background color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "all_but_border_c",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-a",
                    "heading" => 'Border color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "all_but_border_c_s",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-b",
                    "heading" => 'Selected item border color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "separator",
                    "type" => "horizontal_separator",
                    "value" => "",
                    "class" => "tdc-separator-small",
                    "group" => "Filters style",
                ),
            ),
            td_config_helper::get_map_block_font_array( 'f_but', true, 'Button text', 'Filters style' ),
            array(
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Checkboxes',
                    "value"      => "",
                    "class"      => "",
                    "group"      => "Filters style"
                ),
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Layout',
                    "value"      => "",
                    "class"      => "tdc-separator-small",
                    "group"      => "Filters style"
                ),
                array(
                    'param_name' => 'check_size',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Checkbox size',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '14',
                    "group"      => "Filters style"
                ),
                array(
                    'param_name' => 'check_space',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Checkbox right space',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '10',
                    "group"      => "Filters style"
                ),
                array(
                    'param_name' => 'all_check_border',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Checkbox border size',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '1',
                    "group"      => "Filters style"
                ),
                array(
                    'param_name' => 'all_check_border_s',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Selected checkbox border size',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '1',
                    "group"      => "Filters style"
                ),
                array(
                    'param_name' => 'check_radius',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Checkbox border radius',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '0',
                    "group"      => "Filters style"
                ),
                array(
                    'param_name'  => 'dot_size',
                    'type'        => 'range-responsive',
                    'value'       => '6',
                    'heading'     => 'Selected checkbox dot size',
                    'description' => '',
                    'class'       => 'tdc-textfield-small',
                    'range_min'   => '1',
                    'range_max'   => '12',
                    'range_step'  => '1',
                    "group"       => "Filters style",
                ),
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Style',
                    "value"      => "",
                    "class"      => "tdc-separator-small",
                    "group"      => "Filters style"
                ),
                array(
                    "param_name" => "check_bg",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-a",
                    "heading" => 'Checkbox background color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "check_bg_s",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-b",
                    "heading" => 'Selected checkbox background color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "all_check_border_color",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-a",
                    "heading" => 'Checkbox border color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "all_check_border_color_s",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-b",
                    "heading" => 'Selected checkbox border color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "check_square",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double",
                    "heading" => 'Selected checkbox dot color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "separator",
                    "type" => "horizontal_separator",
                    "value" => "",
                    "class" => "tdc-separator-small",
                    "group" => "Filters style",
                ),
                array(
                    "param_name" => "check_label_color",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-triple-a",
                    "heading" => 'Label color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "check_label_color_h",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-triple-b",
                    "heading" => 'Hover label color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "check_label_color_s",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-triple-c",
                    "heading" => 'Selected label color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
            ),
            td_config_helper::get_map_block_font_array( 'f_check', true, 'Label text', 'Filters style' ),
            td_config_helper::get_map_block_font_array( 'f_check_s', false, 'Selected label text', 'Filters style' ),

            array(
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Images',
                    "value"      => "",
                    "class"      => "",
                    "group"      => "Filters style"
                ),
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Layout',
                    "value"      => "",
                    "class"      => "tdc-separator-small",
                    "group"      => "Filters style"
                ),
                array(
                    "param_name" => "img_display",
                    "type" => "dropdown",
                    "value" => array(
                        'Inline images' => '',
                        'Image and text' => 'img_txt',
                    ),
                    "heading" => 'Display',
                    "description" => "",
                    "holder" => "div",
                    "class" => "tdc-dropdown-big",
                    "group"      => "Filters style"
                ),
                array(
                    'param_name' => 'img_margin',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Margin',
                    'description' => '',
                    'class' => 'tdc-textfield-big',
                    'placeholder' => '0 5px 5px 0',
                    "group"      => "Filters style"
                ),
                array(
                    "param_name" => "separator",
                    "type" => "horizontal_separator",
                    "value" => "",
                    "class" => "tdc-separator-small",
                    "group" => "Filters style",
                ),
                array(
                    'param_name' => 'img_size',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Image height',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '48',
                    "group"      => "Filters style"
                ),
                array(
                    'param_name' => 'img_padd',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Image padding',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '4',
                    "group"      => "Filters style"
                ),
                array(
                    'param_name' => 'all_img_border',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Image border size',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '1',
                    "group"      => "Filters style"
                ),
                array(
                    'param_name' => 'all_img_border_s',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Selected image border size',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '2',
                    "group"      => "Filters style"
                ),
                array(
                    'param_name' => 'img_radius',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Image border radius',
                    'description' => '',
                    'class' => 'tdc-textfield-big',
                    'placeholder' => '0',
                    "group"      => "Filters style"
                ),
                array(
                    "param_name" => "separator",
                    "type" => "horizontal_separator",
                    "value" => "",
                    "class" => "tdc-separator-small",
                    "group" => "Filters style",
                ),
                array(
                    'param_name' => 'img_txt_space',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Text space',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '10',
                    "group"      => "Filters style"
                ),
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Style',
                    "value"      => "",
                    "class"      => "tdc-separator-small",
                    "group"      => "Filters style"
                ),
                array(
                    "param_name" => "img_bg",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-a",
                    "heading" => 'Image background color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "img_bg_s",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-b",
                    "heading" => 'Selected image background color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "all_img_border_c",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-a",
                    "heading" => 'Image border color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "all_img_border_c_s",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-b",
                    "heading" => 'Selected image border color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "img_txt_color",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-a",
                    "heading" => 'Text color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "img_txt_color_s",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-b",
                    "heading" => 'Selected item text color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Filters style",
                ),
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Style',
                    "value"      => "",
                    "class"      => "tdc-separator-small",
                    "group"      => "Filters style"
                ),
            ),
            td_config_helper::get_map_block_font_array( 'f_img', true, 'Text', 'Filters style' )
		);

		return $settings;

	}

	/**
	 * product attributes settings array ( used by td_woo_add_to_cart shortcode )
	 *
	 * @return array
	 */
	static function td_woo_add_to_cart_attributes_settings() {
		$attributes = wc_get_attribute_taxonomies();
		$attributes_settings = array();

        if ( !empty( $attributes ) && is_array( $attributes ) ) {
            $attributes_settings[] = array(
                "param_name" => "separator",
                "type"       => "text_separator",
                'heading'    => 'Attributes types',
                "value"      => "",
                "class"      => "tdc-separator",
                "group"      => "Attributes"
            );

            foreach ( $attributes as $attribute ) {
                // attribute type
                $attributes_settings[] = array(
                    "param_name" => strtolower($attribute->attribute_name) . "_type",
                    "type" => "dropdown",
                    "value" => array(
                        'Select' => '',
                        'Color' => 'color',
                        'Button' => 'button',
                    ),
                    "heading" => $attribute->attribute_label,
                    "description" => "",
                    "holder" => "div",
                    "class" => "tdc-dropdown-big",
                    "group" => "Attributes",
                );
                $taxonomy_name = wc_attribute_taxonomy_name( $attribute->attribute_name );

                // we need to register tax to get its terms, without this the taxonomy doesn't exist at this point
                register_taxonomy(
                    $taxonomy_name,
                    apply_filters( 'woocommerce_taxonomy_objects_' . $taxonomy_name, array( 'product' ) ),
                    apply_filters(
                        'woocommerce_taxonomy_args_' . $taxonomy_name,
                        array(
                            'hierarchical' => true,
                            'show_ui'      => false,
                            'query_var'    => true,
                            'rewrite'      => false,
                        )
                    )
                );

            }
        }

        $attributes_settings = array_merge(
            $attributes_settings,
            array(
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Attributes general',
                    "value"      => "",
                    "class"      => "tdc-separator",
                    "group"      => "Attributes"
                ),
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Layout',
                    "value"      => "",
                    "class"      => "tdc-separator-small",
                    "group"      => "Attributes"
                ),
                array(
                    "param_name" => "row_display",
                    "type" => "dropdown-responsive",
                    "value" => array(
                        'Columns' => 'row',
                        'Rows' => 'column',
                    ),
                    "heading" => 'Attribute display',
                    "description" => "",
                    "holder" => "div",
                    "class" => "tdc-dropdown-big",
                    "group"      => "Attributes"
                ),
                array(
                    'param_name' => 'row_space',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Attribute bottom space',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '15',
                    "group"      => "Attributes"
                ),
                array(
                    "param_name" => "separator",
                    "type" => "horizontal_separator",
                    "value" => "",
                    "class" => "tdc-separator-small",
                    "group" => "Attributes",
                ),
                array(
                    'param_name' => 'label_width',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Labels width',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '25%',
                    "group"      => "Attributes"
                ),
                array(
                    'param_name' => 'label_space',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Labels space',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '20',
                    "group"      => "Attributes"
                ),
                array(
                    "param_name" => "label_horiz_align",
                    "type" => "dropdown-responsive",
                    "value" => array(
                        'Left' => 'content-horiz-left',
                        'Center' => 'content-horiz-center',
                        'Right' => 'content-horiz-right'
                    ),
                    "heading" => 'Labels horiz. align',
                    "description" => "",
                    "holder" => "div",
                    'tdc_dropdown_images' => true,
                    "class" => "tdc-visual-selector tdc-add-class",
                    "group"       => "Attributes",
                ),
                array(
                    "param_name" => "separator",
                    "type" => "horizontal_separator",
                    "value" => "",
                    "class" => "tdc-separator-small",
                    "group" => "Attributes",
                ),
                array(
                    'param_name' => 'drop_width',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Options width',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '75%',
                    "group"      => "Attributes"
                ),
                array(
                    "param_name" => "drop_horiz_align",
                    "type" => "dropdown-responsive",
                    "value" => array(
                        'Left' => 'content-horiz-left',
                        'Center' => 'content-horiz-center',
                        'Right' => 'content-horiz-right'
                    ),
                    "heading" => 'Options horiz. align',
                    "description" => "",
                    "holder" => "div",
                    'tdc_dropdown_images' => true,
                    "class" => "tdc-visual-selector tdc-add-class",
                    "group"       => "Attributes",
                ),
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Style',
                    "value"      => "",
                    "class"      => "tdc-separator-small",
                    "group"      => "Attributes"
                ),
                array(
                    "param_name" => "label_color",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "",
                    "heading" => 'Labels text color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Attributes",
                ),
                array(
                    "param_name" => "separator",
                    "type" => "horizontal_separator",
                    "value" => "",
                    "class" => "tdc-separator-small",
                    "group" => "Attributes",
                ),
            ),
            td_config_helper::get_map_block_font_array( 'f_label', true, 'Labels text', 'Attributes' ),
            array(
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Dropdowns',
                    "value"      => "",
                    "class"      => "",
                    "group"      => "Attributes"
                ),
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Layout',
                    "value"      => "",
                    "class"      => "tdc-separator-small",
                    "group"      => "Attributes"
                ),
                array(
                    'param_name' => 'drop_padding',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Padding',
                    'description' => '',
                    'class' => 'tdc-textfield-big',
                    'placeholder' => '9px 9px 9px 9px',
                    "group"      => "Attributes"
                ),
                array(
                    "param_name" => "separator",
                    "type" => "horizontal_separator",
                    "value" => "",
                    "class" => "tdc-separator-small",
                    "group" => "Attributes",
                ),
                array(
                    'param_name' => 'drop_arrow_size',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Arrow size',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '14',
                    "group"      => "Attributes"
                ),
                array(
                    "param_name" => "separator",
                    "type" => "horizontal_separator",
                    "value" => "",
                    "class" => "tdc-separator-small",
                    "group" => "Attributes",
                ),
                array(
                    'param_name' => 'drop_border',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Border size',
                    'description' => '',
                    'class' => 'tdc-textfield-big',
                    'placeholder' => '1',
                    "group"      => "Attributes"
                ),
                array(
                    "param_name" => "drop_border_style",
                    "type" => "dropdown-responsive",
                    "value" => array(
                        'Solid' => '',
                        'Dashed' => 'dashed',
                        'Dotted' => 'dotted',
                        'Double' => 'double',
                    ),
                    "heading" => 'Border style',
                    "description" => "",
                    "holder" => "div",
                    "class" => "tdc-dropdown-big",
                    "group" => "Attributes",
                ),
                array(
                    'param_name' => 'drop_border_radius',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Border radius',
                    'description' => '',
                    'class' => 'tdc-textfield-big',
                    'placeholder' => '0',
                    "group"      => "Attributes"
                ),
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Style',
                    "value"      => "",
                    "class"      => "tdc-separator-small",
                    "group"      => "Attributes"
                ),
                array(
                    "param_name" => "drop_color",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "",
                    "heading" => 'Text color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Attributes",
                ),
                array(
                    "param_name" => "drop_arrow_color",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "",
                    "heading" => 'Arrow color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Attributes",
                ),
                array(
                    "param_name" => "drop_bg_color",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-a",
                    "heading" => 'Background color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Attributes",
                ),
                array(
                    "param_name" => "drop_bg_color_f",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-b",
                    "heading" => 'Focus background color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Attributes",
                ),
                array(
                    "param_name" => "drop_border_color",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-a",
                    "heading" => 'Border color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Attributes",
                ),
                array(
                    "param_name" => "drop_border_color_f",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-b",
                    "heading" => 'Focus border color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Attributes",
                ),
                array(
                    "param_name" => "separator",
                    "type" => "horizontal_separator",
                    "value" => "",
                    "class" => "tdc-separator-small",
                    "group" => "Attributes",
                ),
            ),
            td_config_helper::get_map_block_font_array( 'f_drop', true, 'Dropdowns text', 'Attributes' ),
            array(
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Colors',
                    "value"      => "",
                    "class"      => "",
                    "group"      => "Attributes"
                ),
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Layout',
                    "value"      => "",
                    "class"      => "tdc-separator-small",
                    "group"      => "Attributes"
                ),
                array(
                    'param_name' => 'color_size',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Size',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '30',
                    "group"      => "Attributes"
                ),
                array(
                    'param_name' => 'color_margin',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Margin',
                    'description' => '',
                    'class' => 'tdc-textfield-big',
                    'placeholder' => '0 10px 0 0',
                    "group"      => "Attributes"
                ),
                array(
                    'param_name' => 'color_padd',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Padding',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '4',
                    "group"      => "Attributes"
                ),
                array(
                    'param_name' => 'all_color_border',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Border size',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '1',
                    "group"      => "Attributes"
                ),
                array(
                    'param_name' => 'all_color_border_s',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Selected option border size',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '2',
                    "group"      => "Attributes"
                ),
                array(
                    'param_name' => 'color_radius',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Border radius',
                    'description' => '',
                    'class' => 'tdc-textfield-big',
                    'placeholder' => '0',
                    "group"      => "Attributes"
                ),
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Style',
                    "value"      => "",
                    "class"      => "tdc-separator-small",
                    "group"      => "Attributes"
                ),
                array(
                    "param_name" => "color_bg",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-a",
                    "heading" => 'Background color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Attributes",
                ),
                array(
                    "param_name" => "color_bg_s",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-b",
                    "heading" => 'Selected item background color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Attributes",
                ),
                array(
                    "param_name" => "all_color_border_c",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-a",
                    "heading" => 'Border color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Attributes",
                ),
                array(
                    "param_name" => "all_color_border_c_s",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-b",
                    "heading" => 'Selected item border color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Attributes",
                ),

                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Buttons',
                    "value"      => "",
                    "class"      => "",
                    "group"      => "Attributes"
                ),
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Layout',
                    "value"      => "",
                    "class"      => "tdc-separator-small",
                    "group"      => "Attributes"
                ),
                array(
                    'param_name' => 'but_size',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Size',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '30',
                    "group"      => "Attributes"
                ),
                array(
                    'param_name' => 'but_margin',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Margin',
                    'description' => '',
                    'class' => 'tdc-textfield-big',
                    'placeholder' => '0 10px 0 0',
                    "group"      => "Attributes"
                ),
                array(
                    'param_name' => 'but_padd',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Padding',
                    'description' => '',
                    'class' => 'tdc-textfield-big',
                    'placeholder' => '0 5px',
                    "group"      => "Attributes"
                ),
                array(
                    'param_name' => 'all_but_border',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Border size',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '1',
                    "group"      => "Attributes"
                ),
                array(
                    'param_name' => 'all_but_border_s',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Selected option border size',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '2',
                    "group"      => "Attributes"
                ),
                array(
                    'param_name' => 'but_radius',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Border radius',
                    'description' => '',
                    'class' => 'tdc-textfield-big',
                    'placeholder' => '0',
                    "group"      => "Attributes"
                ),
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Style',
                    "value"      => "",
                    "class"      => "tdc-separator-small",
                    "group"      => "Attributes"
                ),
                array(
                    "param_name" => "but_txt",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-a",
                    "heading" => 'Text color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Attributes",
                ),
                array(
                    "param_name" => "but_txt_s",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-b",
                    "heading" => 'Selected item text color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Attributes",
                ),
                array(
                    "param_name" => "but_bg",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-a",
                    "heading" => 'Background color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Attributes",
                ),
                array(
                    "param_name" => "but_bg_s",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-b",
                    "heading" => 'Selected item background color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Attributes",
                ),
                array(
                    "param_name" => "all_but_border_c",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-a",
                    "heading" => 'Border color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Attributes",
                ),
                array(
                    "param_name" => "all_but_border_c_s",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker-double-b",
                    "heading" => 'Selected item border color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Attributes",
                ),
                array(
                    "param_name" => "separator",
                    "type" => "horizontal_separator",
                    "value" => "",
                    "class" => "tdc-separator-small",
                    "group" => "Attributes",
                ),
            ),
            td_config_helper::get_map_block_font_array( 'f_but', true, 'Button text', 'Attributes' ),
            array(
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Tooltips',
                    "value"      => "",
                    "class"      => "",
                    "group"      => "Attributes"
                ),
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Layout',
                    "value"      => "",
                    "class"      => "tdc-separator-small",
                    "group"      => "Attributes"
                ),
                array(
                    "param_name"  => "show_tooltip",
                    "type"        => "checkbox",
                    "value"       => '',
                    "heading"     => "Show tooltip in composer",
                    "description" => "",
                    "holder"      => "div",
                    "class"       => "",
                    "group"       => "Attributes",
                ),
                array(
                    "param_name" => "separator",
                    "type" => "horizontal_separator",
                    "value" => "",
                    "class" => "tdc-separator-small",
                    "group" => "Attributes",
                ),
                array(
                    'param_name' => 'tooltip_width',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Width',
                    'description' => '',
                    'class' => 'tdc-textfield-small',
                    'placeholder' => '80',
                    "group"      => "Attributes"
                ),
                array(
                    'param_name' => 'tooltip_padd',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Padding',
                    'description' => '',
                    'class' => 'tdc-textfield-big',
                    'placeholder' => '7',
                    "group"      => "Attributes"
                ),
                array(
                    'param_name' => 'tooltip_radius',
                    'type' => 'textfield-responsive',
                    'value' => '',
                    'heading' => 'Border radius',
                    'description' => '',
                    'class' => 'tdc-textfield-big',
                    'placeholder' => '3',
                    "group"      => "Attributes"
                ),
                array(
                    "param_name" => "separator",
                    "type"       => "text_separator",
                    'heading'    => 'Style',
                    "value"      => "",
                    "class"      => "tdc-separator-small",
                    "group"      => "Attributes"
                ),
                array(
                    "param_name" => "tooltip_txt",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker",
                    "heading" => 'Text color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Attributes",
                ),
                array(
                    "param_name" => "tooltip_bg",
                    "type" => "colorpicker",
                    "holder" => "div",
                    "class" => "td-colorpicker",
                    "heading" => 'Background color',
                    "value" => '',
                    "description" => '',
                    "group"      => "Attributes",
                ),
            ),
            td_config_helper::get_map_block_shadow_array('tooltip_shadow', 'Tooltip shadow', 15, 0, 7, "Attributes" ),
            array(
                array(
                    "param_name" => "separator",
                    "type" => "horizontal_separator",
                    "value" => "",
                    "class" => "tdc-separator-small",
                    "group" => "Attributes",
                ),
            ),
            td_config_helper::get_map_block_font_array( 'f_tooltip', true, 'Tooltip text', 'Attributes' )
        );

		return $attributes_settings;

	}

	/**
	 * product attributes start values array ( used by td_woo_add_to_cart shortcode )
	 *
	 * @return array
	 */
	static function td_woo_attributes_start_values() {
		$attributes = wc_get_attribute_taxonomies();
		$attributes_start_values = array();

		if ( !empty( $attributes ) && is_array( $attributes ) ) {
			foreach ( $attributes as $attribute ) {
				if ( isset( $attribute->attribute_type ) ) {
					$attributes_start_values[strtolower($attribute->attribute_name) . "_type"] = $attribute->attribute_type;
				}
			}
		}

		return $attributes_start_values;
	}

	/**
	 * product attributes values array ( used by td_woo_add_to_cart shortcode )
	 *
	 * @return array
	 */
	static function td_woo_get_attributes() {
		$attribute_taxonomies = wc_get_attribute_taxonomies();
		$attributes = array(
			'Not Set' => ''
		);

		if ( !empty( $attribute_taxonomies ) && is_array( $attribute_taxonomies ) ) {

			foreach ( $attribute_taxonomies as $attribute ) {
				$attribute_taxonomy_name = wc_attribute_taxonomy_name( $attribute->attribute_name );
				$attributes[$attribute->attribute_label] = $attribute_taxonomy_name;
			}

		}

		return $attributes;
	}

}
